/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.AbstractSet;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.jboss.util.NullArgumentException;
/*     */ 
/*     */ public class ListSet extends AbstractSet
/*     */   implements Set, Cloneable, Serializable
/*     */ {
/*     */   protected final List list;
/*     */ 
/*     */   public ListSet(List list)
/*     */   {
/*  57 */     if (list == null) {
/*  58 */       throw new NullArgumentException("list");
/*     */     }
/*     */ 
/*  61 */     int size = list.size();
/*  62 */     for (int i = 0; i < size; i++) {
/*  63 */       Object obj = list.get(i);
/*  64 */       if (list.indexOf(obj) != list.lastIndexOf(obj)) {
/*  65 */         throw new IllegalArgumentException("list contains duplicate entries");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  70 */     this.list = list;
/*     */   }
/*     */ 
/*     */   public ListSet()
/*     */   {
/*  77 */     this(new ArrayList());
/*     */   }
/*     */ 
/*     */   public ListSet(Collection elements)
/*     */   {
/*  87 */     this(new ArrayList(elements));
/*     */   }
/*     */ 
/*     */   public List getList()
/*     */   {
/*  92 */     return this.list;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 101 */     return this.list.size();
/*     */   }
/*     */ 
/*     */   public Iterator iterator()
/*     */   {
/* 110 */     return this.list.iterator();
/*     */   }
/*     */ 
/*     */   public boolean add(Object obj)
/*     */   {
/* 120 */     boolean added = false;
/*     */ 
/* 122 */     if (!this.list.contains(obj)) {
/* 123 */       added = this.list.add(obj);
/*     */     }
/*     */ 
/* 126 */     return added;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 135 */     return this.list.isEmpty();
/*     */   }
/*     */ 
/*     */   public boolean contains(Object obj)
/*     */   {
/* 145 */     return this.list.contains(obj);
/*     */   }
/*     */ 
/*     */   public boolean remove(Object obj)
/*     */   {
/* 155 */     return this.list.remove(obj);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 162 */     this.list.clear();
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*     */     try
/*     */     {
/* 172 */       return super.clone();
/*     */     } catch (CloneNotSupportedException e) {
/*     */     }
/* 175 */     throw new InternalError();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.ListSet
 * JD-Core Version:    0.6.0
 */