/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import org.jboss.util.NullArgumentException;
/*     */ 
/*     */ public class ListQueue extends AbstractQueue
/*     */ {
/*     */   protected final List list;
/*     */ 
/*     */   public ListQueue(List list, int maxSize)
/*     */   {
/*  52 */     super(maxSize);
/*     */ 
/*  54 */     if (list == null) {
/*  55 */       throw new NullArgumentException("list");
/*     */     }
/*  57 */     this.list = list;
/*     */   }
/*     */ 
/*     */   public ListQueue(int maxSize)
/*     */   {
/*  67 */     super(maxSize);
/*  68 */     this.list = new LinkedList();
/*     */   }
/*     */ 
/*     */   public ListQueue(List list)
/*     */   {
/*  79 */     this(list, -1);
/*     */   }
/*     */ 
/*     */   public ListQueue()
/*     */   {
/*  87 */     this(new LinkedList(), -1);
/*     */   }
/*     */ 
/*     */   protected boolean addLast(Object obj)
/*     */   {
/*  96 */     return this.list.add(obj);
/*     */   }
/*     */ 
/*     */   protected Object removeFirst()
/*     */   {
/* 105 */     return this.list.remove(0);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 114 */     return this.list.size();
/*     */   }
/*     */ 
/*     */   public Iterator iterator()
/*     */   {
/* 123 */     return this.list.iterator();
/*     */   }
/*     */ 
/*     */   public Object getFront()
/*     */     throws EmptyCollectionException
/*     */   {
/* 134 */     if (isEmpty()) {
/* 135 */       throw new EmptyCollectionException();
/*     */     }
/* 137 */     return this.list.get(0);
/*     */   }
/*     */ 
/*     */   public Object getBack()
/*     */     throws EmptyCollectionException
/*     */   {
/* 148 */     if (isEmpty()) {
/* 149 */       throw new EmptyCollectionException();
/*     */     }
/* 151 */     return this.list.get(this.list.size() - 1);
/*     */   }
/*     */ 
/*     */   public Iterator reverseIterator()
/*     */   {
/* 160 */     return new ReverseListIterator(this.list);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 169 */     return this.list.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.ListQueue
 * JD-Core Version:    0.6.0
 */