/*    */ package org.jboss.util.collection;
/*    */ 
/*    */ import java.util.Iterator;
/*    */ import java.util.NoSuchElementException;
/*    */ 
/*    */ public class CompoundIterator
/*    */   implements Iterator
/*    */ {
/*    */   protected final Iterator[] iters;
/*    */   protected int index;
/*    */ 
/*    */   public CompoundIterator(Iterator[] iters)
/*    */   {
/* 51 */     if ((iters == null) || (iters.length == 0)) {
/* 52 */       throw new IllegalArgumentException("array is null or empty");
/*    */     }
/* 54 */     this.iters = iters;
/*    */   }
/*    */ 
/*    */   public boolean hasNext()
/*    */   {
/* 63 */     for (; this.index < this.iters.length; this.index += 1) {
/* 64 */       if ((this.iters[this.index] != null) && (this.iters[this.index].hasNext())) {
/* 65 */         return true;
/*    */       }
/*    */     }
/*    */ 
/* 69 */     return false;
/*    */   }
/*    */ 
/*    */   public Object next()
/*    */   {
/* 80 */     if (!hasNext()) {
/* 81 */       throw new NoSuchElementException();
/*    */     }
/*    */ 
/* 84 */     return this.iters[this.index].next();
/*    */   }
/*    */ 
/*    */   public void remove()
/*    */   {
/* 94 */     this.iters[this.index].remove();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.CompoundIterator
 * JD-Core Version:    0.6.0
 */