/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import java.util.concurrent.CopyOnWriteArrayList;
/*     */ import java.util.concurrent.CopyOnWriteArraySet;
/*     */ 
/*     */ public class CollectionsFactory
/*     */ {
/*     */   public static final <K, V> Map<K, V> createLazyMap()
/*     */   {
/*  52 */     return new LazyMap();
/*     */   }
/*     */ 
/*     */   public static final <T> List<T> createLazyList()
/*     */   {
/*  63 */     return new LazyList();
/*     */   }
/*     */ 
/*     */   public static final <T> Set<T> createLazySet()
/*     */   {
/*  74 */     return new LazySet();
/*     */   }
/*     */ 
/*     */   public static final <K, V> Map<K, V> createConcurrentReaderMap()
/*     */   {
/*  86 */     return new ConcurrentHashMap();
/*     */   }
/*     */ 
/*     */   public static final <T> List<T> createCopyOnWriteList()
/*     */   {
/*  97 */     return new CopyOnWriteArrayList();
/*     */   }
/*     */ 
/*     */   public static final <T> Set<T> createCopyOnWriteSet()
/*     */   {
/* 108 */     return new CopyOnWriteArraySet();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.CollectionsFactory
 * JD-Core Version:    0.6.0
 */