/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.lang.ref.ReferenceQueue;
/*     */ import java.util.AbstractList;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import org.jboss.util.Objects;
/*     */ import org.jboss.util.SoftObject;
/*     */ 
/*     */ public class CachedList extends AbstractList
/*     */ {
/*  45 */   protected final ReferenceQueue queue = new ReferenceQueue();
/*     */   protected final List list;
/*     */ 
/*     */   public CachedList(List list)
/*     */   {
/*  56 */     this.list = list;
/*     */   }
/*     */ 
/*     */   public CachedList()
/*     */   {
/*  64 */     this(new LinkedList());
/*     */   }
/*     */ 
/*     */   private Object getObject(int index)
/*     */   {
/*  71 */     Object obj = this.list.get(index);
/*     */ 
/*  73 */     return Objects.deref(obj);
/*     */   }
/*     */ 
/*     */   public Object get(int index)
/*     */   {
/*  83 */     maintain();
/*  84 */     return getObject(index);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/*  93 */     maintain();
/*  94 */     return this.list.size();
/*     */   }
/*     */ 
/*     */   public Object set(int index, Object obj)
/*     */   {
/* 106 */     maintain();
/*     */ 
/* 108 */     SoftObject soft = SoftObject.create(obj, this.queue);
/* 109 */     soft = (SoftObject)this.list.set(index, soft);
/*     */ 
/* 111 */     return Objects.deref(soft);
/*     */   }
/*     */ 
/*     */   public void add(int index, Object obj)
/*     */   {
/* 124 */     maintain();
/*     */ 
/* 126 */     SoftObject soft = SoftObject.create(obj, this.queue);
/* 127 */     this.list.add(index, soft);
/*     */   }
/*     */ 
/*     */   public Object remove(int index)
/*     */   {
/* 139 */     maintain();
/*     */ 
/* 141 */     Object obj = this.list.remove(index);
/* 142 */     return Objects.deref(obj);
/*     */   }
/*     */ 
/*     */   private void maintain()
/*     */   {
/* 150 */     int count = 0;
/*     */     SoftObject obj;
/* 152 */     while ((obj = (SoftObject)this.queue.poll()) != null) {
/* 153 */       count++;
/* 154 */       this.list.remove(obj);
/*     */     }
/*     */ 
/* 157 */     if (count != 0)
/*     */     {
/* 159 */       System.err.println("vm reclaimed " + count + " objects");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.CachedList
 * JD-Core Version:    0.6.0
 */