/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Iterator;
/*     */ import java.util.NoSuchElementException;
/*     */ import org.jboss.util.NullArgumentException;
/*     */ 
/*     */ public class ArrayIterator
/*     */   implements Iterator, Serializable, Cloneable
/*     */ {
/*     */   protected final Object[] array;
/*     */   protected int index;
/*     */ 
/*     */   public ArrayIterator(Object[] array)
/*     */   {
/*  52 */     if (array == null) {
/*  53 */       throw new NullArgumentException("array");
/*     */     }
/*  55 */     this.array = array;
/*     */   }
/*     */ 
/*     */   public boolean hasNext()
/*     */   {
/*  64 */     return this.index < this.array.length;
/*     */   }
/*     */ 
/*     */   public Object next()
/*     */   {
/*  75 */     if (!hasNext()) {
/*  76 */       throw new NoSuchElementException();
/*     */     }
/*  78 */     return this.array[(this.index++)];
/*     */   }
/*     */ 
/*     */   public void remove()
/*     */   {
/*  87 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*     */     try
/*     */     {
/*  97 */       return super.clone();
/*     */     } catch (CloneNotSupportedException e) {
/*     */     }
/* 100 */     throw new InternalError();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.ArrayIterator
 * JD-Core Version:    0.6.0
 */