/*    */ package org.jboss.util.builder;
/*    */ 
/*    */ import java.security.PrivilegedAction;
/*    */ 
/*    */ public class AbstractBuilder<T>
/*    */   implements PrivilegedAction<T>
/*    */ {
/*    */   private Class<T> factoryClass;
/*    */   private String defaultFactory;
/*    */ 
/*    */   public AbstractBuilder(Class<T> factoryClass, String defaultFactory)
/*    */   {
/* 50 */     if (factoryClass == null)
/* 51 */       throw new IllegalArgumentException("Null factory class");
/* 52 */     if (defaultFactory == null)
/* 53 */       throw new IllegalArgumentException("Null default factory");
/* 54 */     this.factoryClass = factoryClass;
/* 55 */     this.defaultFactory = defaultFactory;
/*    */   }
/*    */ 
/*    */   public T run()
/*    */   {
/*    */     try
/*    */     {
/* 62 */       String className = System.getProperty(this.factoryClass.getName(), this.defaultFactory);
/* 63 */       Class clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
/* 64 */       Object object = clazz.newInstance();
/* 65 */       return this.factoryClass.cast(object);
/*    */     }
/*    */     catch (Throwable t) {
/*    */     }
/* 69 */     throw new RuntimeException("Error constructing " + this.factoryClass.getName(), t);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.builder.AbstractBuilder
 * JD-Core Version:    0.6.0
 */