/*     */ package org.jboss.util;
/*     */ 
/*     */ public class WorkerQueue
/*     */ {
/*     */   protected Thread m_queueThread;
/*     */   private JobItem m_currentJob;
/*     */ 
/*     */   public WorkerQueue()
/*     */   {
/*  46 */     this("Worker Thread");
/*     */   }
/*     */ 
/*     */   public WorkerQueue(String threadName)
/*     */   {
/*  54 */     this.m_queueThread = new Thread(createQueueLoop(), threadName);
/*     */   }
/*     */ 
/*     */   public WorkerQueue(String threadName, boolean isDaemon)
/*     */   {
/*  63 */     this.m_queueThread = new Thread(createQueueLoop(), threadName);
/*  64 */     this.m_queueThread.setDaemon(isDaemon);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*  73 */     if (this.m_queueThread != null) this.m_queueThread.start();
/*     */   }
/*     */ 
/*     */   public synchronized void stop()
/*     */   {
/*  88 */     if (this.m_queueThread != null) this.m_queueThread.interrupt();
/*     */   }
/*     */ 
/*     */   public synchronized void putJob(Executable job)
/*     */   {
/*  99 */     if ((this.m_queueThread == null) || (!this.m_queueThread.isAlive())) {
/* 100 */       throw new IllegalStateException("Can't put job, thread is not alive or not present");
/*     */     }
/*     */ 
/* 103 */     if (isInterrupted()) {
/* 104 */       throw new IllegalStateException("Can't put job, thread was interrupted");
/*     */     }
/*     */ 
/* 107 */     putJobImpl(job);
/*     */   }
/*     */ 
/*     */   protected boolean isInterrupted()
/*     */   {
/* 120 */     return this.m_queueThread.isInterrupted();
/*     */   }
/*     */ 
/*     */   protected synchronized Executable getJob()
/*     */     throws InterruptedException
/*     */   {
/* 132 */     if ((this.m_queueThread == null) || (!this.m_queueThread.isAlive())) {
/* 133 */       throw new IllegalStateException();
/*     */     }
/*     */ 
/* 136 */     return getJobImpl();
/*     */   }
/*     */ 
/*     */   protected Executable getJobImpl()
/*     */     throws InterruptedException
/*     */   {
/* 148 */     while (this.m_currentJob == null) wait();
/*     */ 
/* 150 */     JobItem item = this.m_currentJob;
/*     */ 
/* 152 */     this.m_currentJob = this.m_currentJob.m_next;
/* 153 */     return item.m_job;
/*     */   }
/*     */ 
/*     */   protected void putJobImpl(Executable job)
/*     */   {
/* 163 */     JobItem posted = new JobItem(job, null);
/* 164 */     if (this.m_currentJob == null)
/*     */     {
/* 168 */       this.m_currentJob = posted;
/* 169 */       notifyAll();
/*     */     }
/*     */     else
/*     */     {
/* 173 */       JobItem item = this.m_currentJob;
/*     */ 
/* 176 */       while (item.m_next != null) item = item.m_next;
/* 177 */       JobItem.access$002(item, posted);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void clear()
/*     */   {
/* 187 */     this.m_queueThread = null;
/* 188 */     this.m_currentJob = null;
/*     */   }
/*     */ 
/*     */   protected Runnable createQueueLoop()
/*     */   {
/* 196 */     return new QueueLoop();
/*     */   }
/*     */ 
/*     */   private class JobItem
/*     */   {
/*     */     private Executable m_job;
/*     */     private JobItem m_next;
/*     */ 
/*     */     private JobItem(Executable job)
/*     */     {
/* 260 */       this.m_job = job;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class QueueLoop
/*     */     implements Runnable
/*     */   {
/*     */     protected QueueLoop()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       try
/*     */       {
/* 240 */         label0: return;
/*     */       }
/*     */       catch (InterruptedException e)
/*     */       {
/* 234 */         break label0;
/*     */       }
/*     */       finally
/*     */       {
/* 238 */         WorkerQueue.this.clear();
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void flush()
/*     */       throws Exception
/*     */     {
/* 245 */       while (WorkerQueue.this.m_currentJob != null)
/*     */       {
/* 247 */         WorkerQueue.access$300(WorkerQueue.this).m_job.execute();
/* 248 */         WorkerQueue.access$302(WorkerQueue.this, WorkerQueue.access$300(WorkerQueue.this).m_next);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.WorkerQueue
 * JD-Core Version:    0.6.0
 */