/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.lang.ref.ReferenceQueue;
/*     */ import java.lang.ref.WeakReference;
/*     */ 
/*     */ public final class WeakObject extends WeakReference
/*     */ {
/*     */   protected final int hashCode;
/*     */ 
/*     */   public WeakObject(Object obj)
/*     */   {
/*  47 */     super(obj);
/*  48 */     this.hashCode = obj.hashCode();
/*     */   }
/*     */ 
/*     */   public WeakObject(Object obj, ReferenceQueue queue)
/*     */   {
/*  58 */     super(obj, queue);
/*  59 */     this.hashCode = obj.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  69 */     if (obj == this) return true;
/*     */ 
/*  71 */     if ((obj != null) && (obj.getClass() == getClass())) {
/*  72 */       WeakObject soft = (WeakObject)obj;
/*     */ 
/*  74 */       Object a = get();
/*  75 */       Object b = soft.get();
/*  76 */       if ((a == null) || (b == null)) return false;
/*  77 */       if (a == b) return true;
/*     */ 
/*  79 */       return a.equals(b);
/*     */     }
/*     */ 
/*  82 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*  91 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public static WeakObject create(Object obj)
/*     */   {
/* 106 */     if (obj == null) return null;
/* 107 */     return new WeakObject(obj);
/*     */   }
/*     */ 
/*     */   public static WeakObject create(Object obj, ReferenceQueue queue)
/*     */   {
/* 120 */     if (obj == null) return null;
/* 121 */     return new WeakObject(obj, queue);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.WeakObject
 * JD-Core Version:    0.6.0
 */