/*     */ package org.jboss.util;
/*     */ 
/*     */ public class TimerQueue extends WorkerQueue
/*     */ {
/*     */   private Heap m_heap;
/*     */ 
/*     */   public TimerQueue()
/*     */   {
/*  52 */     this("TimerTask Thread");
/*     */   }
/*     */ 
/*     */   public TimerQueue(String threadName)
/*     */   {
/*  59 */     super(threadName);
/*  60 */     this.m_heap = new Heap();
/*     */   }
/*     */ 
/*     */   public void schedule(TimerTask t)
/*     */   {
/*  69 */     schedule(t, 0L);
/*     */   }
/*     */ 
/*     */   public void schedule(TimerTask t, long delay)
/*     */   {
/*  77 */     if (t == null) throw new IllegalArgumentException("Can't schedule a null TimerTask");
/*  78 */     if (delay < 0L) delay = 0L;
/*  79 */     t.setNextExecutionTime(System.currentTimeMillis() + delay);
/*  80 */     putJob(t);
/*     */   }
/*     */ 
/*     */   protected void putJobImpl(Executable task)
/*     */   {
/*  88 */     this.m_heap.insert(task);
/*  89 */     ((TimerTask)task).setState(2);
/*  90 */     notifyAll();
/*     */   }
/*     */ 
/*     */   protected Executable getJobImpl() throws InterruptedException {
/*  94 */     while (this.m_heap.peek() == null)
/*     */     {
/*  96 */       wait();
/*     */     }
/*  98 */     TimerTask task = (TimerTask)this.m_heap.extract();
/*  99 */     switch (task.getState())
/*     */     {
/*     */     case 3:
/*     */     case 4:
/* 104 */       task = null;
/* 105 */       return getJobImpl();
/*     */     case 1:
/*     */     case 2:
/* 108 */       return task;
/*     */     }
/* 110 */     throw new IllegalStateException("TimerTask has an illegal state");
/*     */   }
/*     */ 
/*     */   protected Runnable createQueueLoop()
/*     */   {
/* 115 */     return new TimerTaskLoop();
/*     */   }
/*     */ 
/*     */   protected void clear() {
/* 119 */     super.clear();
/* 120 */     synchronized (this)
/*     */     {
/* 122 */       this.m_heap.clear();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class TimerTaskLoop
/*     */     implements Runnable
/*     */   {
/*     */     protected TimerTaskLoop()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       try
/*     */       {
/*     */         label0: TimerTask task;
/*     */         long now;
/*     */         long executionTime;
/*     */         long timeToWait;
/*     */         boolean runTask;
/*     */         Object mutex;
/* 196 */         return;
/*     */       }
/*     */       catch (InterruptedException e)
/*     */       {
/* 192 */         break label0;
/*     */       }
/*     */       finally {
/* 195 */         TimerQueue.this.clear();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.TimerQueue
 * JD-Core Version:    0.6.0
 */