/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ 
/*     */ public final class ThrowableHandler
/*     */ {
/*  58 */   protected static List listeners = Collections.synchronizedList(new ArrayList());
/*     */ 
/*     */   public static void addThrowableListener(ThrowableListener listener)
/*     */   {
/*  68 */     if (!listeners.contains(listener))
/*  69 */       listeners.add(listener);
/*     */   }
/*     */ 
/*     */   public static void removeThrowableListener(ThrowableListener listener)
/*     */   {
/*  79 */     listeners.remove(listener);
/*     */   }
/*     */ 
/*     */   protected static void fireOnThrowable(int type, Throwable t)
/*     */   {
/*  89 */     Object[] list = listeners.toArray();
/*     */ 
/*  91 */     for (int i = 0; i < list.length; i++)
/*  92 */       ((ThrowableListener)list[i]).onThrowable(type, t);
/*     */   }
/*     */ 
/*     */   public static void add(int type, Throwable t)
/*     */   {
/* 109 */     if (t == null) return;
/*     */     try
/*     */     {
/* 112 */       fireOnThrowable(type, t);
/*     */     }
/*     */     catch (Throwable bad)
/*     */     {
/* 116 */       System.err.println("Unable to handle throwable: " + t + " because of:");
/* 117 */       bad.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void add(Throwable t)
/*     */   {
/* 127 */     add(0, t);
/*     */   }
/*     */ 
/*     */   public static void addError(Throwable t)
/*     */   {
/* 136 */     add(1, t);
/*     */   }
/*     */ 
/*     */   public static void addWarning(Throwable t)
/*     */   {
/* 145 */     add(1, t);
/*     */   }
/*     */ 
/*     */   public static abstract interface Type
/*     */   {
/*     */     public static final int UNKNOWN = 0;
/*     */     public static final int ERROR = 1;
/*     */     public static final int WARNING = 2;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.ThrowableHandler
 * JD-Core Version:    0.6.0
 */