/*    */ package org.jboss.util;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedAction;
/*    */ 
/*    */ class SysPropertyActions
/*    */ {
/*    */   public static String getProperty(String name, String defaultValue)
/*    */   {
/*    */     String prop;
/*    */     String prop;
/* 63 */     if (System.getSecurityManager() == null)
/* 64 */       prop = SysProps.NON_PRIVILEDGED.getProperty(name, defaultValue);
/*    */     else
/* 66 */       prop = SysProps.PRIVILEDGED.getProperty(name, defaultValue);
/* 67 */     return prop;
/*    */   }
/*    */ 
/*    */   static abstract interface SysProps
/*    */   {
/* 36 */     public static final SysProps NON_PRIVILEDGED = new SysProps()
/*    */     {
/*    */       public String getProperty(String name, String defaultValue)
/*    */       {
/* 40 */         return System.getProperty(name, defaultValue);
/*    */       }
/* 36 */     };
/*    */ 
/* 43 */     public static final SysProps PRIVILEDGED = new SysProps()
/*    */     {
/*    */       public String getProperty(String name, String defaultValue)
/*    */       {
/* 47 */         PrivilegedAction action = new PrivilegedAction(name, defaultValue)
/*    */         {
/*    */           public Object run()
/*    */           {
/* 51 */             return System.getProperty(this.val$name, this.val$defaultValue);
/*    */           }
/*    */         };
/* 54 */         return (String)AccessController.doPrivileged(action);
/*    */       }
/* 43 */     };
/*    */ 
/*    */     public abstract String getProperty(String paramString1, String paramString2);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.SysPropertyActions
 * JD-Core Version:    0.6.0
 */