/*      */ package org.jboss.util;
/*      */ 
/*      */ import java.io.File;
/*      */ import java.io.IOException;
/*      */ import java.net.MalformedURLException;
/*      */ import java.net.URI;
/*      */ import java.net.URISyntaxException;
/*      */ import java.net.URL;
/*      */ import java.util.Map;
/*      */ 
/*      */ public final class Strings
/*      */ {
/*      */   public static final String EMPTY = "";
/*      */   private static final long MSEC = 1L;
/*      */   private static final long SECS = 1000L;
/*      */   private static final long MINS = 60000L;
/*      */   private static final long HOUR = 3600000L;
/*   56 */   private static final String[] keywords = { "abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null" };
/*      */ 
/*  116 */   private static final String[] ejbQlIdentifiers = { "AND", "AS", "BETWEEN", "DISTINCT", "EMPTY", "FALSE", "FROM", "IN", "IS", "LIKE", "MEMBER", "NOT", "NULL", "OBJECT", "OF", "OR", "SELECT", "UNKNOWN", "TRUE", "WHERE" };
/*      */ 
/*      */   public static String subst(StringBuffer buff, String from, String to, String string)
/*      */   {
/*  156 */     int begin = 0; int end = 0;
/*      */ 
/*  158 */     while ((end = string.indexOf(from, end)) != -1)
/*      */     {
/*  161 */       buff.append(string.substring(begin, end));
/*      */ 
/*  164 */       buff.append(to);
/*      */ 
/*  167 */       begin = end + from.length();
/*  168 */       end = begin;
/*      */     }
/*      */ 
/*  172 */     buff.append(string.substring(begin, string.length()));
/*      */ 
/*  174 */     return buff.toString();
/*      */   }
/*      */ 
/*      */   public static String subst(String from, String to, String string)
/*      */   {
/*  188 */     return subst(new StringBuffer(), from, to, string);
/*      */   }
/*      */ 
/*      */   public static String subst(StringBuffer buff, String string, Map map, String beginToken, String endToken)
/*      */   {
/*  205 */     int begin = 0; int rangeEnd = 0;
/*      */     Range range;
/*  208 */     while ((range = rangeOf(beginToken, endToken, string, rangeEnd)) != null)
/*      */     {
/*  211 */       buff.append(string.substring(begin, range.begin));
/*      */ 
/*  214 */       String key = string.substring(range.begin + beginToken.length(), range.end);
/*      */ 
/*  216 */       Object value = map.get(key);
/*      */ 
/*  218 */       if (value == null) value = "";
/*      */ 
/*  221 */       buff.append(value);
/*      */ 
/*  224 */       begin = range.end + endToken.length();
/*  225 */       rangeEnd = begin;
/*      */     }
/*      */ 
/*  229 */     buff.append(string.substring(begin, string.length()));
/*      */ 
/*  231 */     return buff.toString();
/*      */   }
/*      */ 
/*      */   public static String subst(String string, Map map, String beginToken, String endToken)
/*      */   {
/*  246 */     return subst(new StringBuffer(), string, map, beginToken, endToken);
/*      */   }
/*      */ 
/*      */   public static String subst(StringBuffer buff, String string, String[] replace, char token)
/*      */   {
/*  266 */     int i = string.length();
/*  267 */     for (int j = 0; (j >= 0) && (j < i); j++)
/*      */     {
/*  269 */       char c = string.charAt(j);
/*      */ 
/*  272 */       if (c == token)
/*      */       {
/*  276 */         if (j == i)
/*      */           continue;
/*  278 */         int k = Character.digit(string.charAt(j + 1), 10);
/*      */ 
/*  280 */         if (k == -1)
/*      */         {
/*  282 */           buff.append(string.charAt(j + 1));
/*      */         }
/*  284 */         else if (k < replace.length)
/*      */         {
/*  286 */           buff.append(replace[k]);
/*      */         }
/*      */ 
/*  289 */         j++;
/*      */       }
/*      */       else
/*      */       {
/*  294 */         buff.append(c);
/*      */       }
/*      */     }
/*      */ 
/*  298 */     return buff.toString();
/*      */   }
/*      */ 
/*      */   public static String subst(String string, String[] replace, char token)
/*      */   {
/*  316 */     return subst(new StringBuffer(), string, replace, token);
/*      */   }
/*      */ 
/*      */   public static String subst(String string, String[] replace)
/*      */   {
/*  332 */     return subst(new StringBuffer(), string, replace, '%');
/*      */   }
/*      */ 
/*      */   public static Range rangeOf(String beginToken, String endToken, String string, int fromIndex)
/*      */   {
/*  382 */     int begin = string.indexOf(beginToken, fromIndex);
/*      */ 
/*  384 */     if (begin != -1)
/*      */     {
/*  386 */       int end = string.indexOf(endToken, begin + 1);
/*  387 */       if (end != -1)
/*      */       {
/*  389 */         return new Range(begin, end);
/*      */       }
/*      */     }
/*      */ 
/*  393 */     return null;
/*      */   }
/*      */ 
/*      */   public static Range rangeOf(String beginToken, String endToken, String string)
/*      */   {
/*  407 */     return rangeOf(beginToken, endToken, string, 0);
/*      */   }
/*      */ 
/*      */   public static String[] split(String string, String delim, int limit)
/*      */   {
/*  430 */     int count = count(string, delim) + 1;
/*  431 */     if ((limit > 0) && (count > limit))
/*      */     {
/*  433 */       count = limit;
/*      */     }
/*      */ 
/*  436 */     String[] strings = new String[count];
/*  437 */     int begin = 0;
/*      */ 
/*  439 */     for (int i = 0; i < count; i++)
/*      */     {
/*  442 */       int end = string.indexOf(delim, begin);
/*      */ 
/*  446 */       if ((end == -1) || (i + 1 == count)) {
/*  447 */         end = string.length();
/*      */       }
/*      */ 
/*  450 */       if (end == 0)
/*  451 */         strings[i] = "";
/*      */       else {
/*  453 */         strings[i] = string.substring(begin, end);
/*      */       }
/*      */ 
/*  456 */       begin = end + 1;
/*      */     }
/*      */ 
/*  459 */     return strings;
/*      */   }
/*      */ 
/*      */   public static String[] split(String string, String delim)
/*      */   {
/*  471 */     return split(string, delim, -1);
/*      */   }
/*      */ 
/*      */   public static String join(StringBuffer buff, Object[] array, String delim)
/*      */   {
/*  490 */     boolean haveDelim = delim != null;
/*      */ 
/*  492 */     for (int i = 0; i < array.length; i++)
/*      */     {
/*  494 */       buff.append(array[i]);
/*      */ 
/*  497 */       if ((!haveDelim) || (i + 1 >= array.length))
/*      */         continue;
/*  499 */       buff.append(delim);
/*      */     }
/*      */ 
/*  503 */     return buff.toString();
/*      */   }
/*      */ 
/*      */   public static String join(Object[] array, String delim)
/*      */   {
/*  515 */     return join(new StringBuffer(), array, delim);
/*      */   }
/*      */ 
/*      */   public static String join(Object[] array)
/*      */   {
/*  526 */     return join(array, null);
/*      */   }
/*      */ 
/*      */   public static String join(byte[] array)
/*      */   {
/*  537 */     Byte[] bytes = new Byte[array.length];
/*  538 */     for (int i = 0; i < bytes.length; i++)
/*      */     {
/*  540 */       bytes[i] = new Byte(array[i]);
/*      */     }
/*      */ 
/*  543 */     return join(bytes, null);
/*      */   }
/*      */ 
/*      */   public static String join(StringBuffer buff, Object[] array, String prefix, String separator, String suffix)
/*      */   {
/*  561 */     buff.append(prefix);
/*  562 */     join(buff, array, separator);
/*  563 */     buff.append(suffix);
/*      */ 
/*  565 */     return buff.toString();
/*      */   }
/*      */ 
/*      */   public static String join(Object[] array, String prefix, String separator, String suffix)
/*      */   {
/*  581 */     return join(new StringBuffer(), array, prefix, separator, suffix);
/*      */   }
/*      */ 
/*      */   public static int count(String string, String substring)
/*      */   {
/*  598 */     int count = 0;
/*  599 */     int idx = 0;
/*      */ 
/*  601 */     while ((idx = string.indexOf(substring, idx)) != -1)
/*      */     {
/*  603 */       idx++;
/*  604 */       count++;
/*      */     }
/*      */ 
/*  607 */     return count;
/*      */   }
/*      */ 
/*      */   public static int count(String string, char c)
/*      */   {
/*  619 */     return count(string, String.valueOf(c));
/*      */   }
/*      */ 
/*      */   public static String pad(StringBuffer buff, String string, int count)
/*      */   {
/*  638 */     for (int i = 0; i < count; i++)
/*      */     {
/*  640 */       buff.append(string);
/*      */     }
/*      */ 
/*  643 */     return buff.toString();
/*      */   }
/*      */ 
/*      */   public static String pad(String string, int count)
/*      */   {
/*  655 */     return pad(new StringBuffer(), string, count);
/*      */   }
/*      */ 
/*      */   public static String pad(Object obj, int count)
/*      */   {
/*  668 */     return pad(new StringBuffer(), String.valueOf(obj), count);
/*      */   }
/*      */ 
/*      */   public static boolean compare(String me, String you)
/*      */   {
/*  686 */     if (me == you) {
/*  687 */       return true;
/*      */     }
/*      */ 
/*  690 */     if ((me == null) && (you != null)) {
/*  691 */       return false;
/*      */     }
/*      */ 
/*  694 */     return me.equals(you);
/*      */   }
/*      */ 
/*      */   public static boolean isEmpty(String string)
/*      */   {
/*  705 */     return string.equals("");
/*      */   }
/*      */ 
/*      */   public static int nthIndexOf(String string, String token, int index)
/*      */   {
/*  719 */     int j = 0;
/*      */ 
/*  721 */     for (int i = 0; i < index; i++)
/*      */     {
/*  723 */       j = string.indexOf(token, j + 1);
/*  724 */       if (j == -1)
/*      */         break;
/*      */     }
/*  727 */     return j;
/*      */   }
/*      */ 
/*      */   public static String capitalize(String string)
/*      */   {
/*  740 */     if (string == null)
/*  741 */       throw new NullArgumentException("string");
/*  742 */     if (string.equals("")) {
/*  743 */       throw new EmptyStringException("string");
/*      */     }
/*  745 */     return Character.toUpperCase(string.charAt(0)) + string.substring(1);
/*      */   }
/*      */ 
/*      */   public static String[] trim(String[] strings)
/*      */   {
/*  758 */     for (int i = 0; i < strings.length; i++)
/*      */     {
/*  760 */       strings[i] = strings[i].trim();
/*      */     }
/*      */ 
/*  763 */     return strings;
/*      */   }
/*      */ 
/*      */   public static URL toURL(String urlspec, String relativePrefix)
/*      */     throws MalformedURLException
/*      */   {
/*  786 */     urlspec = urlspec.trim();
/*      */     URL url;
/*      */     try
/*      */     {
/*  792 */       url = new URL(urlspec);
/*  793 */       if (url.getProtocol().equals("file"))
/*      */       {
/*  795 */         url = makeURLFromFilespec(url.getFile(), relativePrefix);
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*      */       try
/*      */       {
/*  803 */         url = makeURLFromFilespec(urlspec, relativePrefix);
/*      */       }
/*      */       catch (IOException n)
/*      */       {
/*  810 */         throw new MalformedURLException(n.toString());
/*      */       }
/*      */     }
/*      */ 
/*  814 */     return url;
/*      */   }
/*      */ 
/*      */   public static URI toURI(String urispec, String relativePrefix)
/*      */     throws URISyntaxException
/*      */   {
/*  820 */     urispec = urispec.trim();
/*      */     URI uri;
/*      */     URI uri;
/*  824 */     if (urispec.startsWith("file:"))
/*      */     {
/*  826 */       uri = makeURIFromFilespec(urispec.substring(5), relativePrefix);
/*      */     }
/*      */     else
/*      */     {
/*  830 */       uri = new URI(urispec);
/*      */     }
/*      */ 
/*  833 */     return uri;
/*      */   }
/*      */ 
/*      */   private static URL makeURLFromFilespec(String filespec, String relativePrefix)
/*      */     throws IOException
/*      */   {
/*  841 */     File file = new File(filespec);
/*      */ 
/*  844 */     if ((relativePrefix != null) && (!file.isAbsolute()))
/*      */     {
/*  846 */       file = new File(relativePrefix, filespec);
/*      */     }
/*      */ 
/*  850 */     file = file.getCanonicalFile();
/*      */ 
/*  852 */     return file.toURL();
/*      */   }
/*      */ 
/*      */   private static URI makeURIFromFilespec(String filespec, String relativePrefix)
/*      */   {
/*  858 */     File file = new File(filespec);
/*      */ 
/*  861 */     if ((relativePrefix != null) && (!file.isAbsolute()))
/*      */     {
/*  863 */       file = new File(relativePrefix, filespec);
/*      */     }
/*      */ 
/*  866 */     return file.toURI();
/*      */   }
/*      */ 
/*      */   public static URL toURL(String urlspec)
/*      */     throws MalformedURLException
/*      */   {
/*  881 */     return toURL(urlspec, null);
/*      */   }
/*      */ 
/*      */   public static URI toURI(String urispec)
/*      */     throws URISyntaxException
/*      */   {
/*  893 */     return toURI(urispec, null);
/*      */   }
/*      */ 
/*      */   public static final boolean isJavaKeyword(String s)
/*      */   {
/*  907 */     if ((s == null) || (s.length() == 0))
/*      */     {
/*  909 */       return false;
/*      */     }
/*      */ 
/*  912 */     for (int i = 0; i < keywords.length; i++)
/*      */     {
/*  914 */       if (keywords[i].equals(s))
/*      */       {
/*  916 */         return true;
/*      */       }
/*      */     }
/*      */ 
/*  920 */     return false;
/*      */   }
/*      */ 
/*      */   public static final boolean isEjbQlIdentifier(String s)
/*      */   {
/*  934 */     if ((s == null) || (s.length() == 0))
/*      */     {
/*  936 */       return false;
/*      */     }
/*      */ 
/*  939 */     for (int i = 0; i < ejbQlIdentifiers.length; i++)
/*      */     {
/*  941 */       if (ejbQlIdentifiers[i].equalsIgnoreCase(s))
/*      */       {
/*  943 */         return true;
/*      */       }
/*      */     }
/*      */ 
/*  947 */     return false;
/*      */   }
/*      */ 
/*      */   public static final boolean isValidJavaIdentifier(String s)
/*      */   {
/*  965 */     if ((s == null) || (s.length() == 0))
/*      */     {
/*  967 */       return false;
/*      */     }
/*      */ 
/*  970 */     char[] c = s.toCharArray();
/*  971 */     if (!Character.isJavaIdentifierStart(c[0]))
/*      */     {
/*  973 */       return false;
/*      */     }
/*      */ 
/*  976 */     for (int i = 1; i < c.length; i++)
/*      */     {
/*  978 */       if (!Character.isJavaIdentifierPart(c[i]))
/*      */       {
/*  980 */         return false;
/*      */       }
/*      */     }
/*      */ 
/*  984 */     return true;
/*      */   }
/*      */ 
/*      */   public static String removeWhiteSpace(String s)
/*      */   {
/*  995 */     String retn = null;
/*      */ 
/*  997 */     if (s != null)
/*      */     {
/*  999 */       int len = s.length();
/* 1000 */       StringBuffer sbuf = new StringBuffer(len);
/*      */ 
/* 1002 */       for (int i = 0; i < len; i++)
/*      */       {
/* 1004 */         char c = s.charAt(i);
/*      */ 
/* 1006 */         if (!Character.isWhitespace(c))
/* 1007 */           sbuf.append(c);
/*      */       }
/* 1009 */       retn = sbuf.toString();
/*      */     }
/* 1011 */     return retn;
/*      */   }
/*      */ 
/*      */   public static final String defaultToString(Object object)
/*      */   {
/* 1022 */     if (object == null) {
/* 1023 */       return "null";
/*      */     }
/* 1025 */     return object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
/*      */   }
/*      */ 
/*      */   public static final void defaultToString(JBossStringBuilder buffer, Object object)
/*      */   {
/* 1037 */     if (object == null) {
/* 1038 */       buffer.append("null");
/*      */     }
/*      */     else {
/* 1041 */       buffer.append(object.getClass().getName());
/* 1042 */       buffer.append('@');
/* 1043 */       buffer.append(Integer.toHexString(System.identityHashCode(object)));
/*      */     }
/*      */   }
/*      */ 
/*      */   public static final void defaultToString(StringBuffer buffer, Object object)
/*      */   {
/* 1056 */     if (object == null) {
/* 1057 */       buffer.append("null");
/*      */     }
/*      */     else {
/* 1060 */       buffer.append(object.getClass().getName());
/* 1061 */       buffer.append('@');
/* 1062 */       buffer.append(Integer.toHexString(System.identityHashCode(object)));
/*      */     }
/*      */   }
/*      */ 
/*      */   public static long parseTimePeriod(String period)
/*      */   {
/*      */     try
/*      */     {
/* 1088 */       String s = period.toLowerCase();
/*      */       long factor;
/*      */       long factor;
/* 1092 */       if (s.endsWith("msec"))
/*      */       {
/* 1094 */         s = s.substring(0, s.lastIndexOf("msec"));
/* 1095 */         factor = 1L;
/*      */       }
/*      */       else
/*      */       {
/*      */         long factor;
/* 1097 */         if (s.endsWith("sec"))
/*      */         {
/* 1099 */           s = s.substring(0, s.lastIndexOf("sec"));
/* 1100 */           factor = 1000L;
/*      */         }
/*      */         else
/*      */         {
/*      */           long factor;
/* 1102 */           if (s.endsWith("min"))
/*      */           {
/* 1104 */             s = s.substring(0, s.lastIndexOf("min"));
/* 1105 */             factor = 60000L;
/*      */           }
/*      */           else
/*      */           {
/*      */             long factor;
/* 1107 */             if (s.endsWith("h"))
/*      */             {
/* 1109 */               s = s.substring(0, s.lastIndexOf("h"));
/* 1110 */               factor = 3600000L;
/*      */             }
/*      */             else
/*      */             {
/* 1114 */               factor = 1L;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/* 1116 */       return Long.parseLong(s) * factor;
/*      */     }
/*      */     catch (RuntimeException e)
/*      */     {
/*      */     }
/* 1121 */     throw new NumberFormatException("For input time period: '" + period + "'");
/*      */   }
/*      */ 
/*      */   public static long parsePositiveTimePeriod(String period)
/*      */   {
/* 1134 */     long retval = parseTimePeriod(period);
/* 1135 */     if (retval < 0L)
/*      */     {
/* 1137 */       throw new NumberFormatException("Negative input time period: '" + period + "'");
/*      */     }
/* 1139 */     return retval;
/*      */   }
/*      */ 
/*      */   public static class Range
/*      */   {
/*      */     public int begin;
/*      */     public int end;
/*      */ 
/*      */     public Range(int begin, int end)
/*      */     {
/*  358 */       this.begin = begin;
/*  359 */       this.end = end;
/*      */     }
/*      */ 
/*      */     public Range()
/*      */     {
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.Strings
 * JD-Core Version:    0.6.0
 */