/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ 
/*     */ public class Semaphore
/*     */   implements Sync
/*     */ {
/*     */   private static final long DEADLOCK_TIMEOUT = 300000L;
/*     */   private static final boolean m_debug = false;
/*     */   private int m_users;
/*     */   private int m_allowed;
/*     */   private Map m_logMap;
/*     */ 
/*     */   public Semaphore(int allowed)
/*     */   {
/*  56 */     if (allowed < 1) throw new IllegalArgumentException();
/*     */ 
/*  58 */     this.m_users = 0;
/*  59 */     this.m_allowed = allowed;
/*  60 */     this.m_logMap = new HashMap();
/*     */   }
/*     */ 
/*     */   public int getUsers()
/*     */   {
/*  66 */     synchronized (this)
/*     */     {
/*  68 */       return this.m_users;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void acquire()
/*     */     throws InterruptedException
/*     */   {
/*  75 */     synchronized (this)
/*     */     {
/*  77 */       logAcquire();
/*     */ 
/*  80 */       this.m_users += 1;
/*  81 */       boolean waitSuccessful = false;
/*  82 */       while (this.m_allowed <= 0)
/*     */       {
/*  84 */         waitSuccessful = waitImpl(this);
/*  85 */         if (waitSuccessful)
/*     */         {
/*     */           continue;
/*     */         }
/*  89 */         this.m_users -= 1;
/*  90 */         this.m_allowed += 1;
/*     */       }
/*     */ 
/*  93 */       this.m_allowed -= 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void release()
/*     */   {
/*  99 */     synchronized (this)
/*     */     {
/* 101 */       logRelease();
/*     */ 
/* 103 */       this.m_users -= 1;
/* 104 */       this.m_allowed += 1;
/* 105 */       notify();
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 112 */     return super.toString() + " - " + this.m_users;
/*     */   }
/*     */ 
/*     */   protected boolean waitImpl(Object lock)
/*     */     throws InterruptedException
/*     */   {
/* 122 */     long start = System.currentTimeMillis();
/* 123 */     lock.wait(300000L);
/* 124 */     long end = System.currentTimeMillis();
/*     */ 
/* 126 */     if (end - start > 299000L)
/*     */     {
/* 128 */       logDeadlock();
/* 129 */       return false;
/*     */     }
/* 131 */     return true;
/*     */   }
/*     */ 
/*     */   protected void logAcquire()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void logDeadlock()
/*     */   {
/* 168 */     System.err.println();
/* 169 */     System.err.println("DEADLOCK ON SEMAPHORE " + this);
/*     */ 
/* 181 */     System.err.println();
/*     */   }
/*     */ 
/*     */   protected void logRelease()
/*     */   {
/*     */   }
/*     */ 
/*     */   private class Info
/*     */   {
/*     */     private Thread m_thread;
/*     */     private int m_counter;
/*     */     private String m_trace;
/*     */ 
/*     */     private Info(Thread t, int i, String s)
/*     */     {
/* 221 */       this.m_thread = t;
/* 222 */       this.m_counter = i;
/* 223 */       this.m_trace = s;
/*     */     }
/*     */ 
/*     */     public boolean equals(Object o)
/*     */     {
/* 230 */       Info other = (Info)o;
/* 231 */       return this.m_thread == other.m_thread;
/*     */     }
/*     */ 
/*     */     public String toString() {
/* 235 */       return this.m_thread + " - " + this.m_counter + "\n" + this.m_trace;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.Semaphore
 * JD-Core Version:    0.6.0
 */