/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.lang.ref.Reference;
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.Constructor;
/*     */ import org.jboss.util.stream.Streams;
/*     */ 
/*     */ public final class Objects
/*     */ {
/*     */   public static Constructor getCompatibleConstructor(Class type, Class valueType)
/*     */   {
/*     */     try
/*     */     {
/*  62 */       return type.getConstructor(new Class[] { valueType });
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*  69 */       Class[] types = type.getClasses();
/*     */ 
/*  71 */       for (int i = 0; i < types.length; i++) {
/*     */         try {
/*  73 */           return type.getConstructor(new Class[] { types[i] });
/*     */         }
/*     */         catch (Exception ignore2)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*  80 */     return null;
/*     */   }
/*     */ 
/*     */   public static Object copy(Serializable obj)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  99 */     ObjectOutputStream out = null;
/* 100 */     ObjectInputStream in = null;
/* 101 */     Object copy = null;
/*     */     try
/*     */     {
/* 105 */       ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 106 */       out = new ObjectOutputStream(baos);
/* 107 */       out.writeObject(obj);
/* 108 */       out.flush();
/*     */ 
/* 111 */       byte[] data = baos.toByteArray();
/* 112 */       ByteArrayInputStream bais = new ByteArrayInputStream(data);
/* 113 */       in = new ObjectInputStream(bais);
/* 114 */       copy = in.readObject();
/*     */     }
/*     */     finally {
/* 117 */       Streams.close(out);
/* 118 */       Streams.close(in);
/*     */     }
/*     */ 
/* 121 */     return copy;
/*     */   }
/*     */ 
/*     */   public static Object deref(Object obj)
/*     */   {
/* 139 */     if ((obj != null) && ((obj instanceof Reference))) {
/* 140 */       Reference ref = (Reference)obj;
/* 141 */       return ref.get();
/*     */     }
/*     */ 
/* 144 */     return obj;
/*     */   }
/*     */ 
/*     */   public static boolean isArray(Object obj)
/*     */   {
/* 154 */     if (obj != null)
/* 155 */       return obj.getClass().isArray();
/* 156 */     return false;
/*     */   }
/*     */ 
/*     */   public static Object[] toArray(Object obj)
/*     */   {
/* 170 */     if ((obj instanceof Object[])) {
/* 171 */       return (Object[])(Object[])obj;
/*     */     }
/*     */ 
/* 175 */     Class type = obj.getClass();
/*     */     Object array;
/* 177 */     if (type.isArray()) {
/* 178 */       int length = Array.getLength(obj);
/* 179 */       Class componentType = type.getComponentType();
/* 180 */       Object array = Array.newInstance(componentType, length);
/* 181 */       for (int i = 0; i < length; i++)
/* 182 */         Array.set(array, i, Array.get(obj, i));
/*     */     }
/*     */     else
/*     */     {
/* 186 */       array = Array.newInstance(type, 1);
/* 187 */       Array.set(array, 0, obj);
/*     */     }
/*     */ 
/* 190 */     return (Object[])(Object[])array;
/*     */   }
/*     */ 
/*     */   public static boolean equals(Object[] a, Object[] b, boolean deep)
/*     */   {
/* 204 */     if (a == b) return true;
/* 205 */     if ((a == null) || (b == null)) return false;
/* 206 */     if (a.length != b.length) return false;
/*     */ 
/* 208 */     for (int i = 0; i < a.length; i++) {
/* 209 */       Object x = a[i];
/* 210 */       Object y = b[i];
/*     */ 
/* 212 */       if (x != y) return false;
/* 213 */       if ((x == null) || (y == null)) return false;
/* 214 */       if (deep) {
/* 215 */         if (((x instanceof Object[])) && ((y instanceof Object[]))) {
/* 216 */           if (!equals((Object[])(Object[])x, (Object[])(Object[])y, true)) return false;
/*     */         }
/*     */         else {
/* 219 */           return false;
/*     */         }
/*     */       }
/* 222 */       if (!x.equals(y)) return false;
/*     */     }
/*     */ 
/* 225 */     return true;
/*     */   }
/*     */ 
/*     */   public static boolean equals(Object[] a, Object[] b)
/*     */   {
/* 236 */     return equals(a, b, true);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.Objects
 * JD-Core Version:    0.6.0
 */