/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.Serializable;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.platform.Java;
/*     */ 
/*     */ public abstract interface NestedThrowable extends Serializable
/*     */ {
/*  51 */   public static final boolean PARENT_TRACE_ENABLED = Util.getBoolean("parentTraceEnabled", true);
/*     */ 
/*  69 */   public static final boolean NESTED_TRACE_ENABLED = Util.getBoolean("nestedTraceEnabled", ((Java.isCompatible(5)) && (!PARENT_TRACE_ENABLED)) || (!Java.isCompatible(5)));
/*     */ 
/*  83 */   public static final boolean DETECT_DUPLICATE_NESTING = Util.getBoolean("detectDuplicateNesting", true);
/*     */ 
/*     */   public abstract Throwable getNested();
/*     */ 
/*     */   public abstract Throwable getCause();
/*     */ 
/*     */   public static final class Util
/*     */   {
/* 113 */     private static Logger log = Logger.getLogger(NestedThrowable.class);
/*     */ 
/*     */     private static Logger getLogger()
/*     */     {
/* 125 */       if (log == null) {
/* 126 */         log = Logger.getLogger(NestedThrowable.class);
/*     */       }
/* 128 */       return log;
/*     */     }
/*     */ 
/*     */     protected static boolean getBoolean(String name, boolean defaultValue)
/*     */     {
/* 134 */       name = NestedThrowable.class.getName() + "." + name;
/* 135 */       String value = System.getProperty(name, String.valueOf(defaultValue));
/*     */ 
/* 138 */       log = getLogger();
/*     */ 
/* 140 */       log.debug(name + "=" + value);
/*     */ 
/* 142 */       return new Boolean(value).booleanValue();
/*     */     }
/*     */ 
/*     */     public static void checkNested(NestedThrowable parent, Throwable child)
/*     */     {
/* 152 */       if ((!NestedThrowable.DETECT_DUPLICATE_NESTING) || (parent == null) || (child == null)) return;
/*     */ 
/* 154 */       Class parentType = parent.getClass();
/* 155 */       Class childType = child.getClass();
/*     */ 
/* 161 */       if (parentType.isAssignableFrom(childType))
/*     */       {
/* 163 */         log = getLogger();
/*     */ 
/* 165 */         log.warn("Duplicate throwable nesting of same base type: " + parentType + " is assignable from: " + childType);
/*     */       }
/*     */     }
/*     */ 
/*     */     public static String getMessage(String msg, Throwable nested)
/*     */     {
/* 181 */       StringBuffer buff = new StringBuffer(msg == null ? "" : msg);
/*     */ 
/* 183 */       if (nested != null) {
/* 184 */         buff.append(msg == null ? "- " : "; - ").append("nested throwable: (").append(nested).append(")");
/*     */       }
/*     */ 
/* 190 */       return buff.toString();
/*     */     }
/*     */ 
/*     */     public static void print(Throwable nested, PrintStream stream)
/*     */     {
/* 202 */       if (stream == null) {
/* 203 */         throw new NullArgumentException("stream");
/*     */       }
/* 205 */       if ((NestedThrowable.NESTED_TRACE_ENABLED) && (nested != null))
/* 206 */         synchronized (stream) {
/* 207 */           if (NestedThrowable.PARENT_TRACE_ENABLED) {
/* 208 */             stream.print(" + nested throwable: ");
/*     */           }
/*     */           else {
/* 211 */             stream.print("[ parent trace omitted ]: ");
/*     */           }
/*     */ 
/* 214 */           nested.printStackTrace(stream);
/*     */         }
/*     */     }
/*     */ 
/*     */     public static void print(Throwable nested, PrintWriter writer)
/*     */     {
/* 228 */       if (writer == null) {
/* 229 */         throw new NullArgumentException("writer");
/*     */       }
/* 231 */       if ((NestedThrowable.NESTED_TRACE_ENABLED) && (nested != null))
/* 232 */         synchronized (writer) {
/* 233 */           if (NestedThrowable.PARENT_TRACE_ENABLED) {
/* 234 */             writer.print(" + nested throwable: ");
/*     */           }
/*     */           else {
/* 237 */             writer.print("[ parent trace omitted ]: ");
/*     */           }
/*     */ 
/* 240 */           nested.printStackTrace(writer);
/*     */         }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.NestedThrowable
 * JD-Core Version:    0.6.0
 */