/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.io.PrintWriter;
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ public class NestedSQLException extends SQLException
/*     */   implements NestedThrowable
/*     */ {
/*     */   protected final Throwable nested;
/*     */ 
/*     */   public NestedSQLException(String msg)
/*     */   {
/*  50 */     super(msg);
/*  51 */     this.nested = null;
/*     */   }
/*     */ 
/*     */   public NestedSQLException(String msg, Throwable nested)
/*     */   {
/*  62 */     super(msg);
/*  63 */     this.nested = nested;
/*  64 */     NestedThrowable.Util.checkNested(this, nested);
/*     */   }
/*     */ 
/*     */   public NestedSQLException(Throwable nested)
/*     */   {
/*  74 */     this(nested.getMessage(), nested);
/*     */   }
/*     */ 
/*     */   public NestedSQLException(String msg, String state)
/*     */   {
/*  84 */     super(msg, state);
/*  85 */     this.nested = null;
/*     */   }
/*     */ 
/*     */   public NestedSQLException(String msg, String state, int code)
/*     */   {
/*  96 */     super(msg, state, code);
/*  97 */     this.nested = null;
/*     */   }
/*     */ 
/*     */   public Throwable getNested()
/*     */   {
/* 106 */     return this.nested;
/*     */   }
/*     */ 
/*     */   public Throwable getCause()
/*     */   {
/* 117 */     return this.nested;
/*     */   }
/*     */ 
/*     */   public String getMessage()
/*     */   {
/* 126 */     return NestedThrowable.Util.getMessage(super.getMessage(), this.nested);
/*     */   }
/*     */ 
/*     */   public void printStackTrace(PrintStream stream)
/*     */   {
/* 136 */     if ((this.nested == null) || (NestedThrowable.PARENT_TRACE_ENABLED)) {
/* 137 */       super.printStackTrace(stream);
/*     */     }
/* 139 */     NestedThrowable.Util.print(this.nested, stream);
/*     */   }
/*     */ 
/*     */   public void printStackTrace(PrintWriter writer)
/*     */   {
/* 149 */     if ((this.nested == null) || (NestedThrowable.PARENT_TRACE_ENABLED)) {
/* 150 */       super.printStackTrace(writer);
/*     */     }
/* 152 */     NestedThrowable.Util.print(this.nested, writer);
/*     */   }
/*     */ 
/*     */   public void printStackTrace()
/*     */   {
/* 160 */     printStackTrace(System.err);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.NestedSQLException
 * JD-Core Version:    0.6.0
 */