/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.DigestOutputStream;
/*     */ import java.security.MessageDigest;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.WeakHashMap;
/*     */ 
/*     */ public class MethodHashing
/*     */ {
/*  45 */   static Map hashMap = new WeakHashMap();
/*     */ 
/*     */   public static Method findMethodByHash(Class clazz, long hash) throws Exception
/*     */   {
/*  49 */     Method[] methods = clazz.getDeclaredMethods();
/*  50 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/*  52 */       if (methodHash(methods[i]) == hash) return methods[i];
/*     */     }
/*  54 */     if (clazz.getSuperclass() != null)
/*     */     {
/*  56 */       return findMethodByHash(clazz.getSuperclass(), hash);
/*     */     }
/*  58 */     return null;
/*     */   }
/*     */ 
/*     */   public static Constructor findConstructorByHash(Class clazz, long hash) throws Exception
/*     */   {
/*  63 */     Constructor[] cons = clazz.getDeclaredConstructors();
/*  64 */     for (int i = 0; i < cons.length; i++)
/*     */     {
/*  66 */       if (constructorHash(cons[i]) == hash) return cons[i];
/*     */     }
/*  68 */     if (clazz.getSuperclass() != null)
/*     */     {
/*  70 */       return findConstructorByHash(clazz.getSuperclass(), hash);
/*     */     }
/*  72 */     return null;
/*     */   }
/*     */ 
/*     */   public static long methodHash(Method method)
/*     */     throws Exception
/*     */   {
/*  78 */     Class[] parameterTypes = method.getParameterTypes();
/*  79 */     String methodDesc = method.getName() + "(";
/*  80 */     for (int j = 0; j < parameterTypes.length; j++)
/*     */     {
/*  82 */       methodDesc = methodDesc + getTypeString(parameterTypes[j]);
/*     */     }
/*  84 */     methodDesc = methodDesc + ")" + getTypeString(method.getReturnType());
/*     */ 
/*  86 */     long hash = 0L;
/*  87 */     ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
/*  88 */     MessageDigest messagedigest = MessageDigest.getInstance("SHA");
/*  89 */     DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
/*  90 */     dataoutputstream.writeUTF(methodDesc);
/*  91 */     dataoutputstream.flush();
/*  92 */     byte[] abyte0 = messagedigest.digest();
/*  93 */     for (int j = 0; j < Math.min(8, abyte0.length); j++)
/*  94 */       hash += ((abyte0[j] & 0xFF) << j * 8);
/*  95 */     return hash;
/*     */   }
/*     */ 
/*     */   public static long constructorHash(Constructor method)
/*     */     throws Exception
/*     */   {
/* 101 */     Class[] parameterTypes = method.getParameterTypes();
/* 102 */     String methodDesc = method.getName() + "(";
/* 103 */     for (int j = 0; j < parameterTypes.length; j++)
/*     */     {
/* 105 */       methodDesc = methodDesc + getTypeString(parameterTypes[j]);
/*     */     }
/* 107 */     methodDesc = methodDesc + ")";
/*     */ 
/* 109 */     long hash = 0L;
/* 110 */     ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
/* 111 */     MessageDigest messagedigest = MessageDigest.getInstance("SHA");
/* 112 */     DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
/* 113 */     dataoutputstream.writeUTF(methodDesc);
/* 114 */     dataoutputstream.flush();
/* 115 */     byte[] abyte0 = messagedigest.digest();
/* 116 */     for (int j = 0; j < Math.min(8, abyte0.length); j++)
/* 117 */       hash += ((abyte0[j] & 0xFF) << j * 8);
/* 118 */     return hash;
/*     */   }
/*     */ 
/*     */   public static Map getInterfaceHashes(Class intf)
/*     */   {
/* 130 */     Method[] methods = intf.getDeclaredMethods();
/* 131 */     HashMap map = new HashMap();
/* 132 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 134 */       Method method = methods[i];
/*     */       try
/*     */       {
/* 137 */         long hash = methodHash(method);
/* 138 */         map.put(method.toString(), new Long(hash));
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 145 */     return map;
/*     */   }
/*     */ 
/*     */   static String getTypeString(Class cl)
/*     */   {
/* 150 */     if (cl == Byte.TYPE)
/*     */     {
/* 152 */       return "B";
/* 153 */     }if (cl == Character.TYPE)
/*     */     {
/* 155 */       return "C";
/* 156 */     }if (cl == Double.TYPE)
/*     */     {
/* 158 */       return "D";
/* 159 */     }if (cl == Float.TYPE)
/*     */     {
/* 161 */       return "F";
/* 162 */     }if (cl == Integer.TYPE)
/*     */     {
/* 164 */       return "I";
/* 165 */     }if (cl == Long.TYPE)
/*     */     {
/* 167 */       return "J";
/* 168 */     }if (cl == Short.TYPE)
/*     */     {
/* 170 */       return "S";
/* 171 */     }if (cl == Boolean.TYPE)
/*     */     {
/* 173 */       return "Z";
/* 174 */     }if (cl == Void.TYPE)
/*     */     {
/* 176 */       return "V";
/* 177 */     }if (cl.isArray())
/*     */     {
/* 179 */       return "[" + getTypeString(cl.getComponentType());
/*     */     }
/*     */ 
/* 182 */     return "L" + cl.getName().replace('.', '/') + ";";
/*     */   }
/*     */ 
/*     */   public static long calculateHash(Method method)
/*     */   {
/* 195 */     Map methodHashes = (Map)hashMap.get(method.getDeclaringClass());
/*     */ 
/* 197 */     if (methodHashes == null)
/*     */     {
/* 199 */       methodHashes = getInterfaceHashes(method.getDeclaringClass());
/*     */ 
/* 202 */       WeakHashMap newHashMap = new WeakHashMap();
/* 203 */       newHashMap.putAll(hashMap);
/* 204 */       newHashMap.put(method.getDeclaringClass(), methodHashes);
/* 205 */       hashMap = newHashMap;
/*     */     }
/*     */ 
/* 208 */     return ((Long)methodHashes.get(method.toString())).longValue();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.MethodHashing
 * JD-Core Version:    0.6.0
 */