/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class LongCounter
/*     */   implements Serializable, Cloneable
/*     */ {
/*     */   private long count;
/*     */ 
/*     */   public LongCounter(long count)
/*     */   {
/*  44 */     this.count = count;
/*     */   }
/*     */ 
/*     */   public LongCounter()
/*     */   {
/*     */   }
/*     */ 
/*     */   public long increment()
/*     */   {
/*  58 */     return ++this.count;
/*     */   }
/*     */ 
/*     */   public long decrement()
/*     */   {
/*  67 */     return --this.count;
/*     */   }
/*     */ 
/*     */   public long getCount()
/*     */   {
/*  76 */     return this.count;
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/*  83 */     this.count = 0L;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  93 */     if (obj == this) return true;
/*     */ 
/*  95 */     if ((obj != null) && (obj.getClass() == getClass())) {
/*  96 */       return ((LongCounter)obj).count == this.count;
/*     */     }
/*     */ 
/*  99 */     return false;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 108 */     return String.valueOf(this.count);
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*     */     try
/*     */     {
/* 118 */       return super.clone();
/*     */     } catch (CloneNotSupportedException e) {
/*     */     }
/* 121 */     throw new InternalError();
/*     */   }
/*     */ 
/*     */   public static LongCounter makeSynchronized(LongCounter counter)
/*     */   {
/* 180 */     return new Wrapper(counter) {
/*     */       public synchronized long increment() {
/* 182 */         return this.counter.increment();
/*     */       }
/*     */ 
/*     */       public synchronized long decrement() {
/* 186 */         return this.counter.decrement();
/*     */       }
/*     */ 
/*     */       public synchronized long getCount() {
/* 190 */         return this.counter.getCount();
/*     */       }
/*     */ 
/*     */       public synchronized void reset() {
/* 194 */         this.counter.reset();
/*     */       }
/*     */ 
/*     */       public synchronized int hashCode() {
/* 198 */         return this.counter.hashCode();
/*     */       }
/*     */ 
/*     */       public synchronized boolean equals(Object obj) {
/* 202 */         return this.counter.equals(obj);
/*     */       }
/*     */ 
/*     */       public synchronized String toString() {
/* 206 */         return this.counter.toString();
/*     */       }
/*     */ 
/*     */       public synchronized Object clone() {
/* 210 */         return this.counter.clone();
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   public static LongCounter makeDirectional(LongCounter counter, boolean increasing)
/*     */   {
/*     */     LongCounter temp;
/*     */     LongCounter temp;
/* 227 */     if (increasing)
/* 228 */       temp = new Wrapper(counter) {
/*     */         public long decrement() {
/* 230 */           throw new UnsupportedOperationException();
/*     */         }
/*     */ 
/*     */         public void reset() {
/* 234 */           throw new UnsupportedOperationException();
/*     */         }
/*     */       };
/*     */     else {
/* 239 */       temp = new Wrapper(counter) {
/*     */         public long increment() {
/* 241 */           throw new UnsupportedOperationException();
/*     */         }
/*     */       };
/*     */     }
/* 246 */     return temp;
/*     */   }
/*     */ 
/*     */   private static class Wrapper extends LongCounter
/*     */   {
/*     */     protected final LongCounter counter;
/*     */ 
/*     */     public Wrapper(LongCounter counter)
/*     */     {
/* 140 */       this.counter = counter;
/*     */     }
/*     */ 
/*     */     public long increment() {
/* 144 */       return this.counter.increment();
/*     */     }
/*     */ 
/*     */     public long decrement() {
/* 148 */       return this.counter.decrement();
/*     */     }
/*     */ 
/*     */     public long getCount() {
/* 152 */       return this.counter.getCount();
/*     */     }
/*     */ 
/*     */     public void reset() {
/* 156 */       this.counter.reset();
/*     */     }
/*     */ 
/*     */     public boolean equals(Object obj) {
/* 160 */       return this.counter.equals(obj);
/*     */     }
/*     */ 
/*     */     public String toString() {
/* 164 */       return this.counter.toString();
/*     */     }
/*     */ 
/*     */     public Object clone() {
/* 168 */       return this.counter.clone();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.LongCounter
 * JD-Core Version:    0.6.0
 */