/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Arrays;
/*     */ 
/*     */ public class JBossStringBuilder
/*     */   implements Serializable, CharSequence
/*     */ {
/*     */   private static final long serialVersionUID = 1874946609763446794L;
/*     */   protected char[] chars;
/*     */   protected int pos;
/*     */ 
/*     */   public JBossStringBuilder()
/*     */   {
/*  51 */     this(16);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder(int capacity)
/*     */   {
/*  61 */     this.chars = new char[capacity];
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder(String string)
/*     */   {
/*  73 */     this(string.length() + 16);
/*  74 */     append(string);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder(CharSequence charSequence)
/*     */   {
/*  85 */     this(charSequence.length() + 16);
/*  86 */     append(charSequence);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder(char[] ch)
/*     */   {
/*  96 */     this(ch, 0, ch.length);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder(char[] ch, int start, int length)
/*     */   {
/* 108 */     this(length + 16);
/* 109 */     append(ch, start, length);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder append(Object object)
/*     */   {
/* 114 */     return append(String.valueOf(object));
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder append(String string)
/*     */   {
/* 119 */     if (string == null) {
/* 120 */       string = "null";
/*     */     }
/* 122 */     int length = string.length();
/* 123 */     if (length == 0) {
/* 124 */       return this;
/*     */     }
/* 126 */     int afterAppend = this.pos + length;
/* 127 */     if (afterAppend > this.chars.length) {
/* 128 */       expandCapacity(afterAppend);
/*     */     }
/* 130 */     string.getChars(0, length, this.chars, this.pos);
/* 131 */     this.pos = afterAppend;
/* 132 */     return this;
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder append(StringBuffer buffer)
/*     */   {
/* 137 */     if (buffer == null) {
/* 138 */       return append("null");
/*     */     }
/* 140 */     int length = buffer.length();
/* 141 */     if (length == 0) {
/* 142 */       return this;
/*     */     }
/* 144 */     int afterAppend = this.pos + length;
/* 145 */     if (afterAppend > this.chars.length) {
/* 146 */       expandCapacity(afterAppend);
/*     */     }
/* 148 */     buffer.getChars(0, length, this.chars, this.pos);
/* 149 */     this.pos = afterAppend;
/* 150 */     return this;
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder append(CharSequence charSequence)
/*     */   {
/* 155 */     if (charSequence == null) {
/* 156 */       return append("null");
/*     */     }
/* 158 */     int length = charSequence.length();
/* 159 */     if (length == 0) {
/* 160 */       return this;
/*     */     }
/* 162 */     return append(charSequence, 0, charSequence.length());
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder append(CharSequence charSequence, int start, int end)
/*     */   {
/* 167 */     if (charSequence == null) {
/* 168 */       return append("null");
/*     */     }
/* 170 */     if ((start < 0) || (end < 0) || (start > end) || (start > charSequence.length())) {
/* 171 */       throw new IndexOutOfBoundsException("Invalid start=" + start + " end=" + end + " length=" + charSequence.length());
/*     */     }
/* 173 */     int length = end - start;
/* 174 */     if (length == 0) {
/* 175 */       return this;
/*     */     }
/* 177 */     int afterAppend = this.pos + length;
/* 178 */     if (afterAppend > this.chars.length) {
/* 179 */       expandCapacity(afterAppend);
/*     */     }
/* 181 */     for (int i = start; i < end; i++)
/* 182 */       this.chars[(this.pos++)] = charSequence.charAt(i);
/* 183 */     this.pos = afterAppend;
/* 184 */     return this;
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder append(char[] array)
/*     */   {
/* 189 */     if (array == null) {
/* 190 */       return append("null");
/*     */     }
/* 192 */     if (array.length == 0) {
/* 193 */       return this;
/*     */     }
/* 195 */     String string = String.valueOf(array);
/* 196 */     return append(string);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder append(char[] array, int offset, int length)
/*     */   {
/* 201 */     if (array == null) {
/* 202 */       return append("null");
/*     */     }
/* 204 */     int arrayLength = array.length;
/* 205 */     if ((offset < 0) || (length < 0) || (offset + length > arrayLength)) {
/* 206 */       throw new IndexOutOfBoundsException("Invalid offset=" + offset + " length=" + length + " array.length=" + arrayLength);
/*     */     }
/* 208 */     if ((length == 0) || (arrayLength == 0)) {
/* 209 */       return this;
/*     */     }
/* 211 */     String string = String.valueOf(array, offset, length);
/* 212 */     return append(string);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder append(boolean primitive)
/*     */   {
/* 217 */     String string = String.valueOf(primitive);
/* 218 */     return append(string);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder append(char primitive)
/*     */   {
/* 223 */     String string = String.valueOf(primitive);
/* 224 */     return append(string);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder append(int primitive)
/*     */   {
/* 229 */     String string = String.valueOf(primitive);
/* 230 */     return append(string);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder append(long primitive)
/*     */   {
/* 235 */     String string = String.valueOf(primitive);
/* 236 */     return append(string);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder append(float primitive)
/*     */   {
/* 241 */     String string = String.valueOf(primitive);
/* 242 */     return append(string);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder append(double primitive)
/*     */   {
/* 247 */     String string = String.valueOf(primitive);
/* 248 */     return append(string);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder delete(int start, int end)
/*     */   {
/* 253 */     if ((start < 0) || (start > this.pos) || (start > end) || (end > this.pos)) {
/* 254 */       throw new IndexOutOfBoundsException("Invalid start=" + start + " end=" + end + " length=" + this.pos);
/*     */     }
/* 256 */     if (start == end) {
/* 257 */       return this;
/*     */     }
/* 259 */     int removed = end - start;
/* 260 */     System.arraycopy(this.chars, start + removed, this.chars, start, this.pos - end);
/* 261 */     this.pos -= removed;
/* 262 */     return this;
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder deleteCharAt(int index)
/*     */   {
/* 267 */     return delete(index, 1);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder replace(int start, int end, String string)
/*     */   {
/* 272 */     delete(start, end);
/* 273 */     return insert(start, string);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder insert(int index, char[] string)
/*     */   {
/* 278 */     return insert(index, string, 0, string.length);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder insert(int index, char[] string, int offset, int len)
/*     */   {
/* 283 */     int stringLength = string.length;
/* 284 */     if ((index < 0) || (index > this.pos) || (offset < 0) || (len < 0) || (offset + len > string.length)) {
/* 285 */       throw new IndexOutOfBoundsException("Invalid index=" + index + " offset=" + offset + " len=" + len + " string.length=" + stringLength + " length=" + this.pos);
/*     */     }
/* 287 */     if (len == 0) {
/* 288 */       return this;
/*     */     }
/* 290 */     int afterAppend = this.pos + len;
/* 291 */     if (afterAppend > this.chars.length) {
/* 292 */       expandCapacity(afterAppend);
/*     */     }
/* 294 */     System.arraycopy(this.chars, index, this.chars, index + stringLength, this.pos - index);
/* 295 */     System.arraycopy(string, offset, this.chars, index, len);
/* 296 */     this.pos = afterAppend;
/* 297 */     return this;
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder insert(int offset, Object object)
/*     */   {
/* 302 */     if (object == null) {
/* 303 */       return insert(offset, "null");
/*     */     }
/* 305 */     return insert(offset, String.valueOf(object));
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder insert(int offset, String string)
/*     */   {
/* 310 */     if ((offset < 0) || (offset > this.pos)) {
/* 311 */       throw new IndexOutOfBoundsException("Invalid offset=" + offset + " length=" + this.pos);
/*     */     }
/* 313 */     if (string == null) {
/* 314 */       string = "null";
/*     */     }
/* 316 */     int stringLength = string.length();
/*     */ 
/* 318 */     int afterAppend = this.pos + stringLength;
/* 319 */     if (afterAppend > this.chars.length) {
/* 320 */       expandCapacity(afterAppend);
/*     */     }
/* 322 */     System.arraycopy(this.chars, offset, this.chars, offset + stringLength, this.pos - offset);
/* 323 */     string.getChars(0, stringLength, this.chars, offset);
/* 324 */     this.pos = afterAppend;
/* 325 */     return this;
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder insert(int offset, CharSequence charSequence)
/*     */   {
/* 330 */     if (charSequence == null) {
/* 331 */       return insert(offset, "null");
/*     */     }
/* 333 */     return insert(offset, charSequence, 0, charSequence.length());
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder insert(int offset, CharSequence charSequence, int start, int end)
/*     */   {
/* 338 */     if (charSequence == null) {
/* 339 */       charSequence = "null";
/*     */     }
/* 341 */     int sequenceLength = charSequence.length();
/* 342 */     if ((offset < 0) || (offset > this.pos) || (start < 0) || (end < 0) || (start > sequenceLength) || (end > sequenceLength) || (start > end)) {
/* 343 */       throw new IndexOutOfBoundsException("Invalid offset=" + offset + " start=" + start + " end=" + end + " sequence.length()=" + sequenceLength + " length=" + this.pos);
/*     */     }
/* 345 */     int len = end - start;
/* 346 */     if (len == 0) {
/* 347 */       return this;
/*     */     }
/* 349 */     int afterAppend = this.pos + len;
/* 350 */     if (afterAppend > this.chars.length) {
/* 351 */       expandCapacity(afterAppend);
/*     */     }
/* 353 */     System.arraycopy(this.chars, offset, this.chars, offset + sequenceLength, this.pos - offset);
/* 354 */     for (int i = start; i < end; i++)
/* 355 */       this.chars[(offset++)] = charSequence.charAt(i);
/* 356 */     this.pos = afterAppend;
/* 357 */     return this;
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder insert(int offset, boolean primitive)
/*     */   {
/* 362 */     return insert(offset, String.valueOf(primitive));
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder insert(int offset, char primitive)
/*     */   {
/* 367 */     return insert(offset, String.valueOf(primitive));
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder insert(int offset, int primitive)
/*     */   {
/* 372 */     return insert(offset, String.valueOf(primitive));
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder insert(int offset, long primitive)
/*     */   {
/* 377 */     return insert(offset, String.valueOf(primitive));
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder insert(int offset, float primitive)
/*     */   {
/* 382 */     return insert(offset, String.valueOf(primitive));
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder insert(int offset, double primitive)
/*     */   {
/* 387 */     return insert(offset, String.valueOf(primitive));
/*     */   }
/*     */ 
/*     */   public int indexOf(String string)
/*     */   {
/* 392 */     return indexOf(string, 0);
/*     */   }
/*     */ 
/*     */   public int indexOf(String string, int fromIndex)
/*     */   {
/* 398 */     return toString().indexOf(string, fromIndex);
/*     */   }
/*     */ 
/*     */   public int indexOf(char ch)
/*     */   {
/* 403 */     return indexOf(ch, 0);
/*     */   }
/*     */ 
/*     */   public int indexOf(char ch, int fromIndex)
/*     */   {
/* 409 */     return toString().indexOf(ch, fromIndex);
/*     */   }
/*     */ 
/*     */   public int lastIndexOf(String string)
/*     */   {
/* 414 */     return lastIndexOf(string, this.pos);
/*     */   }
/*     */ 
/*     */   public int lastIndexOf(String string, int fromIndex)
/*     */   {
/* 420 */     return toString().lastIndexOf(string, fromIndex);
/*     */   }
/*     */ 
/*     */   public int lastIndexOf(char ch)
/*     */   {
/* 425 */     return lastIndexOf(ch, this.pos);
/*     */   }
/*     */ 
/*     */   public int lastIndexOf(char ch, int fromIndex)
/*     */   {
/* 431 */     return toString().lastIndexOf(ch, fromIndex);
/*     */   }
/*     */ 
/*     */   public JBossStringBuilder reverse()
/*     */   {
/* 436 */     char[] tmp = new char[this.pos];
/* 437 */     for (int n = 0; n < this.pos; n++)
/* 438 */       tmp[n] = this.chars[(this.pos - n - 1)];
/* 439 */     this.chars = tmp;
/* 440 */     return this;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 445 */     return new String(this.chars, 0, this.pos);
/*     */   }
/*     */ 
/*     */   public int length()
/*     */   {
/* 450 */     return this.pos;
/*     */   }
/*     */ 
/*     */   public int capacity()
/*     */   {
/* 455 */     return this.chars.length;
/*     */   }
/*     */ 
/*     */   public void ensureCapacity(int minimum)
/*     */   {
/* 460 */     if ((minimum < 0) || (minimum < this.chars.length))
/* 461 */       return;
/* 462 */     expandCapacity(minimum);
/*     */   }
/*     */ 
/*     */   public void trimToSize()
/*     */   {
/* 467 */     char[] trimmed = new char[this.pos];
/* 468 */     System.arraycopy(this.chars, 0, trimmed, 0, this.pos);
/* 469 */     this.chars = trimmed;
/*     */   }
/*     */ 
/*     */   public void setLength(int newLength)
/*     */   {
/* 474 */     if (newLength < 0)
/* 475 */       throw new StringIndexOutOfBoundsException(newLength);
/* 476 */     if (newLength > this.chars.length)
/* 477 */       expandCapacity(newLength);
/* 478 */     Arrays.fill(this.chars, newLength, this.chars.length, '\000');
/* 479 */     this.pos = newLength;
/*     */   }
/*     */ 
/*     */   public char charAt(int index)
/*     */   {
/* 484 */     return this.chars[index];
/*     */   }
/*     */ 
/*     */   public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin)
/*     */   {
/* 489 */     if ((srcBegin < 0) || (dstBegin < 0) || (srcBegin > srcEnd) || (srcEnd > this.pos) || (dstBegin + srcEnd - srcBegin > dst.length)) {
/* 490 */       throw new IndexOutOfBoundsException("Invalid srcBegin=" + srcBegin + " srcEnd=" + srcEnd + " dstBegin=" + dstBegin + " dst.length=" + dst.length + " length=" + this.pos);
/*     */     }
/* 492 */     int len = srcEnd - srcBegin;
/* 493 */     if (len == 0) {
/* 494 */       return;
/*     */     }
/* 496 */     System.arraycopy(this.chars, srcBegin, dst, dstBegin, len);
/*     */   }
/*     */ 
/*     */   public void setCharAt(int index, char ch)
/*     */   {
/* 501 */     if ((index < 0) || (index > this.pos)) {
/* 502 */       throw new IndexOutOfBoundsException("Invalid index=" + index + " length=" + this.pos);
/*     */     }
/* 504 */     this.chars[index] = ch;
/*     */   }
/*     */ 
/*     */   public String substring(int start)
/*     */   {
/* 509 */     return substring(start, this.pos);
/*     */   }
/*     */ 
/*     */   public CharSequence subSequence(int start, int end)
/*     */   {
/* 514 */     return substring(start, end);
/*     */   }
/*     */ 
/*     */   public String substring(int start, int end)
/*     */   {
/* 519 */     if ((start < 0) || (end < 0) || (start > end) || (end > this.pos)) {
/* 520 */       throw new IndexOutOfBoundsException("Invalid start=" + start + " end=" + end + " length=" + this.pos);
/*     */     }
/* 522 */     return new String(this.chars, start, end - start);
/*     */   }
/*     */ 
/*     */   protected void expandCapacity(int minimum)
/*     */   {
/* 533 */     int newSize = this.chars.length * 2;
/* 534 */     if (minimum > newSize) {
/* 535 */       newSize = minimum;
/*     */     }
/* 537 */     char[] newChars = new char[newSize];
/* 538 */     System.arraycopy(this.chars, 0, newChars, 0, this.pos);
/* 539 */     this.chars = newChars;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.JBossStringBuilder
 * JD-Core Version:    0.6.0
 */