/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.lang.ref.SoftReference;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JBossObject
/*     */   implements JBossInterface
/*     */ {
/*     */   protected Logger log;
/*     */   protected transient SoftReference toString;
/*  68 */   protected transient int hashCode = -2147483648;
/*     */ 
/*     */   public static boolean equals(Object one, Object two)
/*     */   {
/*  78 */     if ((one == null) && (two != null)) {
/*  79 */       return false;
/*     */     }
/*  81 */     return (one == null) || (one.equals(two));
/*     */   }
/*     */ 
/*     */   public static boolean notEqual(Object one, Object two)
/*     */   {
/*  93 */     return !equals(one, two);
/*     */   }
/*     */ 
/*     */   public static void list(JBossStringBuilder buffer, Collection objects)
/*     */   {
/* 104 */     if (objects == null) {
/* 105 */       return;
/*     */     }
/* 107 */     buffer.append('[');
/*     */     Iterator i;
/* 108 */     if (!objects.isEmpty())
/*     */     {
/* 110 */       for (i = objects.iterator(); i.hasNext(); )
/*     */       {
/* 112 */         Object object = i.next();
/* 113 */         if ((object instanceof JBossObject))
/* 114 */           ((JBossObject)object).toShortString(buffer);
/*     */         else
/* 116 */           buffer.append(object.toString());
/* 117 */         if (i.hasNext())
/* 118 */           buffer.append(", ");
/*     */       }
/*     */     }
/* 121 */     buffer.append(']');
/*     */   }
/*     */ 
/*     */   public JBossObject()
/*     */   {
/* 129 */     this.log = Logger.getLogger(getClass());
/*     */   }
/*     */ 
/*     */   public JBossObject(Logger log)
/*     */   {
/* 139 */     this.log = (log != null ? log : Logger.getLogger(getClass()));
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 149 */     if (!cacheToString()) {
/* 150 */       return toStringImplementation();
/*     */     }
/* 152 */     String result = null;
/* 153 */     if (this.toString != null) {
/* 154 */       result = (String)this.toString.get();
/*     */     }
/* 156 */     if (result == null)
/*     */     {
/* 158 */       result = toStringImplementation();
/* 159 */       this.toString = new SoftReference(result);
/*     */     }
/* 161 */     return result;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 171 */     if ((this.hashCode == -2147483648) || (!cacheGetHashCode()))
/* 172 */       this.hashCode = getHashCode();
/* 173 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*     */     try
/*     */     {
/* 180 */       return super.clone();
/*     */     }
/*     */     catch (CloneNotSupportedException e) {
/*     */     }
/* 184 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public String toShortString()
/*     */   {
/* 190 */     JBossStringBuilder buffer = new JBossStringBuilder();
/* 191 */     toShortString(buffer);
/* 192 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/*     */   }
/*     */ 
/*     */   public String getClassShortName()
/*     */   {
/* 211 */     String longName = getClass().getName();
/* 212 */     int dot = longName.lastIndexOf('.');
/* 213 */     if (dot != -1)
/* 214 */       return longName.substring(dot + 1);
/* 215 */     return longName;
/*     */   }
/*     */ 
/*     */   protected String toStringImplementation()
/*     */   {
/* 225 */     JBossStringBuilder buffer = new JBossStringBuilder();
/* 226 */     buffer.append(getClassShortName()).append('@');
/* 227 */     buffer.append(Integer.toHexString(System.identityHashCode(this)));
/* 228 */     buffer.append('{');
/* 229 */     toString(buffer);
/* 230 */     buffer.append('}');
/* 231 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   protected void flushJBossObjectCache()
/*     */   {
/* 239 */     this.toString = null;
/* 240 */     this.hashCode = -2147483648;
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 259 */     return super.hashCode();
/*     */   }
/*     */ 
/*     */   protected boolean cacheToString()
/*     */   {
/* 269 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean cacheGetHashCode()
/*     */   {
/* 279 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.JBossObject
 * JD-Core Version:    0.6.0
 */