/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ 
/*     */ public class FieldInstance
/*     */ {
/*     */   protected final Field field;
/*     */   protected final Object instance;
/*     */ 
/*     */   public FieldInstance(Object instance, String fieldName)
/*     */     throws NoSuchFieldException
/*     */   {
/*  52 */     if (instance == null)
/*  53 */       throw new NullArgumentException("instance");
/*  54 */     if (fieldName == null) {
/*  55 */       throw new NullArgumentException("fieldName");
/*     */     }
/*     */ 
/*  58 */     this.field = instance.getClass().getField(fieldName);
/*     */ 
/*  61 */     if (!this.field.getDeclaringClass().isAssignableFrom(instance.getClass())) {
/*  62 */       throw new IllegalArgumentException("field does not belong to instance class");
/*     */     }
/*     */ 
/*  65 */     this.instance = instance;
/*     */   }
/*     */ 
/*     */   public final Field getField()
/*     */   {
/*  74 */     return this.field;
/*     */   }
/*     */ 
/*     */   public final Object getInstance()
/*     */   {
/*  83 */     return this.instance;
/*     */   }
/*     */ 
/*     */   public final Object get()
/*     */     throws IllegalAccessException
/*     */   {
/*  94 */     return this.field.get(this.instance);
/*     */   }
/*     */ 
/*     */   public final void set(Object value)
/*     */     throws IllegalAccessException
/*     */   {
/* 105 */     this.field.set(this.instance, value);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.FieldInstance
 * JD-Core Version:    0.6.0
 */