/*    */ package org.jboss.util;
/*    */ 
/*    */ import java.io.ByteArrayInputStream;
/*    */ import java.io.ByteArrayOutputStream;
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectInputStream;
/*    */ import java.io.ObjectOutputStream;
/*    */ import org.jboss.util.stream.CustomObjectInputStreamWithClassloader;
/*    */ import org.jboss.util.stream.CustomObjectOutputStream;
/*    */ 
/*    */ public class Conversion
/*    */ {
/*    */   public static byte[] toByteArray(Object obj)
/*    */   {
/*    */     try
/*    */     {
/* 47 */       ByteArrayOutputStream os = new ByteArrayOutputStream();
/* 48 */       ObjectOutputStream oos = new CustomObjectOutputStream(os);
/*    */ 
/* 50 */       oos.writeObject(obj);
/* 51 */       oos.flush();
/* 52 */       byte[] a = os.toByteArray();
/* 53 */       os.close();
/* 54 */       return a;
/*    */     } catch (IOException ioe) {
/*    */     }
/* 57 */     throw new RuntimeException("Object id serialization error:\n" + ioe);
/*    */   }
/*    */ 
/*    */   public static Object toObject(byte[] a, ClassLoader cl)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 70 */     ByteArrayInputStream is = new ByteArrayInputStream(a);
/* 71 */     ObjectInputStream ois = new CustomObjectInputStreamWithClassloader(is, cl);
/*    */ 
/* 73 */     Object obj = ois.readObject();
/* 74 */     is.close();
/* 75 */     return obj;
/*    */   }
/*    */ 
/*    */   public static Object toObject(byte[] a)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 87 */     return toObject(a, Thread.currentThread().getContextClassLoader());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.Conversion
 * JD-Core Version:    0.6.0
 */