/*      */ package org.jboss.util;
/*      */ 
/*      */ import java.io.BufferedInputStream;
/*      */ import java.io.ByteArrayInputStream;
/*      */ import java.io.ByteArrayOutputStream;
/*      */ import java.io.File;
/*      */ import java.io.FileInputStream;
/*      */ import java.io.FileOutputStream;
/*      */ import java.io.FilterInputStream;
/*      */ import java.io.FilterOutputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.io.ObjectOutputStream;
/*      */ import java.io.OutputStream;
/*      */ import java.io.Serializable;
/*      */ import java.io.UnsupportedEncodingException;
/*      */ import java.util.zip.GZIPInputStream;
/*      */ import java.util.zip.GZIPOutputStream;
/*      */ import org.jboss.logging.Logger;
/*      */ 
/*      */ public class Base64
/*      */ {
/*   76 */   private static final Logger log = Logger.getLogger(Base64.class);
/*      */   public static final int NO_OPTIONS = 0;
/*      */   public static final int ENCODE = 1;
/*      */   public static final int DECODE = 0;
/*      */   public static final int GZIP = 2;
/*      */   public static final int DONT_BREAK_LINES = 8;
/*      */   private static final int MAX_LINE_LENGTH = 76;
/*      */   private static final byte EQUALS_SIGN = 61;
/*      */   private static final byte NEW_LINE = 10;
/*      */   private static final String PREFERRED_ENCODING = "UTF-8";
/*      */   private static final byte[] ALPHABET;
/*  111 */   private static final byte[] _NATIVE_ALPHABET = { 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47 };
/*      */   private static final byte[] DECODABET;
/*      */   private static final byte WHITE_SPACE_ENC = -5;
/*      */   private static final byte EQUALS_SIGN_ENC = -1;
/*      */ 
/*      */   private static byte[] encode3to4(byte[] b4, byte[] threeBytes, int numSigBytes)
/*      */   {
/*  199 */     encode3to4(threeBytes, 0, numSigBytes, b4, 0);
/*  200 */     return b4;
/*      */   }
/*      */ 
/*      */   private static byte[] encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset)
/*      */   {
/*  237 */     int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[(srcOffset + 1)] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[(srcOffset + 2)] << 24 >>> 24 : 0);
/*      */ 
/*  240 */     switch (numSigBytes)
/*      */     {
/*      */     case 3:
/*  243 */       destination[destOffset] = ALPHABET[(inBuff >>> 18)];
/*  244 */       destination[(destOffset + 1)] = ALPHABET[(inBuff >>> 12 & 0x3F)];
/*  245 */       destination[(destOffset + 2)] = ALPHABET[(inBuff >>> 6 & 0x3F)];
/*  246 */       destination[(destOffset + 3)] = ALPHABET[(inBuff & 0x3F)];
/*  247 */       return destination;
/*      */     case 2:
/*  250 */       destination[destOffset] = ALPHABET[(inBuff >>> 18)];
/*  251 */       destination[(destOffset + 1)] = ALPHABET[(inBuff >>> 12 & 0x3F)];
/*  252 */       destination[(destOffset + 2)] = ALPHABET[(inBuff >>> 6 & 0x3F)];
/*  253 */       destination[(destOffset + 3)] = 61;
/*  254 */       return destination;
/*      */     case 1:
/*  257 */       destination[destOffset] = ALPHABET[(inBuff >>> 18)];
/*  258 */       destination[(destOffset + 1)] = ALPHABET[(inBuff >>> 12 & 0x3F)];
/*  259 */       destination[(destOffset + 2)] = 61;
/*  260 */       destination[(destOffset + 3)] = 61;
/*  261 */       return destination;
/*      */     }
/*      */ 
/*  264 */     return destination;
/*      */   }
/*      */ 
/*      */   public static String encodeObject(Serializable serializableObject)
/*      */   {
/*  281 */     return encodeObject(serializableObject, 0);
/*      */   }
/*      */ 
/*      */   public static String encodeObject(Serializable serializableObject, int options)
/*      */   {
/*  310 */     ByteArrayOutputStream baos = null;
/*  311 */     OutputStream b64os = null;
/*  312 */     ObjectOutputStream oos = null;
/*  313 */     GZIPOutputStream gzos = null;
/*      */ 
/*  316 */     int gzip = options & 0x2;
/*  317 */     int dontBreakLines = options & 0x8;
/*      */     try
/*      */     {
/*  322 */       baos = new ByteArrayOutputStream();
/*  323 */       b64os = new OutputStream(baos, 0x1 | dontBreakLines);
/*      */ 
/*  326 */       if (gzip == 2)
/*      */       {
/*  328 */         gzos = new GZIPOutputStream(b64os);
/*  329 */         oos = new ObjectOutputStream(gzos);
/*      */       } else {
/*  331 */         oos = new ObjectOutputStream(b64os);
/*      */       }
/*  333 */       oos.writeObject(serializableObject);
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  337 */       e.printStackTrace();
/*  338 */       Object localObject1 = null;
/*      */       return localObject1;
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*  344 */         oos.close();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */       try
/*      */       {
/*  351 */         gzos.close();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */       try
/*      */       {
/*  358 */         b64os.close();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */       try
/*      */       {
/*  365 */         baos.close();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  375 */       return new String(baos.toByteArray(), "UTF-8");
/*      */     }
/*      */     catch (UnsupportedEncodingException uue) {
/*      */     }
/*  379 */     return new String(baos.toByteArray());
/*      */   }
/*      */ 
/*      */   public static String encodeBytes(byte[] source)
/*      */   {
/*  393 */     return encodeBytes(source, 0, source.length, 0);
/*      */   }
/*      */ 
/*      */   public static String encodeBytes(byte[] source, int options)
/*      */   {
/*  418 */     return encodeBytes(source, 0, source.length, options);
/*      */   }
/*      */ 
/*      */   public static String encodeBytes(byte[] source, int off, int len)
/*      */   {
/*  432 */     return encodeBytes(source, off, len, 0);
/*      */   }
/*      */ 
/*      */   public static String encodeBytes(byte[] source, int off, int len, int options)
/*      */   {
/*  460 */     int dontBreakLines = options & 0x8;
/*  461 */     int gzip = options & 0x2;
/*      */ 
/*  464 */     if (gzip == 2)
/*      */     {
/*  466 */       ByteArrayOutputStream baos = null;
/*  467 */       GZIPOutputStream gzos = null;
/*  468 */       OutputStream b64os = null;
/*      */       try
/*      */       {
/*  473 */         baos = new ByteArrayOutputStream();
/*  474 */         b64os = new OutputStream(baos, 0x1 | dontBreakLines);
/*  475 */         gzos = new GZIPOutputStream(b64os);
/*      */ 
/*  477 */         gzos.write(source, off, len);
/*  478 */         gzos.close();
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/*  482 */         e.printStackTrace();
/*  483 */         Object localObject1 = null;
/*      */         return localObject1;
/*      */       }
/*      */       finally
/*      */       {
/*      */         try
/*      */         {
/*  489 */           gzos.close();
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/*      */         }
/*      */         try
/*      */         {
/*  496 */           b64os.close();
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/*      */         }
/*      */         try
/*      */         {
/*  503 */           baos.close();
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  513 */         return new String(baos.toByteArray(), "UTF-8");
/*      */       }
/*      */       catch (UnsupportedEncodingException uue)
/*      */       {
/*  517 */         return new String(baos.toByteArray());
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  525 */     boolean breakLines = dontBreakLines == 0;
/*      */ 
/*  527 */     int len43 = len * 4 / 3;
/*  528 */     byte[] outBuff = new byte[len43 + (len % 3 > 0 ? 4 : 0) + (breakLines ? len43 / 76 : 0)];
/*      */ 
/*  531 */     int d = 0;
/*  532 */     int e = 0;
/*  533 */     int len2 = len - 2;
/*  534 */     int lineLength = 0;
/*  535 */     for (; d < len2; e += 4)
/*      */     {
/*  537 */       encode3to4(source, d + off, 3, outBuff, e);
/*      */ 
/*  539 */       lineLength += 4;
/*  540 */       if ((breakLines) && (lineLength == 76))
/*      */       {
/*  542 */         outBuff[(e + 4)] = 10;
/*  543 */         e++;
/*  544 */         lineLength = 0;
/*      */       }
/*  535 */       d += 3;
/*      */     }
/*      */ 
/*  548 */     if (d < len)
/*      */     {
/*  550 */       encode3to4(source, d + off, len - d, outBuff, e);
/*  551 */       e += 4;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  557 */       return new String(outBuff, 0, e, "UTF-8");
/*      */     }
/*      */     catch (UnsupportedEncodingException uue) {
/*      */     }
/*  561 */     return new String(outBuff, 0, e);
/*      */   }
/*      */ 
/*      */   private static int decode4to3(byte[] source, int srcOffset, byte[] destination, int destOffset)
/*      */   {
/*  595 */     if (source[(srcOffset + 2)] == 61)
/*      */     {
/*  600 */       int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[(srcOffset + 1)]] & 0xFF) << 12;
/*      */ 
/*  602 */       destination[destOffset] = (byte)(outBuff >>> 16);
/*  603 */       return 1;
/*      */     }
/*      */ 
/*  607 */     if (source[(srcOffset + 3)] == 61)
/*      */     {
/*  613 */       int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[(srcOffset + 1)]] & 0xFF) << 12 | (DECODABET[source[(srcOffset + 2)]] & 0xFF) << 6;
/*      */ 
/*  616 */       destination[destOffset] = (byte)(outBuff >>> 16);
/*  617 */       destination[(destOffset + 1)] = (byte)(outBuff >>> 8);
/*  618 */       return 2;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  631 */       int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[(srcOffset + 1)]] & 0xFF) << 12 | (DECODABET[source[(srcOffset + 2)]] & 0xFF) << 6 | DECODABET[source[(srcOffset + 3)]] & 0xFF;
/*      */ 
/*  634 */       destination[destOffset] = (byte)(outBuff >> 16);
/*  635 */       destination[(destOffset + 1)] = (byte)(outBuff >> 8);
/*  636 */       destination[(destOffset + 2)] = (byte)outBuff;
/*      */ 
/*  638 */       return 3;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  642 */       log.error("" + source[srcOffset] + ": " + DECODABET[source[srcOffset]]);
/*  643 */       log.error("" + source[(srcOffset + 1)] + ": " + DECODABET[source[(srcOffset + 1)]]);
/*  644 */       log.error("" + source[(srcOffset + 2)] + ": " + DECODABET[source[(srcOffset + 2)]]);
/*  645 */       log.error("" + source[(srcOffset + 3)] + ": " + DECODABET[source[(srcOffset + 3)]]);
/*  646 */     }return -1;
/*      */   }
/*      */ 
/*      */   public static byte[] decode(byte[] source, int off, int len)
/*      */   {
/*  664 */     int len34 = len * 3 / 4;
/*  665 */     byte[] outBuff = new byte[len34];
/*  666 */     int outBuffPosn = 0;
/*      */ 
/*  668 */     byte[] b4 = new byte[4];
/*  669 */     int b4Posn = 0;
/*  670 */     int i = 0;
/*  671 */     byte sbiCrop = 0;
/*  672 */     byte sbiDecode = 0;
/*  673 */     for (i = off; i < off + len; i++)
/*      */     {
/*  675 */       sbiCrop = (byte)(source[i] & 0x7F);
/*  676 */       sbiDecode = DECODABET[sbiCrop];
/*      */ 
/*  678 */       if (sbiDecode >= -5)
/*      */       {
/*  680 */         if (sbiDecode < -1)
/*      */           continue;
/*  682 */         b4[(b4Posn++)] = sbiCrop;
/*  683 */         if (b4Posn <= 3)
/*      */           continue;
/*  685 */         outBuffPosn += decode4to3(b4, 0, outBuff, outBuffPosn);
/*  686 */         b4Posn = 0;
/*      */ 
/*  689 */         if (sbiCrop == 61) {
/*  690 */           break;
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  698 */         throw new IllegalStateException("Bad Base64 input character at " + i + ": " + source[i] + "(decimal)");
/*      */       }
/*      */     }
/*      */ 
/*  702 */     byte[] out = new byte[outBuffPosn];
/*  703 */     System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
/*  704 */     return out;
/*      */   }
/*      */ 
/*      */   public static byte[] decode(String s)
/*      */   {
/*      */     try
/*      */     {
/*  720 */       bytes = s.getBytes("UTF-8");
/*      */     }
/*      */     catch (UnsupportedEncodingException uee)
/*      */     {
/*  724 */       bytes = s.getBytes();
/*      */     }
/*      */ 
/*  729 */     byte[] bytes = decode(bytes, 0, bytes.length);
/*      */ 
/*  733 */     if ((bytes != null) && (bytes.length >= 4))
/*      */     {
/*  736 */       int head = bytes[0] & 0xFF | bytes[1] << 8 & 0xFF00;
/*  737 */       if (35615 == head)
/*      */       {
/*  739 */         ByteArrayInputStream bais = null;
/*  740 */         GZIPInputStream gzis = null;
/*  741 */         ByteArrayOutputStream baos = null;
/*  742 */         byte[] buffer = new byte[2048];
/*  743 */         int length = 0;
/*      */         try
/*      */         {
/*  747 */           baos = new ByteArrayOutputStream();
/*  748 */           bais = new ByteArrayInputStream(bytes);
/*  749 */           gzis = new GZIPInputStream(bais);
/*      */ 
/*  751 */           while ((length = gzis.read(buffer)) >= 0)
/*      */           {
/*  753 */             baos.write(buffer, 0, length);
/*      */           }
/*      */ 
/*  757 */           bytes = baos.toByteArray();
/*      */         }
/*      */         catch (IOException e)
/*      */         {
/*      */         }
/*      */         finally
/*      */         {
/*      */           try
/*      */           {
/*  768 */             baos.close();
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*      */           }
/*      */           try
/*      */           {
/*  775 */             gzis.close();
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*      */           }
/*      */           try
/*      */           {
/*  782 */             bais.close();
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  792 */     return bytes;
/*      */   }
/*      */ 
/*      */   public static Object decodeToObject(String encodedObject)
/*      */   {
/*  806 */     byte[] objBytes = decode(encodedObject);
/*      */ 
/*  808 */     ByteArrayInputStream bais = null;
/*  809 */     ObjectInputStream ois = null;
/*  810 */     Object obj = null;
/*      */     try
/*      */     {
/*  814 */       bais = new ByteArrayInputStream(objBytes);
/*  815 */       ois = new ObjectInputStream(bais);
/*      */ 
/*  817 */       obj = ois.readObject();
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  821 */       e.printStackTrace();
/*  822 */       obj = null;
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*  826 */       e.printStackTrace();
/*  827 */       obj = null;
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*  833 */         bais.close();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */       try
/*      */       {
/*  840 */         ois.close();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */     }
/*      */ 
/*  847 */     return obj;
/*      */   }
/*      */ 
/*      */   public static boolean encodeToFile(byte[] dataToEncode, String filename)
/*      */   {
/*  861 */     boolean success = false;
/*  862 */     OutputStream bos = null;
/*      */     try
/*      */     {
/*  865 */       bos = new OutputStream(new FileOutputStream(filename), 1);
/*  866 */       bos.write(dataToEncode);
/*  867 */       success = true;
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  872 */       success = false;
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*  878 */         bos.close();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */     }
/*      */ 
/*  885 */     return success;
/*      */   }
/*      */ 
/*      */   public static boolean decodeToFile(String dataToDecode, String filename)
/*      */   {
/*  899 */     boolean success = false;
/*  900 */     OutputStream bos = null;
/*      */     try
/*      */     {
/*  903 */       bos = new OutputStream(new FileOutputStream(filename), 0);
/*  904 */       bos.write(dataToDecode.getBytes("UTF-8"));
/*  905 */       success = true;
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  909 */       success = false;
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*  915 */         bos.close();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */     }
/*      */ 
/*  922 */     return success;
/*      */   }
/*      */ 
/*      */   public static byte[] decodeFromFile(String filename)
/*      */   {
/*  936 */     byte[] decodedData = null;
/*  937 */     InputStream bis = null;
/*      */     try
/*      */     {
/*  941 */       File file = new File(filename);
/*  942 */       byte[] buffer = null;
/*  943 */       int length = 0;
/*  944 */       int numBytes = 0;
/*      */ 
/*  947 */       if (file.length() > 2147483647L)
/*      */       {
/*  949 */         throw new IllegalStateException("File is too big for this convenience method (" + file.length() + " bytes).");
/*      */       }
/*  951 */       buffer = new byte[(int)file.length()];
/*      */ 
/*  954 */       bis = new InputStream(new BufferedInputStream(new FileInputStream(file)), 0);
/*      */ 
/*  957 */       while ((numBytes = bis.read(buffer, length, 4096)) >= 0) {
/*  958 */         length += numBytes;
/*      */       }
/*      */ 
/*  961 */       decodedData = new byte[length];
/*  962 */       System.arraycopy(buffer, 0, decodedData, 0, length);
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  967 */       throw new IllegalStateException("Error decoding from file " + filename);
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*  973 */         bis.close();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */     }
/*      */ 
/*  980 */     return decodedData;
/*      */   }
/*      */ 
/*      */   public static String encodeFromFile(String filename)
/*      */   {
/*  994 */     String encodedData = null;
/*  995 */     InputStream bis = null;
/*      */     try
/*      */     {
/*  999 */       File file = new File(filename);
/* 1000 */       byte[] buffer = new byte[(int)(file.length() * 1.4D)];
/* 1001 */       int length = 0;
/* 1002 */       int numBytes = 0;
/*      */ 
/* 1005 */       bis = new InputStream(new BufferedInputStream(new FileInputStream(file)), 1);
/*      */ 
/* 1008 */       while ((numBytes = bis.read(buffer, length, 4096)) >= 0) {
/* 1009 */         length += numBytes;
/*      */       }
/*      */ 
/* 1012 */       encodedData = new String(buffer, 0, length, "UTF-8");
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/* 1017 */       throw new IllegalStateException("Error encoding from file " + filename);
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/* 1023 */         bis.close();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */     }
/*      */ 
/* 1030 */     return encodedData;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*      */     byte[] __bytes;
/*      */     try
/*      */     {
/*  124 */       __bytes = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes("UTF-8");
/*      */     }
/*      */     catch (UnsupportedEncodingException use)
/*      */     {
/*  128 */       __bytes = _NATIVE_ALPHABET;
/*      */     }
/*  130 */     ALPHABET = __bytes;
/*      */ 
/*  137 */     DECODABET = new byte[] { -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9 };
/*      */   }
/*      */ 
/*      */   public static class OutputStream extends FilterOutputStream
/*      */   {
/*      */     private boolean encode;
/*      */     private int position;
/*      */     private byte[] buffer;
/*      */     private int bufferLength;
/*      */     private int lineLength;
/*      */     private boolean breakLines;
/*      */     private byte[] b4;
/*      */     private boolean suspendEncoding;
/*      */ 
/*      */     public OutputStream(OutputStream out)
/*      */     {
/* 1285 */       this(out, 1);
/*      */     }
/*      */ 
/*      */     public OutputStream(OutputStream out, int options)
/*      */     {
/* 1310 */       super();
/* 1311 */       this.breakLines = ((options & 0x8) != 8);
/* 1312 */       this.encode = ((options & 0x1) == 1);
/* 1313 */       this.bufferLength = (this.encode ? 3 : 4);
/* 1314 */       this.buffer = new byte[this.bufferLength];
/* 1315 */       this.position = 0;
/* 1316 */       this.lineLength = 0;
/* 1317 */       this.suspendEncoding = false;
/* 1318 */       this.b4 = new byte[4];
/*      */     }
/*      */ 
/*      */     public void write(int theByte)
/*      */       throws IOException
/*      */     {
/* 1336 */       if (this.suspendEncoding)
/*      */       {
/* 1338 */         this.out.write(theByte);
/* 1339 */         return;
/*      */       }
/*      */ 
/* 1343 */       if (this.encode)
/*      */       {
/* 1345 */         this.buffer[(this.position++)] = (byte)theByte;
/* 1346 */         if (this.position >= this.bufferLength)
/*      */         {
/* 1348 */           this.out.write(Base64.access$300(this.b4, this.buffer, this.bufferLength));
/*      */ 
/* 1350 */           this.lineLength += 4;
/* 1351 */           if ((this.breakLines) && (this.lineLength >= 76))
/*      */           {
/* 1353 */             this.out.write(10);
/* 1354 */             this.lineLength = 0;
/*      */           }
/*      */ 
/* 1357 */           this.position = 0;
/*      */         }
/*      */ 
/*      */       }
/* 1365 */       else if (Base64.DECODABET[(theByte & 0x7F)] > -5)
/*      */       {
/* 1367 */         this.buffer[(this.position++)] = (byte)theByte;
/* 1368 */         if (this.position >= this.bufferLength)
/*      */         {
/* 1370 */           int len = Base64.access$200(this.buffer, 0, this.b4, 0);
/* 1371 */           this.out.write(this.b4, 0, len);
/*      */ 
/* 1373 */           this.position = 0;
/*      */         }
/*      */       }
/* 1376 */       else if (Base64.DECODABET[(theByte & 0x7F)] != -5)
/*      */       {
/* 1378 */         throw new IOException("Invalid character in Base64 data.");
/*      */       }
/*      */     }
/*      */ 
/*      */     public void write(byte[] theBytes, int off, int len)
/*      */       throws IOException
/*      */     {
/* 1395 */       if (this.suspendEncoding)
/*      */       {
/* 1397 */         this.out.write(theBytes, off, len);
/* 1398 */         return;
/*      */       }
/*      */ 
/* 1401 */       for (int i = 0; i < len; i++)
/*      */       {
/* 1403 */         write(theBytes[(off + i)]);
/*      */       }
/*      */     }
/*      */ 
/*      */     public void flushBase64()
/*      */       throws IOException
/*      */     {
/* 1414 */       if (this.position > 0)
/*      */       {
/* 1416 */         if (this.encode)
/*      */         {
/* 1418 */           this.out.write(Base64.access$300(this.b4, this.buffer, this.position));
/* 1419 */           this.position = 0;
/*      */         }
/*      */         else
/*      */         {
/* 1423 */           throw new IOException("Base64 input not properly padded.");
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*      */     public void close()
/*      */       throws IOException
/*      */     {
/* 1437 */       flushBase64();
/*      */ 
/* 1441 */       super.close();
/*      */ 
/* 1443 */       this.buffer = null;
/* 1444 */       this.out = null;
/*      */     }
/*      */ 
/*      */     public void suspendEncoding()
/*      */       throws IOException
/*      */     {
/* 1456 */       flushBase64();
/* 1457 */       this.suspendEncoding = true;
/*      */     }
/*      */ 
/*      */     public void resumeEncoding()
/*      */     {
/* 1469 */       this.suspendEncoding = false;
/*      */     }
/*      */   }
/*      */ 
/*      */   public static class InputStream extends FilterInputStream
/*      */   {
/*      */     private boolean encode;
/*      */     private int position;
/*      */     private byte[] buffer;
/*      */     private int bufferLength;
/*      */     private int numSigBytes;
/*      */     private int lineLength;
/*      */     private boolean breakLines;
/*      */ 
/*      */     public InputStream(InputStream in)
/*      */     {
/* 1061 */       this(in, 0);
/*      */     }
/*      */ 
/*      */     public InputStream(InputStream in, int options)
/*      */     {
/* 1087 */       super();
/* 1088 */       this.breakLines = ((options & 0x8) != 8);
/* 1089 */       this.encode = ((options & 0x1) == 1);
/* 1090 */       this.bufferLength = (this.encode ? 4 : 3);
/* 1091 */       this.buffer = new byte[this.bufferLength];
/* 1092 */       this.position = -1;
/* 1093 */       this.lineLength = 0;
/*      */     }
/*      */ 
/*      */     public int read()
/*      */       throws IOException
/*      */     {
/* 1106 */       if (this.position < 0)
/*      */       {
/* 1108 */         if (this.encode)
/*      */         {
/* 1110 */           byte[] b3 = new byte[3];
/* 1111 */           int numBinaryBytes = 0;
/* 1112 */           for (int i = 0; i < 3; i++)
/*      */           {
/*      */             try
/*      */             {
/* 1116 */               int b = this.in.read();
/*      */ 
/* 1119 */               if (b >= 0)
/*      */               {
/* 1121 */                 b3[i] = (byte)b;
/* 1122 */                 numBinaryBytes++;
/*      */               }
/*      */ 
/*      */             }
/*      */             catch (IOException e)
/*      */             {
/* 1129 */               if (i == 0) {
/* 1130 */                 throw e;
/*      */               }
/*      */             }
/*      */           }
/*      */ 
/* 1135 */           if (numBinaryBytes > 0)
/*      */           {
/* 1137 */             Base64.access$000(b3, 0, numBinaryBytes, this.buffer, 0);
/* 1138 */             this.position = 0;
/* 1139 */             this.numSigBytes = 4;
/*      */           }
/*      */           else
/*      */           {
/* 1143 */             return -1;
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/* 1150 */           byte[] b4 = new byte[4];
/* 1151 */           int i = 0;
/* 1152 */           for (i = 0; i < 4; i++)
/*      */           {
/* 1155 */             int b = 0;
/*      */             do
/*      */             {
/* 1158 */               b = this.in.read();
/*      */             }
/* 1160 */             while ((b >= 0) && (Base64.DECODABET[(b & 0x7F)] <= -5));
/*      */ 
/* 1162 */             if (b < 0) {
/*      */               break;
/*      */             }
/* 1165 */             b4[i] = (byte)b;
/*      */           }
/*      */ 
/* 1168 */           if (i == 4)
/*      */           {
/* 1170 */             this.numSigBytes = Base64.access$200(b4, 0, this.buffer, 0);
/* 1171 */             this.position = 0;
/*      */           } else {
/* 1173 */             if (i == 0)
/*      */             {
/* 1175 */               return -1;
/*      */             }
/*      */ 
/* 1180 */             throw new IOException("Improperly padded Base64 input.");
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1187 */       if (this.position >= 0)
/*      */       {
/* 1190 */         if (this.position >= this.numSigBytes) {
/* 1191 */           return -1;
/*      */         }
/* 1193 */         if ((this.encode) && (this.breakLines) && (this.lineLength >= 76))
/*      */         {
/* 1195 */           this.lineLength = 0;
/* 1196 */           return 10;
/*      */         }
/*      */ 
/* 1200 */         this.lineLength += 1;
/*      */ 
/* 1204 */         int b = this.buffer[(this.position++)];
/*      */ 
/* 1206 */         if (this.position >= this.bufferLength) {
/* 1207 */           this.position = -1;
/*      */         }
/* 1209 */         return b & 0xFF;
/*      */       }
/*      */ 
/* 1218 */       throw new IOException("Error in Base64 code reading stream.");
/*      */     }
/*      */ 
/*      */     public int read(byte[] dest, int off, int len)
/*      */       throws IOException
/*      */     {
/* 1238 */       for (int i = 0; i < len; i++)
/*      */       {
/* 1240 */         int b = read();
/*      */ 
/* 1245 */         if (b >= 0) {
/* 1246 */           dest[(off + i)] = (byte)b; } else {
/* 1247 */           if (i != 0) break;
/* 1248 */           return -1;
/*      */         }
/*      */       }
/* 1251 */       return i;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.Base64
 * JD-Core Version:    0.6.0
 */