/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.io.PrintWriter;
/*     */ 
/*     */ public abstract class AbstractNestedThrowable extends Throwable
/*     */   implements NestedThrowable
/*     */ {
/*     */   protected final Throwable nested;
/*     */ 
/*     */   public AbstractNestedThrowable(String msg)
/*     */   {
/*  48 */     super(msg);
/*  49 */     this.nested = null;
/*     */   }
/*     */ 
/*     */   public AbstractNestedThrowable(String msg, Throwable nested)
/*     */   {
/*  60 */     super(msg);
/*  61 */     this.nested = nested;
/*  62 */     NestedThrowable.Util.checkNested(this, nested);
/*     */   }
/*     */ 
/*     */   public AbstractNestedThrowable(Throwable nested)
/*     */   {
/*  72 */     this(nested.getMessage(), nested);
/*     */   }
/*     */ 
/*     */   public AbstractNestedThrowable()
/*     */   {
/*  80 */     this.nested = null;
/*     */   }
/*     */ 
/*     */   public Throwable getNested()
/*     */   {
/*  89 */     return this.nested;
/*     */   }
/*     */ 
/*     */   public Throwable getCause()
/*     */   {
/* 100 */     return this.nested;
/*     */   }
/*     */ 
/*     */   public String getMessage()
/*     */   {
/* 109 */     return NestedThrowable.Util.getMessage(super.getMessage(), this.nested);
/*     */   }
/*     */ 
/*     */   public void printStackTrace(PrintStream stream)
/*     */   {
/* 119 */     if ((this.nested == null) || (NestedThrowable.PARENT_TRACE_ENABLED)) {
/* 120 */       super.printStackTrace(stream);
/*     */     }
/* 122 */     NestedThrowable.Util.print(this.nested, stream);
/*     */   }
/*     */ 
/*     */   public void printStackTrace(PrintWriter writer)
/*     */   {
/* 132 */     if ((this.nested == null) || (NestedThrowable.PARENT_TRACE_ENABLED)) {
/* 133 */       super.printStackTrace(writer);
/*     */     }
/* 135 */     NestedThrowable.Util.print(this.nested, writer);
/*     */   }
/*     */ 
/*     */   public void printStackTrace()
/*     */   {
/* 143 */     printStackTrace(System.err);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.AbstractNestedThrowable
 * JD-Core Version:    0.6.0
 */