/*    */ package org.jboss.tm.usertx.client;
/*    */ 
/*    */ import java.util.Hashtable;
/*    */ import javax.naming.Context;
/*    */ import javax.naming.InitialContext;
/*    */ import javax.naming.Name;
/*    */ import javax.naming.NamingException;
/*    */ import javax.naming.Reference;
/*    */ import javax.naming.spi.ObjectFactory;
/*    */ import javax.transaction.UserTransaction;
/*    */ import org.jboss.tm.TransactionPropagationContextUtil;
/*    */ 
/*    */ public class ClientUserTransactionObjectFactory
/*    */   implements ObjectFactory
/*    */ {
/* 52 */   private static UserTransaction userTransaction = null;
/*    */ 
/*    */   private static UserTransaction getUserTransaction()
/*    */   {
/* 60 */     if (userTransaction == null) {
/*    */       try
/*    */       {
/* 63 */         new InitialContext().lookup("java:/TransactionManager");
/*    */ 
/* 66 */         userTransaction = ServerVMClientUserTransaction.getSingleton();
/*    */       }
/*    */       catch (NamingException ex) {
/* 69 */         ClientUserTransaction cut = ClientUserTransaction.getSingleton();
/*    */ 
/* 73 */         TransactionPropagationContextUtil.setTPCFactory(cut);
/* 74 */         userTransaction = cut;
/*    */       }
/*    */     }
/* 77 */     return userTransaction;
/*    */   }
/*    */ 
/*    */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment)
/*    */     throws Exception
/*    */   {
/* 84 */     Reference ref = (Reference)obj;
/*    */ 
/* 86 */     if (!ref.getClassName().equals(ClientUserTransaction.class.getName())) {
/* 87 */       return null;
/*    */     }
/* 89 */     return getUserTransaction();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.tm.usertx.client.ClientUserTransactionObjectFactory
 * JD-Core Version:    0.6.0
 */