/*     */ package org.jboss.tm.iiop;
/*     */ 
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.proxy.ejb.ForeignTransaction;
/*     */ import org.omg.CORBA.Any;
/*     */ import org.omg.CORBA.BAD_PARAM;
/*     */ import org.omg.CORBA.LocalObject;
/*     */ import org.omg.CORBA.TCKind;
/*     */ import org.omg.CORBA.TypeCode;
/*     */ import org.omg.CosTransactions.PropagationContextHelper;
/*     */ import org.omg.IOP.Codec;
/*     */ import org.omg.IOP.CodecPackage.FormatMismatch;
/*     */ import org.omg.IOP.CodecPackage.TypeMismatch;
/*     */ import org.omg.IOP.ServiceContext;
/*     */ import org.omg.PortableInterceptor.Current;
/*     */ import org.omg.PortableInterceptor.InvalidSlot;
/*     */ import org.omg.PortableInterceptor.ServerRequestInfo;
/*     */ import org.omg.PortableInterceptor.ServerRequestInterceptor;
/*     */ 
/*     */ public class TxServerInterceptor extends LocalObject
/*     */   implements ServerRequestInterceptor
/*     */ {
/*     */   static final long serialVersionUID = 7474707114565659371L;
/*  66 */   private static final Logger log = Logger.getLogger(TxServerInterceptor.class);
/*     */ 
/*  68 */   private static final boolean traceEnabled = log.isTraceEnabled();
/*     */   private static final int txContextId = 0;
/*     */   private static int slotId;
/*     */   private static Codec codec;
/*  73 */   private static Current piCurrent = null;
/*     */ 
/*     */   static void init(int slotId, Codec codec, Current piCurrent)
/*     */   {
/*  84 */     slotId = slotId;
/*  85 */     codec = codec;
/*  86 */     piCurrent = piCurrent;
/*     */   }
/*     */ 
/*     */   public static Transaction getCurrentTransaction()
/*     */   {
/*  95 */     Transaction tx = null;
/*  96 */     if (piCurrent != null)
/*     */     {
/*     */       try
/*     */       {
/* 102 */         Any any = piCurrent.get_slot(slotId);
/* 103 */         if (any.type().kind().value() != 0)
/*     */         {
/* 106 */           tx = ForeignTransaction.instance;
/*     */         }
/*     */       }
/*     */       catch (InvalidSlot e)
/*     */       {
/* 111 */         throw new RuntimeException("Exception getting slot in TxServerInterceptor: " + e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 116 */     return tx;
/*     */   }
/*     */ 
/*     */   public String name()
/*     */   {
/* 130 */     return "TxServerInterceptor";
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void receive_request_service_contexts(ServerRequestInfo ri)
/*     */   {
/* 142 */     if (traceEnabled) {
/* 143 */       log.trace("Intercepting receive_request_service_contexts, operation: " + ri.operation());
/*     */     }
/*     */     try
/*     */     {
/* 147 */       ServiceContext sc = ri.get_request_service_context(0);
/* 148 */       Any any = codec.decode_value(sc.context_data, PropagationContextHelper.type());
/*     */ 
/* 150 */       ri.set_slot(slotId, any);
/*     */     }
/*     */     catch (BAD_PARAM e)
/*     */     {
/*     */     }
/*     */     catch (FormatMismatch e)
/*     */     {
/* 158 */       throw new RuntimeException("Exception decoding context data in TxServerInterceptor: " + e);
/*     */     }
/*     */     catch (TypeMismatch e)
/*     */     {
/* 163 */       throw new RuntimeException("Exception decoding context data in TxServerInterceptor: " + e);
/*     */     }
/*     */     catch (InvalidSlot e)
/*     */     {
/* 168 */       throw new RuntimeException("Exception setting slot in TxServerInterceptor: " + e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void receive_request(ServerRequestInfo ri)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void send_reply(ServerRequestInfo ri)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void send_exception(ServerRequestInfo ri)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void send_other(ServerRequestInfo ri)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.tm.iiop.TxServerInterceptor
 * JD-Core Version:    0.6.0
 */