/*     */ package org.jboss.tm.iiop;
/*     */ 
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.iiop.CorbaORB;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.tm.TxUtils;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ import org.omg.CORBA.Any;
/*     */ import org.omg.CORBA.LocalObject;
/*     */ import org.omg.CosTransactions.PropagationContext;
/*     */ import org.omg.CosTransactions.PropagationContextHelper;
/*     */ import org.omg.CosTransactions.TransIdentity;
/*     */ import org.omg.CosTransactions.otid_t;
/*     */ import org.omg.IOP.Codec;
/*     */ import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
/*     */ import org.omg.IOP.ServiceContext;
/*     */ import org.omg.PortableInterceptor.ClientRequestInfo;
/*     */ import org.omg.PortableInterceptor.ClientRequestInterceptor;
/*     */ 
/*     */ public class TxServerClientInterceptor extends LocalObject
/*     */   implements ClientRequestInterceptor
/*     */ {
/*     */   static final long serialVersionUID = 4716203472714459196L;
/*  64 */   private static final Logger log = Logger.getLogger(TxServerClientInterceptor.class);
/*     */ 
/*  66 */   private static final boolean traceEnabled = log.isTraceEnabled();
/*     */   private static final int txContextId = 0;
/*     */   private static Codec codec;
/*     */   private static TransactionManager tm;
/*     */   private static PropagationContext emptyPC;
/*     */ 
/*     */   static void init(Codec codec)
/*     */   {
/*  77 */     codec = codec;
/*     */   }
/*     */ 
/*     */   static TransactionManager getTransactionManager()
/*     */   {
/*  82 */     if (tm == null)
/*     */     {
/*     */       try
/*     */       {
/*  86 */         Context ctx = new InitialContext();
/*  87 */         tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/*  91 */         throw new NestedRuntimeException("java:/TransactionManager lookup failed", e);
/*     */       }
/*     */     }
/*  94 */     return tm;
/*     */   }
/*     */ 
/*     */   static PropagationContext getEmptyPropagationContext()
/*     */   {
/*  99 */     if (emptyPC == null)
/*     */     {
/* 103 */       emptyPC = new PropagationContext();
/* 104 */       emptyPC.parents = new TransIdentity[0];
/* 105 */       emptyPC.current = new TransIdentity();
/* 106 */       emptyPC.current.otid = new otid_t();
/* 107 */       emptyPC.current.otid.formatID = 666;
/* 108 */       emptyPC.current.otid.bqual_length = 1;
/* 109 */       emptyPC.current.otid.tid = new byte[] { 1 };
/* 110 */       emptyPC.implementation_specific_data = org.omg.CORBA_2_3.ORB.init().create_any();
/* 111 */       emptyPC.implementation_specific_data.insert_boolean(false);
/*     */     }
/* 113 */     return emptyPC;
/*     */   }
/*     */ 
/*     */   public String name()
/*     */   {
/* 127 */     return "TxServerClientInterceptor";
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void send_request(ClientRequestInfo ri)
/*     */   {
/* 139 */     if (traceEnabled)
/* 140 */       log.trace("Intercepting send_request, operation: " + ri.operation());
/*     */     try
/*     */     {
/* 143 */       Any any = getTransactionPropagationContextAny();
/* 144 */       if (any != null)
/*     */       {
/* 146 */         ServiceContext sc = new ServiceContext(0, codec.encode_value(any));
/* 147 */         ri.add_request_service_context(sc, true);
/*     */       }
/*     */     }
/*     */     catch (InvalidTypeForEncoding e)
/*     */     {
/* 152 */       throw new NestedRuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void send_poll(ClientRequestInfo ri)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void receive_reply(ClientRequestInfo ri)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void receive_exception(ClientRequestInfo ri)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void receive_other(ClientRequestInfo ri)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected Any getTransactionPropagationContextAny()
/*     */   {
/*     */     try
/*     */     {
/* 180 */       PropagationContext pc = null;
/* 181 */       TransactionManager tm = getTransactionManager();
/* 182 */       Transaction tx = tm.getTransaction();
/* 183 */       if (!TxUtils.isUncommitted(tx))
/*     */       {
/* 185 */         if (traceEnabled)
/* 186 */           log.trace("No transaction context");
/* 187 */         return null;
/*     */       }
/*     */ 
/* 190 */       if (traceEnabled)
/* 191 */         log.trace("Propagating empty OTS context");
/* 192 */       pc = getEmptyPropagationContext();
/*     */ 
/* 194 */       Any any = CorbaORB.getInstance().create_any();
/* 195 */       PropagationContextHelper.insert(any, pc);
/* 196 */       return any;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 200 */     throw new NestedRuntimeException("Error getting tpc", e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.tm.iiop.TxServerClientInterceptor
 * JD-Core Version:    0.6.0
 */