/*     */ package org.jboss.tm;
/*     */ 
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.transaction.Transaction;
/*     */ 
/*     */ public class TransactionPropagationContextUtil
/*     */ {
/*     */   private static TransactionPropagationContextFactory tpcFactory;
/*     */   private static TransactionPropagationContextImporter tpcImporter;
/*     */   private static final String EXPORTER_JNDI_NAME = "java:/TransactionPropagationContextExporter";
/*     */   private static final String IMPORTER_JNDI_NAME = "java:/TransactionPropagationContextImporter";
/*     */ 
/*     */   public static TransactionPropagationContextFactory getTPCFactoryClientSide()
/*     */   {
/*  44 */     return tpcFactory;
/*     */   }
/*     */ 
/*     */   public static TransactionPropagationContextFactory getTPCFactory()
/*     */   {
/*  49 */     if (tpcFactory == null)
/*     */     {
/*     */       try
/*     */       {
/*  53 */         InitialContext ctx = new InitialContext();
/*     */         try
/*     */         {
/*  56 */           tpcFactory = (TransactionPropagationContextFactory)ctx.lookup("java:/TransactionPropagationContextExporter");
/*     */         }
/*     */         finally
/*     */         {
/*  60 */           ctx.close();
/*     */         }
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/*  65 */         throw new RuntimeException("Unable to lookup java:/TransactionPropagationContextExporter", e);
/*     */       }
/*     */     }
/*  68 */     return tpcFactory;
/*     */   }
/*     */ 
/*     */   public static void setTPCFactory(TransactionPropagationContextFactory tpcFactory)
/*     */   {
/*  73 */     tpcFactory = tpcFactory;
/*     */   }
/*     */ 
/*     */   public static TransactionPropagationContextImporter getTPCImporter()
/*     */   {
/*  78 */     if (tpcImporter == null)
/*     */     {
/*     */       try
/*     */       {
/*  82 */         InitialContext ctx = new InitialContext();
/*     */         try
/*     */         {
/*  86 */           tpcImporter = (TransactionPropagationContextImporter)ctx.lookup("java:/TransactionPropagationContextImporter");
/*     */         }
/*     */         finally
/*     */         {
/*  90 */           ctx.close();
/*     */         }
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/*  95 */         throw new RuntimeException("Unable to look up java:/TransactionPropagationContextImporter", e);
/*     */       }
/*     */     }
/*  98 */     return tpcImporter;
/*     */   }
/*     */ 
/*     */   public static void setTPCImporter(TransactionPropagationContextImporter importer)
/*     */   {
/* 103 */     tpcImporter = importer;
/*     */   }
/*     */ 
/*     */   public static Transaction importTPC(Object tpc)
/*     */   {
/* 108 */     return getTPCImporter().importTransactionPropagationContext(tpc);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.tm.TransactionPropagationContextUtil
 * JD-Core Version:    0.6.0
 */