/*     */ package org.jboss.tm;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class TransactionManagerLocator
/*     */   implements TransactionManagerFactory
/*     */ {
/*  43 */   private static final Logger log = Logger.getLogger(TransactionManagerLocator.class);
/*     */   private static final String JNDI_NAME = "java:/TransactionManager";
/*  49 */   private static TransactionManagerLocator instance = new TransactionManagerLocator();
/*     */   private TransactionManager tm;
/*     */ 
/*     */   public static TransactionManagerLocator getInstance()
/*     */   {
/*  68 */     return instance;
/*     */   }
/*     */ 
/*     */   public static TransactionManager locateTransactionManager()
/*     */   {
/*  78 */     return getInstance().locate();
/*     */   }
/*     */ 
/*     */   public TransactionManager getTransactionManager()
/*     */   {
/*  88 */     return locate();
/*     */   }
/*     */ 
/*     */   public TransactionManager locate()
/*     */   {
/*  98 */     if (this.tm != null) {
/*  99 */       return this.tm;
/*     */     }
/* 101 */     TransactionManager result = tryJNDI();
/* 102 */     if (result == null)
/* 103 */       result = usePrivateAPI();
/* 104 */     if (result == null) {
/* 105 */       throw new RuntimeException("Unable to locate the transaction manager");
/*     */     }
/* 107 */     return result;
/*     */   }
/*     */ 
/*     */   protected TransactionManager tryJNDI()
/*     */   {
/*     */     try
/*     */     {
/* 119 */       InitialContext ctx = new InitialContext();
/* 120 */       this.tm = ((TransactionManager)ctx.lookup("java:/TransactionManager"));
/* 121 */       if (log.isTraceEnabled())
/* 122 */         log.trace("Got a transaction manager from jndi " + this.tm);
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 126 */       log.debug("Unable to lookup: java:/TransactionManager", e);
/*     */     }
/* 128 */     return this.tm;
/*     */   }
/*     */ 
/*     */   protected TransactionManager usePrivateAPI()
/*     */   {
/*     */     try
/*     */     {
/* 142 */       Class clazz = Class.forName("org.jboss.tm.TxManager");
/* 143 */       Method method = clazz.getMethod("getInstance", new Class[0]);
/* 144 */       TransactionManager result = (TransactionManager)method.invoke(null, null);
/* 145 */       log.warn("Using the old JBoss transaction manager " + this.tm);
/* 146 */       return result;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 150 */       log.debug("Unable to instantiate legacy transaction manager", e);
/* 151 */     }return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.tm.TransactionManagerLocator
 * JD-Core Version:    0.6.0
 */