/*     */ package org.jboss.tm;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import java.util.concurrent.TimeUnit;
/*     */ import java.util.concurrent.locks.ReentrantLock;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ 
/*     */ public class TransactionLocalDelegateImpl
/*     */   implements TransactionLocalDelegate
/*     */ {
/*     */   protected TransactionManager manager;
/*  57 */   protected static ConcurrentHashMap<Transaction, TransactionLocalSynchronization> synchronizationsByTransaction = new ConcurrentHashMap();
/*     */ 
/*     */   protected static TransactionLocalSynchronization getSynchronization(Transaction tx, boolean create)
/*     */   {
/*  68 */     synchronized (tx)
/*     */     {
/*  70 */       TransactionLocalSynchronization result = (TransactionLocalSynchronization)synchronizationsByTransaction.get(tx);
/*  71 */       if ((result == null) && (create == true))
/*     */       {
/*  73 */         result = new TransactionLocalSynchronization(tx);
/*     */         try
/*     */         {
/*  76 */           tx.registerSynchronization(result);
/*     */         }
/*     */         catch (RollbackException e)
/*     */         {
/*  80 */           throw new IllegalStateException("Transaction already rolled back or marked for rollback");
/*     */         }
/*     */         catch (SystemException e)
/*     */         {
/*  84 */           throw new RuntimeException("Error registering transaction synchronization with " + tx, e);
/*     */         }
/*  86 */         synchronizationsByTransaction.put(tx, result);
/*     */       }
/*  88 */       return result;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static void removeSynchronization(Transaction tx)
/*     */   {
/*  99 */     synchronizationsByTransaction.remove(tx);
/*     */   }
/*     */ 
/*     */   public TransactionLocalDelegateImpl(TransactionManager manager)
/*     */   {
/* 111 */     this.manager = manager;
/*     */   }
/*     */ 
/*     */   public void lock(TransactionLocal local, Transaction tx) throws InterruptedException
/*     */   {
/* 116 */     TransactionLocalSynchronization sync = getSynchronization(tx, true);
/* 117 */     sync.lock(local);
/*     */   }
/*     */ 
/*     */   public void unlock(TransactionLocal local, Transaction tx)
/*     */   {
/* 122 */     TransactionLocalSynchronization sync = getSynchronization(tx, false);
/* 123 */     if (sync != null)
/* 124 */       sync.unlock(local);
/*     */     else
/* 126 */       throw new IllegalStateException("No synchronization found tx=" + tx + " local=" + local);
/*     */   }
/*     */ 
/*     */   public Object getValue(TransactionLocal local, Transaction tx)
/*     */   {
/* 131 */     TransactionLocalSynchronization sync = getSynchronization(tx, false);
/* 132 */     if (sync == null)
/* 133 */       return null;
/* 134 */     return sync.getValue(local);
/*     */   }
/*     */ 
/*     */   public void storeValue(TransactionLocal local, Transaction tx, Object value)
/*     */   {
/* 139 */     TransactionLocalSynchronization sync = getSynchronization(tx, true);
/* 140 */     sync.setValue(local, value);
/*     */   }
/*     */ 
/*     */   public boolean containsValue(TransactionLocal local, Transaction tx)
/*     */   {
/* 145 */     TransactionLocalSynchronization sync = getSynchronization(tx, false);
/* 146 */     if (sync == null)
/* 147 */       return false;
/* 148 */     return sync.containsValue(local);
/*     */   }
/*     */ 
/*     */   protected static class TransactionLocalSynchronization
/*     */     implements Synchronization
/*     */   {
/*     */     protected Transaction tx;
/* 158 */     private Map<Object, Object> valuesByLocal = Collections.synchronizedMap(new HashMap());
/*     */ 
/* 160 */     protected ReentrantLock reentrantLock = new ReentrantLock();
/*     */ 
/*     */     public TransactionLocalSynchronization(Transaction tx)
/*     */     {
/* 164 */       this.tx = tx;
/*     */     }
/*     */ 
/*     */     public void beforeCompletion()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void afterCompletion(int status)
/*     */     {
/* 173 */       TransactionLocalDelegateImpl.removeSynchronization(this.tx);
/* 174 */       this.valuesByLocal.clear();
/*     */     }
/*     */ 
/*     */     public void lock(Object local) throws InterruptedException
/*     */     {
/* 179 */       boolean locked = this.reentrantLock.tryLock(60000L, TimeUnit.MILLISECONDS);
/* 180 */       if (!locked)
/* 181 */         throw new IllegalStateException("Failed to acquire lock within 60 seconds.");
/*     */     }
/*     */ 
/*     */     public void unlock(Object local)
/*     */     {
/* 186 */       this.reentrantLock.unlock();
/*     */     }
/*     */ 
/*     */     public Object getValue(Object local)
/*     */     {
/* 191 */       return this.valuesByLocal.get(local);
/*     */     }
/*     */ 
/*     */     public void setValue(Object local, Object value)
/*     */     {
/* 196 */       this.valuesByLocal.put(local, value);
/*     */     }
/*     */ 
/*     */     public boolean containsValue(Object local)
/*     */     {
/* 201 */       return this.valuesByLocal.containsKey(local);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.tm.TransactionLocalDelegateImpl
 * JD-Core Version:    0.6.0
 */