/*     */ package org.jboss.test.kernel.junit;
/*     */ 
/*     */ import java.net.URL;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerMode;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.bootstrap.AbstractBootstrap;
/*     */ import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
/*     */ import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.kernel.spi.deployment.KernelDeployment;
/*     */ import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.test.AbstractTestDelegate;
/*     */ 
/*     */ public class MicrocontainerTestDelegate extends AbstractTestDelegate
/*     */ {
/*     */   protected Kernel kernel;
/*     */   protected BasicXMLDeployer deployer;
/*  54 */   protected ControllerMode defaultMode = ControllerMode.AUTOMATIC;
/*     */ 
/*     */   public MicrocontainerTestDelegate(Class clazz)
/*     */     throws Exception
/*     */   {
/*  64 */     super(clazz);
/*     */   }
/*     */ 
/*     */   public void setUp() throws Exception
/*     */   {
/*  69 */     super.setUp();
/*     */     try
/*     */     {
/*  74 */       AbstractBootstrap bootstrap = getBootstrap();
/*  75 */       bootstrap.run();
/*  76 */       this.kernel = bootstrap.getKernel();
/*     */ 
/*  79 */       this.deployer = createDeployer();
/*     */ 
/*  82 */       deploy();
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/*  86 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  90 */       throw e;
/*     */     }
/*     */     catch (Error e)
/*     */     {
/*  94 */       throw e;
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*  98 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected BasicXMLDeployer createDeployer()
/*     */   {
/* 104 */     return new BasicXMLDeployer(this.kernel, this.defaultMode);
/*     */   }
/*     */ 
/*     */   public void tearDown() throws Exception
/*     */   {
/* 109 */     super.tearDown();
/* 110 */     undeploy();
/*     */   }
/*     */ 
/*     */   public ControllerMode getDefaultMode()
/*     */   {
/* 120 */     return this.defaultMode;
/*     */   }
/*     */ 
/*     */   public void setDefaultMode(ControllerMode defaultMode)
/*     */   {
/* 130 */     this.defaultMode = defaultMode;
/*     */   }
/*     */ 
/*     */   protected AbstractBootstrap getBootstrap()
/*     */     throws Exception
/*     */   {
/* 141 */     return new BasicBootstrap();
/*     */   }
/*     */ 
/*     */   protected Object getBean(Object name, ControllerState state)
/*     */   {
/* 154 */     KernelControllerContext context = getControllerContext(name, state);
/* 155 */     return context.getTarget();
/*     */   }
/*     */ 
/*     */   protected KernelMetaDataRepository getMetaDataRepository()
/*     */   {
/* 165 */     return this.kernel.getMetaDataRepository();
/*     */   }
/*     */ 
/*     */   protected KernelControllerContext getControllerContext(Object name, ControllerState state)
/*     */   {
/* 178 */     KernelController controller = this.kernel.getController();
/* 179 */     KernelControllerContext context = (KernelControllerContext)controller.getContext(name, state);
/* 180 */     if (context == null)
/* 181 */       return handleNotFoundContext(controller, name, state);
/* 182 */     return context;
/*     */   }
/*     */ 
/*     */   protected KernelControllerContext handleNotFoundContext(Controller controller, Object name, ControllerState state)
/*     */   {
/* 196 */     throw new IllegalStateException("Bean not found " + name + " at state " + state);
/*     */   }
/*     */ 
/*     */   protected ControllerState change(KernelControllerContext context, ControllerState required)
/*     */     throws Throwable
/*     */   {
/* 209 */     Controller controller = this.kernel.getController();
/* 210 */     controller.change(context, required);
/* 211 */     return context.getState();
/*     */   }
/*     */ 
/*     */   protected void validate()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 223 */       this.deployer.validate();
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 227 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 231 */       throw e;
/*     */     }
/*     */     catch (Error e)
/*     */     {
/* 235 */       throw e;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 239 */       throw new RuntimeException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected KernelDeployment deploy(URL url)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 254 */       this.log.debug("Deploying " + url);
/* 255 */       KernelDeployment deployment = this.deployer.deploy(url);
/* 256 */       this.log.trace("Deployed " + url);
/* 257 */       return deployment;
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 261 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 265 */       throw e;
/*     */     }
/*     */     catch (Error e)
/*     */     {
/* 269 */       throw e;
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 273 */     throw new RuntimeException(t);
/*     */   }
/*     */ 
/*     */   protected void undeploy(KernelDeployment deployment)
/*     */   {
/* 284 */     this.log.debug("Undeploying " + deployment.getName());
/*     */     try
/*     */     {
/* 287 */       this.deployer.undeploy(deployment);
/* 288 */       this.log.trace("Undeployed " + deployment.getName());
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 292 */       this.log.warn("Error during undeployment: " + deployment.getName(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void undeploy(URL url)
/*     */   {
/* 303 */     this.log.debug("Undeploying " + url);
/*     */     try
/*     */     {
/* 306 */       this.deployer.undeploy(url);
/* 307 */       this.log.trace("Undeployed " + url);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 311 */       this.log.warn("Error during undeployment: " + url, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void deploy()
/*     */     throws Exception
/*     */   {
/* 322 */     String testName = getTestName();
/* 323 */     URL url = getTestResource(testName);
/* 324 */     if (url != null)
/* 325 */       deploy(url);
/*     */     else
/* 327 */       this.log.debug("No test specific deployment " + testName);
/*     */   }
/*     */ 
/*     */   protected void shutdown()
/*     */   {
/* 332 */     this.kernel.getController().shutdown();
/*     */   }
/*     */ 
/*     */   protected String getTestName()
/*     */   {
/* 337 */     String testName = this.clazz.getName();
/* 338 */     return testName.replace('.', '/') + ".xml";
/*     */   }
/*     */ 
/*     */   protected URL getTestResource(String testName)
/*     */   {
/* 343 */     return this.clazz.getClassLoader().getResource(testName);
/*     */   }
/*     */ 
/*     */   protected void undeploy()
/*     */   {
/* 351 */     this.log.debug("Undeploying " + this.deployer.getDeploymentNames());
/* 352 */     this.deployer.shutdown();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.test.kernel.junit.MicrocontainerTestDelegate
 * JD-Core Version:    0.6.0
 */