/*     */ package org.jboss.system.server.profileservice.repository;
/*     */ 
/*     */ import java.net.URI;
/*     */ import java.util.Collections;
/*     */ import java.util.Map;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeployment;
/*     */ import org.jboss.managed.api.ManagedDeployment.DeploymentPhase;
/*     */ import org.jboss.profileservice.spi.repository.Capability;
/*     */ import org.jboss.profileservice.spi.repository.Repository;
/*     */ import org.jboss.profileservice.spi.repository.Requirement;
/*     */ import org.jboss.profileservice.spi.repository.Resource;
/*     */ import org.jboss.profileservice.spi.repository.Version;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class VFSDeploymentResource
/*     */   implements Resource
/*     */ {
/*     */   private VFSDeployment deployment;
/*     */   private Repository repository;
/*  48 */   private String[] categories = new String[0];
/*     */   private Capability[] capabilities;
/*     */   private Map<String, Object> props;
/*     */ 
/*     */   public VFSDeploymentResource(VFSDeployment deployment, ManagedDeployment.DeploymentPhase phase, Repository repository)
/*     */   {
/*  55 */     this.deployment = deployment;
/*  56 */     this.repository = repository;
/*  57 */     CapabilityImpl ci = new CapabilityImpl("deployment");
/*  58 */     ci.addProperty("phase", phase);
/*  59 */     this.capabilities = new Capability[] { ci };
/*  60 */     this.props = Collections.singletonMap("deployment", deployment);
/*     */   }
/*     */ 
/*     */   public Capability[] getCapabilities()
/*     */   {
/*  65 */     return this.capabilities;
/*     */   }
/*     */ 
/*     */   public String[] getCategories()
/*     */   {
/*  70 */     return this.categories;
/*     */   }
/*     */ 
/*     */   public String getId()
/*     */   {
/*  75 */     return this.deployment.getName();
/*     */   }
/*     */ 
/*     */   public String getPresentationName()
/*     */   {
/*  80 */     return this.deployment.getSimpleName();
/*     */   }
/*     */ 
/*     */   public Map getProperties()
/*     */   {
/*  85 */     return this.props;
/*     */   }
/*     */ 
/*     */   public Repository getRepository()
/*     */   {
/*  90 */     return this.repository;
/*     */   }
/*     */ 
/*     */   public Requirement[] getRequirements()
/*     */   {
/*  96 */     return null;
/*     */   }
/*     */ 
/*     */   public String getSymbolicName()
/*     */   {
/* 101 */     return this.deployment.getName();
/*     */   }
/*     */ 
/*     */   public URI getURI()
/*     */   {
/* 106 */     URI uri = null;
/*     */     try
/*     */     {
/* 109 */       uri = this.deployment.getRoot().toURI();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 113 */       throw new IllegalStateException(e);
/*     */     }
/* 115 */     return uri;
/*     */   }
/*     */ 
/*     */   public Version getVersion()
/*     */   {
/* 121 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.profileservice.repository.VFSDeploymentResource
 * JD-Core Version:    0.6.0
 */