/*    */ package org.jboss.system.server.profileservice.repository;
/*    */ 
/*    */ import java.io.File;
/*    */ import java.net.URI;
/*    */ import org.jboss.profileservice.spi.AttachmentsSerializer;
/*    */ import org.jboss.profileservice.spi.DeploymentRepository;
/*    */ import org.jboss.profileservice.spi.DeploymentRepositoryFactory;
/*    */ import org.jboss.profileservice.spi.ProfileKey;
/*    */ 
/*    */ public class SerializableDeploymentRepositoryFactory
/*    */   implements DeploymentRepositoryFactory
/*    */ {
/*    */   private File root;
/* 44 */   private URI[] appURIs = new URI[0];
/*    */   private AttachmentsSerializer serializer;
/*    */ 
/*    */   public File getStoreRoot()
/*    */   {
/* 55 */     return this.root;
/*    */   }
/*    */ 
/*    */   public void setStoreRoot(File root)
/*    */   {
/* 64 */     this.root = root;
/*    */   }
/*    */ 
/*    */   public URI[] getApplicationURIs()
/*    */   {
/* 69 */     return this.appURIs;
/*    */   }
/*    */ 
/*    */   public void setApplicationURIs(URI[] appURIs) {
/* 73 */     this.appURIs = appURIs;
/*    */   }
/*    */ 
/*    */   public AttachmentsSerializer getSerializer()
/*    */   {
/* 78 */     return this.serializer;
/*    */   }
/*    */ 
/*    */   public void setSerializer(AttachmentsSerializer serializer)
/*    */   {
/* 83 */     this.serializer = serializer;
/*    */   }
/*    */ 
/*    */   public DeploymentRepository getDeploymentRepository(ProfileKey key)
/*    */   {
/* 88 */     if ((this.appURIs == null) || (this.appURIs.length == 0))
/*    */     {
/* 90 */       File deployDir = new File(this.root, key.getName() + "/deploy");
/* 91 */       this.appURIs = new URI[] { deployDir.toURI() };
/*    */     }
/* 93 */     SerializableDeploymentRepository repo = new SerializableDeploymentRepository(this.root, this.appURIs, key);
/* 94 */     repo.setSerializer(this.serializer);
/* 95 */     return repo;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.profileservice.repository.SerializableDeploymentRepositoryFactory
 * JD-Core Version:    0.6.0
 */