/*     */ package org.jboss.system.server.profileservice.repository;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.net.URI;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashSet;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.zip.ZipInputStream;
/*     */ import org.jboss.deployers.spi.attachments.Attachments;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeployment;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.ManagedDeployment.DeploymentPhase;
/*     */ import org.jboss.profileservice.spi.DeploymentRepository;
/*     */ import org.jboss.profileservice.spi.ModificationInfo;
/*     */ import org.jboss.profileservice.spi.ModificationInfo.ModifyStatus;
/*     */ import org.jboss.profileservice.spi.NoSuchDeploymentException;
/*     */ import org.jboss.profileservice.spi.ProfileKey;
/*     */ import org.jboss.profileservice.spi.repository.MutableRepository;
/*     */ import org.jboss.profileservice.spi.repository.MutableRepository.ModifyStatus;
/*     */ import org.jboss.profileservice.spi.repository.Repository;
/*     */ import org.jboss.profileservice.spi.repository.RepositoryAdmin;
/*     */ import org.jboss.profileservice.spi.repository.Resource;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class RepositoryAdminAdaptor
/*     */   implements DeploymentRepository
/*     */ {
/*  61 */   private static Logger log = Logger.getLogger(RepositoryAdminAdaptor.class);
/*     */   private RepositoryAdmin delegate;
/*     */   private File root;
/*     */   private File bootstrapDir;
/*     */   private File libDir;
/*     */   private File deployersDir;
/*     */   private File[] applicationDirs;
/*     */   private File adminEditsRoot;
/*     */   private ProfileKey key;
/*     */ 
/*     */   public void addDeployment(String vfsPath, VFSDeployment d, ManagedDeployment.DeploymentPhase phase)
/*     */     throws Exception
/*     */   {
/*  83 */     MutableRepository mrepo = getRepository(d.getRoot().toURI());
/*  84 */     VFSDeploymentResource dres = new VFSDeploymentResource(d, phase, mrepo);
/*  85 */     mrepo.addResource(dres);
/*     */   }
/*     */ 
/*     */   public void addDeploymentContent(String name, ZipInputStream contentIS, ManagedDeployment.DeploymentPhase phase)
/*     */     throws IOException
/*     */   {
/*  92 */     throw new IOException("Not yet implemented");
/*     */   }
/*     */ 
/*     */   public void addManagedObject(String vfsPath, Attachments edits) throws Exception
/*     */   {
/*  97 */     MutableRepository repo = getRepository(this.adminEditsRoot.toURI());
/*  98 */     AttachmentsResource attachments = new AttachmentsResource(vfsPath, edits, repo);
/*  99 */     repo.addResource(attachments);
/*     */   }
/*     */ 
/*     */   public void create() throws Exception
/*     */   {
/* 104 */     File profileRoot = new File(this.root, this.key.getName());
/* 105 */     if (profileRoot.exists() == true)
/* 106 */       throw new IOException("Profile root already exists: " + profileRoot);
/* 107 */     if (!profileRoot.mkdirs()) {
/* 108 */       throw new IOException("Failed to create profile root: " + profileRoot);
/*     */     }
/* 110 */     this.bootstrapDir = new File(profileRoot, "bootstrap");
/* 111 */     if (!this.bootstrapDir.mkdirs())
/* 112 */       throw new IOException("Failed to create profile bootstrap dir: " + this.bootstrapDir);
/* 113 */     this.delegate.addRepository(this.bootstrapDir.toURI());
/*     */ 
/* 116 */     this.deployersDir = new File(profileRoot, "deployers");
/* 117 */     if (!this.deployersDir.mkdirs())
/* 118 */       throw new IOException("Failed to create profile deployers dir: " + this.deployersDir);
/* 119 */     this.delegate.addRepository(this.deployersDir.toURI());
/*     */ 
/* 122 */     for (File applicationDir : this.applicationDirs)
/*     */     {
/* 124 */       if (!applicationDir.mkdirs())
/* 125 */         throw new IOException("Failed to create profile deploy dir: " + applicationDir);
/* 126 */       this.delegate.addRepository(applicationDir.toURI());
/*     */     }
/*     */ 
/* 130 */     this.libDir = new File(profileRoot, "lib");
/* 131 */     if (!this.libDir.mkdirs())
/* 132 */       throw new IOException("Failed to create profile lib dir: " + this.libDir);
/* 133 */     this.delegate.addRepository(this.libDir.toURI());
/*     */ 
/* 135 */     this.adminEditsRoot = new File(profileRoot, "profile/edits");
/* 136 */     if (!this.adminEditsRoot.mkdirs())
/* 137 */       throw new IOException("Failed to create profile adminEdits dir: " + this.adminEditsRoot);
/* 138 */     this.delegate.addRepository(this.adminEditsRoot.toURI());
/*     */   }
/*     */ 
/*     */   public VFSDeployment getDeployment(String name, ManagedDeployment.DeploymentPhase phase)
/*     */     throws Exception, NoSuchDeploymentException
/*     */   {
/* 144 */     VFSDeployment ctx = null;
/* 145 */     if (phase == null)
/*     */     {
/*     */       try
/*     */       {
/* 150 */         ctx = getBootstrap(name);
/*     */       }
/*     */       catch (NoSuchDeploymentException ignore)
/*     */       {
/*     */       }
/*     */       try
/*     */       {
/* 157 */         if (ctx == null)
/* 158 */           ctx = getDeployer(name);
/*     */       }
/*     */       catch (NoSuchDeploymentException ignore)
/*     */       {
/*     */       }
/*     */       try
/*     */       {
/* 165 */         if (ctx == null)
/* 166 */           ctx = getApplication(name);
/*     */       }
/*     */       catch (NoSuchDeploymentException ignore)
/*     */       {
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 174 */       switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */       {
/*     */       case 1:
/* 177 */         ctx = getBootstrap(name);
/* 178 */         break;
/*     */       case 2:
/* 180 */         ctx = getDeployer(name);
/* 181 */         break;
/*     */       case 3:
/* 183 */         ctx = getApplication(name);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 188 */     if (ctx == null)
/* 189 */       throw new NoSuchDeploymentException("name=" + name + ", phase=" + phase);
/* 190 */     return ctx;
/*     */   }
/*     */ 
/*     */   public Set<String> getDeploymentNames()
/*     */   {
/* 199 */     HashSet names = new HashSet();
/* 200 */     Repository[] repositories = this.delegate.listRepositories();
/* 201 */     for (Repository repo : repositories)
/*     */     {
/* 203 */       Resource[] resources = repo.getResources();
/* 204 */       for (Resource res : resources)
/*     */       {
/* 206 */         if (!(res instanceof VFSDeploymentResource))
/*     */           continue;
/* 208 */         VFSDeploymentResource vfsres = (VFSDeploymentResource)res;
/* 209 */         names.add(vfsres.getSymbolicName());
/*     */       }
/*     */     }
/*     */ 
/* 213 */     return names;
/*     */   }
/*     */ 
/*     */   public Set<String> getDeploymentNames(ManagedDeployment.DeploymentPhase phase)
/*     */   {
/* 222 */     HashSet names = new HashSet();
/* 223 */     URI uri = getDeploymentURI(phase);
/*     */     try
/*     */     {
/* 226 */       Repository repo = this.delegate.getRepository(uri);
/* 227 */       Resource[] resources = repo.getResources();
/* 228 */       for (Resource res : resources)
/*     */       {
/* 230 */         if (!(res instanceof VFSDeploymentResource))
/*     */           continue;
/* 232 */         VFSDeploymentResource vfsres = (VFSDeploymentResource)res;
/* 233 */         names.add(vfsres.getSymbolicName());
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 239 */       throw new IllegalStateException(e);
/*     */     }
/* 241 */     return names;
/*     */   }
/*     */ 
/*     */   public Set<String> getDeploymentNamesForType(String type)
/*     */   {
/* 250 */     return null;
/*     */   }
/*     */ 
/*     */   public Collection<VFSDeployment> getDeployments()
/*     */     throws Exception
/*     */   {
/* 259 */     HashSet deployments = new HashSet();
/* 260 */     Repository[] repositories = this.delegate.listRepositories();
/* 261 */     for (Repository repo : repositories)
/*     */     {
/* 263 */       Resource[] resources = repo.getResources();
/* 264 */       for (Resource res : resources)
/*     */       {
/* 266 */         if (!(res instanceof VFSDeploymentResource))
/*     */           continue;
/* 268 */         VFSDeploymentResource vfsres = (VFSDeploymentResource)res;
/* 269 */         VFSDeployment deployment = (VFSDeployment)vfsres.getProperties().get("deployment");
/* 270 */         if (deployment != null) {
/* 271 */           deployments.add(deployment);
/*     */         }
/*     */       }
/*     */     }
/* 275 */     return deployments;
/*     */   }
/*     */ 
/*     */   public Collection<VFSDeployment> getDeployments(ManagedDeployment.DeploymentPhase phase)
/*     */     throws Exception
/*     */   {
/* 285 */     URI uri = getDeploymentURI(phase);
/* 286 */     Repository repo = this.delegate.getRepository(uri);
/* 287 */     Resource[] resources = repo.getResources();
/* 288 */     HashSet deployments = new HashSet();
/* 289 */     for (Resource res : resources)
/*     */     {
/* 291 */       if (!(res instanceof VFSDeploymentResource))
/*     */         continue;
/* 293 */       VFSDeploymentResource vfsres = (VFSDeploymentResource)res;
/* 294 */       VFSDeployment deployment = (VFSDeployment)vfsres.getProperties().get("deployment");
/* 295 */       if (deployment != null) {
/* 296 */         deployments.add(deployment);
/*     */       }
/*     */     }
/* 299 */     return deployments;
/*     */   }
/*     */ 
/*     */   public URI getDeploymentURI(ManagedDeployment.DeploymentPhase phase)
/*     */   {
/* 304 */     URI uri = null;
/* 305 */     switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */     {
/*     */     case 1:
/* 308 */       uri = getBootstrapURI();
/* 309 */       break;
/*     */     case 2:
/* 311 */       uri = getDeployersURI();
/* 312 */       break;
/*     */     case 3:
/* 314 */       uri = getApplicationURI();
/*     */     }
/*     */ 
/* 317 */     return uri;
/*     */   }
/*     */ 
/*     */   public Collection<ModificationInfo> getModifiedDeployments() throws Exception
/*     */   {
/* 322 */     ArrayList modified = new ArrayList();
/* 323 */     URI appURI = getApplicationURI();
/* 324 */     MutableRepository repo = getRepository(appURI);
/* 325 */     Collection resources = repo.getModifiedResources();
/* 326 */     boolean trace = log.isTraceEnabled();
/* 327 */     if (trace)
/* 328 */       log.trace("Checking applications for modifications");
/* 329 */     if (resources != null)
/*     */     {
/* 331 */       for (Resource res : resources)
/*     */       {
/* 333 */         VFSDeployment ctx = (VFSDeployment)res.getProperties().get("deployment");
/* 334 */         if (ctx == null)
/*     */           continue;
/* 336 */         MutableRepository.ModifyStatus status = (MutableRepository.ModifyStatus)res.getProperties().get("modifyStatus");
/* 337 */         Long lastModified = (Long)res.getProperties().get("lastModified");
/* 338 */         VirtualFile root = ctx.getRoot();
/* 339 */         String name = root.getPathName();
/*     */ 
/* 341 */         if (status == MutableRepository.ModifyStatus.REMOVED)
/*     */         {
/* 343 */           ModificationInfo info = new ModificationInfo(ctx, lastModified.longValue(), ModificationInfo.ModifyStatus.REMOVED);
/* 344 */           modified.add(info);
/* 345 */           if (trace) {
/* 346 */             log.trace(name + " was removed");
/*     */           }
/*     */         }
/* 349 */         else if (status == MutableRepository.ModifyStatus.MODIFIED)
/*     */         {
/* 351 */           if (trace)
/* 352 */             log.trace(name + " was modified: " + lastModified);
/* 353 */           ModificationInfo info = new ModificationInfo(ctx, lastModified.longValue(), ModificationInfo.ModifyStatus.MODIFIED);
/* 354 */           modified.add(info);
/*     */         }
/* 357 */         else if (status == MutableRepository.ModifyStatus.ADDED)
/*     */         {
/* 359 */           if (trace)
/* 360 */             log.trace(name + " was added: " + lastModified);
/* 361 */           ModificationInfo info = new ModificationInfo(ctx, lastModified.longValue(), ModificationInfo.ModifyStatus.ADDED);
/* 362 */           modified.add(info);
/*     */         }
/*     */       }
/*     */     }
/* 366 */     return modified;
/*     */   }
/*     */ 
/*     */   public void load() throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void remove() throws Exception
/*     */   {
/* 375 */     Repository[] repositories = this.delegate.listRepositories();
/* 376 */     for (Repository repo : repositories)
/*     */     {
/* 378 */       this.delegate.removeRepository(repo.getURI());
/*     */     }
/*     */   }
/*     */ 
/*     */   public VFSDeployment removeDeployment(String name, ManagedDeployment.DeploymentPhase phase)
/*     */     throws Exception
/*     */   {
/* 385 */     URI uri = null;
/* 386 */     switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */     {
/*     */     case 1:
/* 389 */       uri = getBootstrapURI();
/* 390 */       break;
/*     */     case 2:
/* 392 */       uri = getDeployersURI();
/* 393 */       break;
/*     */     case 3:
/* 395 */       uri = getApplicationURI();
/*     */     }
/*     */ 
/* 398 */     VFSDeployment ctx = removeDeployment(name, uri);
/* 399 */     return ctx;
/*     */   }
/*     */ 
/*     */   public void setDeploymentURI(URI uri, ManagedDeployment.DeploymentPhase phase)
/*     */   {
/* 404 */     switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */     {
/*     */     case 1:
/* 407 */       setBootstrapURI(uri);
/* 408 */       break;
/*     */     case 2:
/* 410 */       setDeployersURI(uri);
/* 411 */       break;
/*     */     case 3:
/* 413 */       setApplicationURIs(new URI[] { uri });
/*     */     }
/*     */   }
/*     */ 
/*     */   public void updateDeployment(String vfsPath, VFSDeployment d, ManagedDeployment.DeploymentPhase phase)
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected MutableRepository getRepository(URI uri)
/*     */     throws Exception
/*     */   {
/* 429 */     Repository repo = this.delegate.getRepository(uri);
/* 430 */     if (!(repo instanceof MutableRepository))
/* 431 */       throw new IllegalStateException("Repository does not support MutableRepository");
/* 432 */     MutableRepository mrepo = (MutableRepository)repo;
/* 433 */     return mrepo;
/*     */   }
/*     */ 
/*     */   protected VFSDeployment getBootstrap(String vfsPath)
/*     */     throws Exception
/*     */   {
/* 439 */     Resource res = this.delegate.getResource(vfsPath);
/* 440 */     if ((res == null) || (!(res instanceof VFSDeploymentResource)))
/* 441 */       throw new NoSuchDeploymentException(vfsPath);
/* 442 */     VFSDeploymentResource vfsres = (VFSDeploymentResource)res;
/* 443 */     VFSDeployment deployment = (VFSDeployment)vfsres.getProperties().get("deployment");
/* 444 */     return deployment;
/*     */   }
/*     */ 
/*     */   protected VFSDeployment getDeployer(String vfsPath)
/*     */     throws Exception
/*     */   {
/* 450 */     Resource res = this.delegate.getResource(vfsPath);
/* 451 */     if ((res == null) || (!(res instanceof VFSDeploymentResource)))
/* 452 */       throw new NoSuchDeploymentException(vfsPath);
/* 453 */     VFSDeploymentResource vfsres = (VFSDeploymentResource)res;
/* 454 */     VFSDeployment deployment = (VFSDeployment)vfsres.getProperties().get("deployment");
/* 455 */     return deployment;
/*     */   }
/*     */ 
/*     */   protected VFSDeployment getApplication(String vfsPath)
/*     */     throws Exception
/*     */   {
/* 461 */     Resource res = this.delegate.getResource(vfsPath);
/* 462 */     if ((res == null) || (!(res instanceof VFSDeploymentResource)))
/* 463 */       throw new NoSuchDeploymentException(vfsPath);
/* 464 */     VFSDeploymentResource vfsres = (VFSDeploymentResource)res;
/* 465 */     VFSDeployment deployment = (VFSDeployment)vfsres.getProperties().get("deployment");
/* 466 */     return deployment;
/*     */   }
/*     */ 
/*     */   protected URI getBootstrapURI()
/*     */   {
/* 471 */     return this.bootstrapDir.toURI();
/*     */   }
/*     */ 
/*     */   protected URI getDeployersURI() {
/* 475 */     return this.deployersDir.toURI();
/*     */   }
/*     */ 
/*     */   protected URI getApplicationURI() {
/* 479 */     File applicationDir = this.applicationDirs[0];
/* 480 */     return applicationDir.toURI();
/*     */   }
/*     */ 
/*     */   protected void setBootstrapURI(URI uri)
/*     */   {
/* 485 */     this.bootstrapDir = new File(uri);
/*     */   }
/*     */ 
/*     */   protected void setDeployersURI(URI uri) {
/* 489 */     this.deployersDir = new File(uri);
/*     */   }
/*     */ 
/*     */   public void setApplicationURIs(URI[] uris) {
/* 493 */     this.applicationDirs = new File[uris.length];
/* 494 */     for (int n = 0; n < uris.length; n++)
/*     */     {
/* 496 */       URI uri = uris[n];
/* 497 */       this.applicationDirs[n] = new File(uri);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected VFSDeployment removeDeployment(String name, URI uri) throws Exception
/*     */   {
/* 503 */     MutableRepository mrepo = getRepository(uri);
/* 504 */     Resource res = mrepo.removeResource(name);
/* 505 */     VFSDeploymentResource vfsres = (VFSDeploymentResource)res;
/* 506 */     VFSDeployment deployment = (VFSDeployment)vfsres.getProperties().get("deployment");
/* 507 */     return deployment;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.profileservice.repository.RepositoryAdminAdaptor
 * JD-Core Version:    0.6.0
 */