/*     */ package org.jboss.system.server.profileservice.repository;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.Collection;
/*     */ import org.jboss.deployers.spi.management.ManagementView;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.profileservice.spi.DeploymentRepository;
/*     */ import org.jboss.profileservice.spi.NoSuchProfileException;
/*     */ import org.jboss.profileservice.spi.Profile;
/*     */ import org.jboss.profileservice.spi.ProfileKey;
/*     */ import org.jboss.profileservice.spi.ProfileRepository;
/*     */ import org.jboss.profileservice.spi.ProfileService;
/*     */ import org.jboss.system.server.profile.repository.ProfileImpl;
/*     */ 
/*     */ public class ProfileServiceImpl
/*     */   implements ProfileService
/*     */ {
/*  48 */   private static final Logger log = Logger.getLogger(ProfileServiceImpl.class);
/*     */   private String name;
/*     */   private ProfileRepository profileRepository;
/*     */   private DeploymentRepository deploymentRepository;
/*     */   private Profile profile;
/*     */   private ManagementView mgtView;
/*     */   private String version;
/*     */ 
/*     */   public ProfileServiceImpl(String name)
/*     */     throws IOException
/*     */   {
/*  64 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  70 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name) {
/*  74 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getVersion()
/*     */   {
/*  79 */     return this.version;
/*     */   }
/*     */ 
/*     */   public void setVersion(String version)
/*     */   {
/*  84 */     this.version = version;
/*     */   }
/*     */ 
/*     */   public ProfileRepository getProfileRepository()
/*     */   {
/*  89 */     return this.profileRepository;
/*     */   }
/*     */ 
/*     */   public void setProfileRepository(ProfileRepository profileRepository)
/*     */   {
/*  94 */     this.profileRepository = profileRepository;
/*     */   }
/*     */ 
/*     */   public DeploymentRepository getDeploymentRepository()
/*     */   {
/*  99 */     return this.deploymentRepository;
/*     */   }
/*     */ 
/*     */   public void setDeploymentRepository(DeploymentRepository repository)
/*     */   {
/* 104 */     this.deploymentRepository = repository;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 110 */     if (this.profileRepository == null) {
/* 111 */       throw new IllegalStateException("No profileRepository specified");
/*     */     }
/* 113 */     ProfileKey key = new ProfileKey(this.name);
/* 114 */     if (this.deploymentRepository == null)
/*     */     {
/* 116 */       this.deploymentRepository = this.profileRepository.getProfileDeploymentRepository(key);
/*     */     }
/* 118 */     log.info("Loading profile: " + this.name + " from: " + this.deploymentRepository);
/* 119 */     this.profile = new ProfileImpl(this.deploymentRepository, key);
/*     */   }
/*     */ 
/*     */   public String[] getDomains()
/*     */   {
/* 128 */     String[] domains = { "default" };
/* 129 */     return domains;
/*     */   }
/*     */ 
/*     */   public Collection<ProfileKey> getProfileKeys()
/*     */   {
/* 138 */     Collection keys = this.profileRepository.getProfileKeys();
/* 139 */     return keys;
/*     */   }
/*     */ 
/*     */   public Profile getProfile(ProfileKey key)
/*     */     throws NoSuchProfileException
/*     */   {
/* 148 */     return this.profile;
/*     */   }
/*     */ 
/*     */   public Profile getActiveProfile() throws NoSuchProfileException
/*     */   {
/* 153 */     return this.profile;
/*     */   }
/*     */ 
/*     */   public String[] getProfileDeploymentNames(ProfileKey key)
/*     */     throws NoSuchProfileException
/*     */   {
/* 159 */     String[] names = { "default" };
/* 160 */     return names;
/*     */   }
/*     */ 
/*     */   public ManagementView getViewManager()
/*     */   {
/* 165 */     return this.mgtView;
/*     */   }
/*     */ 
/*     */   public void setViewManager(ManagementView mgtView) {
/* 169 */     this.mgtView = mgtView;
/*     */   }
/*     */ 
/*     */   public Profile newProfile(ProfileKey key)
/*     */     throws Exception
/*     */   {
/* 175 */     DeploymentRepository repo = this.profileRepository.createProfileDeploymentRepository(key);
/* 176 */     return new ProfileImpl(repo, key);
/*     */   }
/*     */ 
/*     */   public void removeProfile(ProfileKey key)
/*     */     throws Exception, NoSuchProfileException
/*     */   {
/* 182 */     this.profileRepository.removeProfileDeploymentRepository(key);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.profileservice.repository.ProfileServiceImpl
 * JD-Core Version:    0.6.0
 */