/*     */ package org.jboss.system.server.profileservice.repository;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.URL;
/*     */ import java.util.Arrays;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JavaSerializationAttachmentsSerializer extends AbstractFileAttachmentsSerializer
/*     */ {
/*  45 */   private static final Logger log = Logger.getLogger(JavaSerializationAttachmentsSerializer.class);
/*     */ 
/*     */   protected Map<String, Object> loadAttachments(File attachmentsStore, ClassLoader loader)
/*     */     throws Exception
/*     */   {
/*  51 */     log.debug("loadAttachments, attachmentsStore=" + attachmentsStore);
/*  52 */     Thread.currentThread().setContextClassLoader(loader);
/*  53 */     FileInputStream fis = new FileInputStream(attachmentsStore);
/*  54 */     ObjectInputStream ois = new TCLObjectInputStream(fis, loader);
/*  55 */     Map map = null;
/*     */     try
/*     */     {
/*  58 */       map = (Map)ois.readObject();
/*     */     }
/*     */     catch (ClassNotFoundException igore)
/*     */     {
/*  62 */       URL[] path = getClassLoaderURLs(loader);
/*  63 */       log.debug("ClassNotFoundException: " + e.getMessage() + ", path: " + Arrays.asList(path));
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/*  69 */         ois.close();
/*     */       }
/*     */       catch (Exception igore)
/*     */       {
/*     */       }
/*     */       try
/*     */       {
/*  76 */         fis.close();
/*     */       }
/*     */       catch (Exception igore)
/*     */       {
/*     */       }
/*     */     }
/*  82 */     return map;
/*     */   }
/*     */ 
/*     */   protected void saveAttachments(File attachmentsStore, Map<String, Object> map, ClassLoader loader)
/*     */     throws Exception
/*     */   {
/*  89 */     log.debug("saveAttachments, attachmentsStore=" + attachmentsStore);
/*  90 */     if (log.isTraceEnabled())
/*     */     {
/*  92 */       log.trace("Attachments.size: " + map.size());
/*  93 */       for (String key : map.keySet())
/*     */       {
/*  95 */         log.trace(key + ", " + map.get(key));
/*     */       }
/*     */     }
/*  98 */     FileOutputStream fos = new FileOutputStream(attachmentsStore);
/*  99 */     ObjectOutputStream oos = new ObjectOutputStream(fos);
/*     */     try
/*     */     {
/* 102 */       oos.writeObject(map);
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 108 */         oos.close();
/*     */       }
/*     */       catch (Exception igore)
/*     */       {
/*     */       }
/*     */       try
/*     */       {
/* 115 */         fos.close();
/*     */       }
/*     */       catch (Exception igore)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static URL[] getClassLoaderURLs(ClassLoader cl)
/*     */   {
/* 130 */     URL[] urls = new URL[0];
/*     */     try
/*     */     {
/* 133 */       Class returnType = urls.getClass();
/* 134 */       Class[] parameterTypes = new Class[0];
/* 135 */       Class clClass = cl.getClass();
/* 136 */       Method getURLs = clClass.getMethod("getURLs", parameterTypes);
/* 137 */       if (returnType.isAssignableFrom(getURLs.getReturnType()))
/*     */       {
/* 139 */         Object[] args = new Object[0];
/* 140 */         urls = (URL[])(URL[])getURLs.invoke(cl, args);
/*     */       }
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/* 146 */     if ((urls == null) || (urls.length == 0))
/*     */     {
/*     */       try
/*     */       {
/* 150 */         Class returnType = urls.getClass();
/* 151 */         Class[] parameterTypes = new Class[0];
/* 152 */         Class clClass = cl.getClass();
/* 153 */         Method getURLs = clClass.getMethod("getAllURLs", parameterTypes);
/* 154 */         if (returnType.isAssignableFrom(getURLs.getReturnType()))
/*     */         {
/* 156 */           Object[] args = new Object[0];
/* 157 */           urls = (URL[])(URL[])getURLs.invoke(cl, args);
/*     */         }
/*     */       }
/*     */       catch (Exception ignore)
/*     */       {
/*     */       }
/*     */     }
/* 164 */     if ((urls == null) || (urls.length == 0))
/*     */     {
/*     */       try
/*     */       {
/* 168 */         Class returnType = urls.getClass();
/* 169 */         Class[] parameterTypes = new Class[0];
/* 170 */         Class clClass = cl.getClass();
/* 171 */         Method getURLs = clClass.getMethod("getClasspath", parameterTypes);
/* 172 */         if (returnType.isAssignableFrom(getURLs.getReturnType()))
/*     */         {
/* 174 */           Object[] args = new Object[0];
/* 175 */           urls = (URL[])(URL[])getURLs.invoke(cl, args);
/*     */         }
/*     */       }
/*     */       catch (Exception ignore)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 183 */     return urls;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.profileservice.repository.JavaSerializationAttachmentsSerializer
 * JD-Core Version:    0.6.0
 */