/*     */ package org.jboss.system.server.profileservice.hotdeploy;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.concurrent.Executors;
/*     */ import java.util.concurrent.ScheduledExecutorService;
/*     */ import java.util.concurrent.ScheduledFuture;
/*     */ import java.util.concurrent.ThreadFactory;
/*     */ import java.util.concurrent.TimeUnit;
/*     */ import org.jboss.deployers.client.spi.main.MainDeployer;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeployment;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.ManagedDeployment.DeploymentPhase;
/*     */ import org.jboss.profileservice.spi.ModificationInfo;
/*     */ import org.jboss.profileservice.spi.Profile;
/*     */ import org.jboss.profileservice.spi.ProfileService;
/*     */ 
/*     */ public class HDScanner
/*     */   implements Runnable
/*     */ {
/*  59 */   private static final Logger log = Logger.getLogger(HDScanner.class);
/*     */   private MainDeployer mainDeployer;
/*     */   private KernelController controller;
/*     */   private ProfileService profileService;
/*     */   private ScheduledExecutorService scanExecutor;
/*     */   private ScheduledFuture activeScan;
/*  73 */   private String scanThreadName = "HDScanner";
/*     */ 
/*  76 */   private long scanPeriod = 5000L;
/*     */   private int scanCount;
/*     */ 
/*     */   public void setMainDeployer(MainDeployer deployer)
/*     */   {
/*  91 */     this.mainDeployer = deployer;
/*     */   }
/*     */ 
/*     */   public KernelController getController()
/*     */   {
/*  96 */     return this.controller;
/*     */   }
/*     */ 
/*     */   public void setController(KernelController controller)
/*     */   {
/* 101 */     this.controller = controller;
/*     */   }
/*     */ 
/*     */   public ProfileService getProfileService()
/*     */   {
/* 106 */     return this.profileService;
/*     */   }
/*     */ 
/*     */   public void setProfileService(ProfileService profileService) {
/* 110 */     this.profileService = profileService;
/*     */   }
/*     */ 
/*     */   public ScheduledExecutorService getScanExecutor()
/*     */   {
/* 118 */     return this.scanExecutor;
/*     */   }
/*     */ 
/*     */   public void setScanExecutor(ScheduledExecutorService scanExecutor)
/*     */   {
/* 126 */     this.scanExecutor = scanExecutor;
/*     */   }
/*     */ 
/*     */   public String getScanThreadName()
/*     */   {
/* 131 */     return this.scanThreadName;
/*     */   }
/*     */ 
/*     */   public void setScanThreadName(String scanThreadName)
/*     */   {
/* 136 */     this.scanThreadName = scanThreadName;
/*     */   }
/*     */ 
/*     */   public long getScanPeriod()
/*     */   {
/* 144 */     return this.scanPeriod;
/*     */   }
/*     */ 
/*     */   public void setScanPeriod(long period)
/*     */   {
/* 151 */     this.scanPeriod = period;
/*     */   }
/*     */ 
/*     */   public boolean isScanEnabled()
/*     */   {
/* 161 */     return this.activeScan != null;
/*     */   }
/*     */ 
/*     */   public synchronized int getScanCount()
/*     */   {
/* 166 */     return this.scanCount;
/*     */   }
/*     */ 
/*     */   public synchronized void resetScanCount() {
/* 170 */     this.scanCount = 0;
/*     */   }
/*     */ 
/*     */   public synchronized void setScanEnabled(boolean scanEnabled)
/*     */   {
/* 179 */     if ((scanEnabled == true) && (this.activeScan == null))
/*     */     {
/* 181 */       this.activeScan = this.scanExecutor.scheduleWithFixedDelay(this, 0L, this.scanPeriod, TimeUnit.MILLISECONDS);
/*     */     }
/* 184 */     else if ((!scanEnabled) && (this.activeScan != null))
/*     */     {
/* 186 */       this.activeScan.cancel(true);
/* 187 */       this.activeScan = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 197 */     if (this.scanExecutor == null)
/*     */     {
/* 199 */       this.scanExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory()
/*     */       {
/*     */         public Thread newThread(Runnable r)
/*     */         {
/* 204 */           return new Thread(r, HDScanner.this.getScanThreadName());
/*     */         }
/*     */       });
/*     */     }
/* 209 */     this.activeScan = this.scanExecutor.scheduleWithFixedDelay(this, 0L, this.scanPeriod, TimeUnit.MILLISECONDS);
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*     */     try
/*     */     {
/* 221 */       scan();
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 225 */       log.warn("Scan failed", e);
/*     */     }
/*     */     finally
/*     */     {
/* 229 */       incScanCount();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 235 */     if (this.activeScan != null)
/*     */     {
/* 237 */       this.activeScan.cancel(true);
/* 238 */       this.activeScan = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void scan() throws Exception
/*     */   {
/* 244 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 247 */     if (trace) {
/* 248 */       log.trace("Begin deployment scan");
/*     */     }
/*     */ 
/* 252 */     Profile activeProfile = this.profileService.getActiveProfile();
/* 253 */     if (activeProfile == null)
/*     */     {
/* 255 */       if (trace)
/* 256 */         log.trace("End deployment scan, no activeProfile");
/* 257 */       return;
/*     */     }
/*     */ 
/* 260 */     Collection modified = activeProfile.getModifiedDeployments();
/* 261 */     for (ModificationInfo info : modified)
/*     */     {
/* 263 */       VFSDeployment ctx = info.getDeployment();
/* 264 */       switch (2.$SwitchMap$org$jboss$profileservice$spi$ModificationInfo$ModifyStatus[info.getStatus().ordinal()])
/*     */       {
/*     */       case 1:
/* 267 */         this.mainDeployer.addDeployment(ctx);
/* 268 */         break;
/*     */       case 2:
/* 270 */         this.mainDeployer.addDeployment(ctx);
/* 271 */         break;
/*     */       case 3:
/* 273 */         this.mainDeployer.removeDeployment(ctx.getName());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 281 */       if (modified.size() > 0)
/*     */       {
/* 284 */         ClassLoader oldTCL = Thread.currentThread().getContextClassLoader();
/* 285 */         ClassLoader tcl = getTCL(activeProfile);
/*     */         try
/*     */         {
/* 288 */           if (tcl != null)
/* 289 */             Thread.currentThread().setContextClassLoader(tcl);
/* 290 */           this.mainDeployer.process();
/* 291 */           this.mainDeployer.checkComplete();
/*     */         }
/*     */         finally
/*     */         {
/* 295 */           Thread.currentThread().setContextClassLoader(oldTCL);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 301 */       log.warn("Failed to process changes", e);
/*     */ 
/* 303 */       return;
/*     */     }
/*     */ 
/* 306 */     if (trace)
/* 307 */       log.trace("End deployment scan");
/*     */   }
/*     */ 
/*     */   protected synchronized void incScanCount()
/*     */   {
/* 316 */     this.scanCount += 1;
/* 317 */     notifyAll();
/*     */   }
/*     */ 
/*     */   private ClassLoader getTCL(Profile activeProfile)
/*     */     throws Exception
/*     */   {
/* 328 */     MainDeployerStructure structure = (MainDeployerStructure)this.mainDeployer;
/* 329 */     Collection ctxs = activeProfile.getDeployments(ManagedDeployment.DeploymentPhase.BOOTSTRAP);
/* 330 */     if ((ctxs != null) && (!ctxs.isEmpty()))
/*     */     {
/* 332 */       for (VFSDeployment deployment : ctxs)
/*     */       {
/* 334 */         DeploymentUnit unit = structure.getDeploymentUnit(deployment.getName());
/* 335 */         if (unit != null)
/*     */         {
/*     */           try
/*     */           {
/* 339 */             ClassLoader cl = unit.getClassLoader();
/* 340 */             if (cl != null) {
/* 341 */               return cl;
/*     */             }
/*     */           }
/*     */           catch (Exception ignored)
/*     */           {
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 350 */     log.warn("No bootstrap deployments? profile=" + activeProfile);
/* 351 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.profileservice.hotdeploy.HDScanner
 * JD-Core Version:    0.6.0
 */