/*     */ package org.jboss.system.server.profile.basic;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.net.URI;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeployment;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.ManagedDeployment.DeploymentPhase;
/*     */ import org.jboss.profileservice.spi.ModificationInfo;
/*     */ import org.jboss.profileservice.spi.ModificationInfo.ModifyStatus;
/*     */ import org.jboss.profileservice.spi.NoSuchDeploymentException;
/*     */ import org.jboss.profileservice.spi.Profile;
/*     */ import org.jboss.profileservice.spi.ProfileKey;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.virtual.VFS;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class ProfileImpl extends JBossObject
/*     */   implements Profile
/*     */ {
/*  61 */   private VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();
/*     */   private ProfileKey key;
/*     */   private File profileRoot;
/*  66 */   private LinkedHashMap<String, VFSDeployment> bootstraps = new LinkedHashMap();
/*  67 */   private LinkedHashMap<String, VFSDeployment> applications = new LinkedHashMap();
/*  68 */   private LinkedHashMap<String, VFSDeployment> deployers = new LinkedHashMap();
/*     */   private volatile boolean hotdeployEnabled;
/*     */ 
/*     */   public ProfileImpl(String profileRoot, ProfileKey key)
/*     */   {
/*  74 */     this.key = key;
/*  75 */     this.profileRoot = new File(profileRoot);
/*  76 */     this.log.info("Using profile root:" + this.profileRoot.getAbsolutePath());
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  81 */     return this.key.getName();
/*     */   }
/*     */ 
/*     */   public ProfileKey getKey()
/*     */   {
/*  86 */     return this.key;
/*     */   }
/*     */ 
/*     */   public String getVersion()
/*     */   {
/*  91 */     return null;
/*     */   }
/*     */ 
/*     */   public Set<String> getDeploymentNames()
/*     */   {
/* 100 */     HashSet names = new HashSet();
/* 101 */     names.addAll(this.bootstraps.keySet());
/* 102 */     names.addAll(this.deployers.keySet());
/* 103 */     names.addAll(this.applications.keySet());
/* 104 */     return names;
/*     */   }
/*     */ 
/*     */   public VirtualFile getRootFile(ManagedDeployment.DeploymentPhase phase)
/*     */     throws Exception
/*     */   {
/* 110 */     VirtualFile root = VFS.getRoot(this.profileRoot.toURI());
/* 111 */     switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */     {
/*     */     case 1:
/* 114 */       root = root.findChild("conf");
/* 115 */       break;
/*     */     case 2:
/* 117 */       root = root.findChild("deployers");
/* 118 */       break;
/*     */     case 3:
/* 120 */       root = root.findChild("deploy");
/*     */     }
/*     */ 
/* 123 */     return root;
/*     */   }
/*     */ 
/*     */   public void addDeployment(VFSDeployment d, ManagedDeployment.DeploymentPhase phase)
/*     */     throws Exception
/*     */   {
/* 129 */     switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */     {
/*     */     case 1:
/* 132 */       addBootstrap(d);
/* 133 */       break;
/*     */     case 2:
/* 135 */       addDeployer(d);
/* 136 */       break;
/*     */     case 3:
/* 138 */       addApplication(d);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void updateDeployment(VFSDeployment d, ManagedDeployment.DeploymentPhase phase)
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   private VFSDeployment findDeployment(String name, ManagedDeployment.DeploymentPhase phase)
/*     */   {
/* 157 */     VFSDeployment d = null;
/* 158 */     if (phase == null)
/*     */     {
/* 161 */       d = getBootstrap(name);
/* 162 */       if (d == null)
/* 163 */         d = getDeployer(name);
/* 164 */       if (d == null)
/* 165 */         d = getApplication(name);
/*     */     }
/*     */     else
/*     */     {
/* 169 */       switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */       {
/*     */       case 1:
/* 172 */         d = getBootstrap(name);
/* 173 */         break;
/*     */       case 2:
/* 175 */         d = getDeployer(name);
/* 176 */         break;
/*     */       case 3:
/* 178 */         d = getApplication(name);
/*     */       }
/*     */     }
/*     */ 
/* 182 */     return d;
/*     */   }
/*     */ 
/*     */   public VFSDeployment getDeployment(String name, ManagedDeployment.DeploymentPhase phase)
/*     */     throws NoSuchDeploymentException
/*     */   {
/* 196 */     VFSDeployment d = findDeployment(name, phase);
/*     */ 
/* 198 */     if (d == null)
/* 199 */       throw new NoSuchDeploymentException("name=" + name + ", phase=" + phase);
/* 200 */     return d;
/*     */   }
/*     */ 
/*     */   public boolean hasDeployment(String name, ManagedDeployment.DeploymentPhase phase)
/*     */   {
/* 212 */     return findDeployment(name, phase) != null;
/*     */   }
/*     */ 
/*     */   public Set<String> getDeploymentNames(ManagedDeployment.DeploymentPhase phase)
/*     */   {
/* 217 */     HashSet names = new HashSet();
/* 218 */     switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */     {
/*     */     case 1:
/* 221 */       names.addAll(this.bootstraps.keySet());
/* 222 */       break;
/*     */     case 2:
/* 224 */       names.addAll(this.deployers.keySet());
/* 225 */       break;
/*     */     case 3:
/* 227 */       names.addAll(this.applications.keySet());
/*     */     }
/*     */ 
/* 230 */     return names;
/*     */   }
/*     */ 
/*     */   public Set<String> getDeploymentNamesForType(String type)
/*     */   {
/* 235 */     throw new UnsupportedOperationException("getDeploymentNamesForType");
/*     */   }
/*     */ 
/*     */   public Collection<VFSDeployment> getDeployments()
/*     */   {
/* 259 */     HashSet deployments = new HashSet();
/* 260 */     deployments.addAll(this.bootstraps.values());
/* 261 */     deployments.addAll(this.deployers.values());
/* 262 */     deployments.addAll(this.applications.values());
/* 263 */     return Collections.unmodifiableCollection(deployments);
/*     */   }
/*     */ 
/*     */   public Collection<ModificationInfo> getModifiedDeployments()
/*     */     throws Exception
/*     */   {
/* 276 */     if (!this.hotdeployEnabled) {
/* 277 */       return Collections.emptyList();
/*     */     }
/* 279 */     ArrayList modified = new ArrayList();
/* 280 */     Collection apps = this.applications.values();
/* 281 */     boolean trace = this.log.isTraceEnabled();
/* 282 */     if (trace)
/* 283 */       this.log.trace("Checking applications for modifications");
/* 284 */     VirtualFile applicationDir = null;
/* 285 */     if (apps != null)
/*     */     {
/* 287 */       Iterator iter = apps.iterator();
/* 288 */       while (iter.hasNext())
/*     */       {
/* 290 */         VFSDeployment d = (VFSDeployment)iter.next();
/* 291 */         VirtualFile root = d.getRoot();
/*     */ 
/* 293 */         VirtualFile parent = root.getParent();
/* 294 */         if ((applicationDir == null) || (parent.getPathName().compareTo(applicationDir.getPathName()) < 0))
/* 295 */           applicationDir = parent;
/* 296 */         Long rootLastModified = Long.valueOf(root.getLastModified());
/* 297 */         String name = root.getPathName();
/*     */ 
/* 299 */         if (!root.exists())
/*     */         {
/* 301 */           ModificationInfo info = new ModificationInfo(d, rootLastModified.longValue(), ModificationInfo.ModifyStatus.REMOVED);
/* 302 */           modified.add(info);
/* 303 */           iter.remove();
/* 304 */           if (trace) {
/* 305 */             this.log.trace(name + " was removed");
/*     */           }
/*     */         }
/* 308 */         else if (root.hasBeenModified())
/*     */         {
/* 310 */           if (trace) {
/* 311 */             this.log.trace(name + " was modified: " + rootLastModified);
/*     */           }
/* 313 */           VFSDeployment deployment2 = this.deploymentFactory.createVFSDeployment(root);
/* 314 */           ModificationInfo info = new ModificationInfo(deployment2, rootLastModified.longValue(), ModificationInfo.ModifyStatus.MODIFIED);
/* 315 */           modified.add(info);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 321 */       if (applicationDir == null) {
/* 322 */         applicationDir = getRootFile(ManagedDeployment.DeploymentPhase.APPLICATION);
/*     */       }
/* 324 */       ArrayList added = new ArrayList();
/* 325 */       addDeployments(added, applicationDir);
/* 326 */       for (VirtualFile vf : added)
/*     */       {
/* 328 */         VFSDeployment d = this.deploymentFactory.createVFSDeployment(vf);
/* 329 */         ModificationInfo info = new ModificationInfo(d, vf.getLastModified(), ModificationInfo.ModifyStatus.ADDED);
/* 330 */         modified.add(info);
/* 331 */         this.applications.put(d.getName(), d);
/*     */       }
/*     */     }
/* 334 */     return modified;
/*     */   }
/*     */ 
/*     */   public void enableModifiedDeploymentChecks(boolean flag)
/*     */   {
/* 342 */     this.hotdeployEnabled = flag;
/*     */   }
/*     */ 
/*     */   public Collection<VFSDeployment> getDeployments(ManagedDeployment.DeploymentPhase phase)
/*     */   {
/* 347 */     Collection deployments = null;
/* 348 */     switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */     {
/*     */     case 1:
/* 351 */       deployments = getBootstraps();
/* 352 */       break;
/*     */     case 2:
/* 354 */       deployments = getDeployers();
/* 355 */       break;
/*     */     case 3:
/* 357 */       deployments = getApplications();
/*     */     }
/*     */ 
/* 360 */     return deployments;
/*     */   }
/*     */ 
/*     */   public VFSDeployment removeDeployment(String name, ManagedDeployment.DeploymentPhase phase)
/*     */     throws Exception
/*     */   {
/* 366 */     VFSDeployment d = null;
/* 367 */     switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */     {
/*     */     case 1:
/* 370 */       d = removeBootstrap(name);
/* 371 */       break;
/*     */     case 2:
/* 373 */       d = removeDeployer(name);
/* 374 */       break;
/*     */     case 3:
/* 376 */       d = removeApplication(name);
/*     */     }
/*     */ 
/* 379 */     return d;
/*     */   }
/*     */ 
/*     */   public Map<String, Object> getConfig()
/*     */   {
/* 385 */     return null;
/*     */   }
/*     */ 
/*     */   protected void addBootstrap(VFSDeployment d)
/*     */   {
/* 390 */     this.bootstraps.put(d.getName(), d);
/*     */   }
/*     */ 
/*     */   protected VFSDeployment removeBootstrap(String name)
/*     */   {
/* 395 */     return (VFSDeployment)this.bootstraps.remove(name);
/*     */   }
/*     */ 
/*     */   protected VFSDeployment getBootstrap(String name)
/*     */   {
/* 400 */     VFSDeployment deployment = (VFSDeployment)this.bootstraps.get(name);
/* 401 */     return deployment;
/*     */   }
/*     */ 
/*     */   protected Collection<VFSDeployment> getBootstraps()
/*     */   {
/* 406 */     return Collections.unmodifiableCollection(this.bootstraps.values());
/*     */   }
/*     */ 
/*     */   protected void addDeployer(VFSDeployment d)
/*     */   {
/* 411 */     this.deployers.put(d.getName(), d);
/*     */   }
/*     */ 
/*     */   protected VFSDeployment removeDeployer(String name)
/*     */   {
/* 416 */     return (VFSDeployment)this.deployers.remove(name);
/*     */   }
/*     */ 
/*     */   protected VFSDeployment getDeployer(String name)
/*     */   {
/* 421 */     VFSDeployment deployment = (VFSDeployment)this.deployers.get(name);
/* 422 */     return deployment;
/*     */   }
/*     */ 
/*     */   protected Collection<VFSDeployment> getDeployers()
/*     */   {
/* 427 */     return Collections.unmodifiableCollection(this.deployers.values());
/*     */   }
/*     */ 
/*     */   protected void addApplication(VFSDeployment d)
/*     */   {
/* 432 */     this.applications.put(d.getName(), d);
/*     */   }
/*     */ 
/*     */   protected VFSDeployment removeApplication(String name)
/*     */   {
/* 437 */     return (VFSDeployment)this.applications.remove(name);
/*     */   }
/*     */ 
/*     */   protected VFSDeployment getApplication(String name)
/*     */   {
/* 442 */     VFSDeployment deployment = (VFSDeployment)this.applications.get(name);
/* 443 */     return deployment;
/*     */   }
/*     */ 
/*     */   protected Collection<VFSDeployment> getApplications()
/*     */   {
/* 448 */     return Collections.unmodifiableCollection(this.applications.values());
/*     */   }
/*     */ 
/*     */   private void addDeployments(List<VirtualFile> list, VirtualFile root)
/*     */     throws Exception
/*     */   {
/* 454 */     List components = root.getChildren();
/*     */ 
/* 456 */     for (VirtualFile component : components)
/*     */     {
/* 458 */       String key = component.toURI().toString();
/* 459 */       if (this.applications.containsKey(key) == true) {
/*     */         continue;
/*     */       }
/* 462 */       if (component.isLeaf())
/*     */       {
/* 464 */         list.add(component);
/*     */       }
/* 466 */       else if (component.getName().indexOf('.') == -1)
/*     */       {
/* 469 */         addDeployments(list, component);
/*     */       }
/*     */       else
/*     */       {
/* 473 */         list.add(component);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.profile.basic.ProfileImpl
 * JD-Core Version:    0.6.0
 */