/*     */ package org.jboss.system.server.jmx;
/*     */ 
/*     */ import java.io.ObjectInputStream;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.InstanceAlreadyExistsException;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.IntrospectionException;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.ListenerNotFoundException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanRegistrationException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerDelegate;
/*     */ import javax.management.NotCompliantMBeanException;
/*     */ import javax.management.NotificationFilter;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectInstance;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.OperationsException;
/*     */ import javax.management.QueryExp;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.management.loading.ClassLoaderRepository;
/*     */ 
/*     */ public class LazyMBeanServer
/*     */   implements MBeanServer
/*     */ {
/*     */   private static MBeanServer registeredServer;
/*     */   private static MBeanServer theServer;
/*     */   private static MBeanServer platformServer;
/*     */   private static String defaultDomain;
/*     */   private static MBeanServerDelegate theDelegate;
/*  76 */   private static Set platformServerDomains = Collections.synchronizedSet(new HashSet());
/*     */ 
/*  80 */   private static Set serverDomains = Collections.synchronizedSet(new HashSet());
/*     */ 
/*     */   public static MBeanServer resetToJBossServer(MBeanServer server)
/*     */     throws Exception
/*     */   {
/*  93 */     MBeanServer coreServer = server;
/*  94 */     if (theDelegate != null)
/*     */     {
/*  96 */       Class[] sig = { String.class, MBeanServer.class, MBeanServerDelegate.class };
/*  97 */       Object[] args = { defaultDomain, null, theDelegate };
/*  98 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*  99 */       Class c = loader.loadClass("org.jboss.mx.server.MBeanServerImpl");
/* 100 */       Constructor ctor = c.getConstructor(sig);
/* 101 */       theServer = (MBeanServer)ctor.newInstance(args);
/* 102 */       coreServer = theServer;
/* 103 */       String[] domains = theServer.getDomains();
/* 104 */       for (int n = 0; n < domains.length; n++)
/*     */       {
/* 106 */         serverDomains.add(domains[n]);
/*     */       }
/*     */     }
/* 109 */     return coreServer;
/*     */   }
/*     */ 
/*     */   public static MBeanServer getRegisteredMBeanServer(MBeanServer server)
/*     */   {
/* 120 */     MBeanServer outerServer = server;
/* 121 */     if (registeredServer != null)
/* 122 */       outerServer = registeredServer;
/* 123 */     return outerServer;
/*     */   }
/*     */ 
/*     */   public static synchronized void reloadDomains()
/*     */   {
/* 133 */     String[] domains = platformServer.getDomains();
/* 134 */     for (int n = 0; n < domains.length; n++)
/*     */     {
/* 136 */       platformServerDomains.add(domains[n]);
/*     */     }
/* 138 */     domains = theServer.getDomains();
/* 139 */     for (int n = 0; n < domains.length; n++)
/*     */     {
/* 141 */       serverDomains.add(domains[n]);
/*     */     }
/*     */   }
/*     */ 
/*     */   LazyMBeanServer(String domain, MBeanServer outer, MBeanServerDelegate delegate)
/*     */   {
/* 147 */     defaultDomain = domain;
/* 148 */     platformServer = outer;
/* 149 */     theServer = outer;
/* 150 */     registeredServer = this;
/* 151 */     theDelegate = delegate;
/*     */ 
/* 153 */     String[] domains = platformServer.getDomains();
/* 154 */     for (int n = 0; n < domains.length; n++)
/*     */     {
/* 156 */       platformServerDomains.add(domains[n]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public ObjectInstance createMBean(String className, ObjectName name)
/*     */     throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException
/*     */   {
/*     */     try
/*     */     {
/* 167 */       return createMBean(className, name, null);
/*     */     }
/*     */     catch (InstanceNotFoundException e) {
/*     */     }
/* 171 */     throw new MBeanException(e);
/*     */   }
/*     */ 
/*     */   public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName)
/*     */     throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException
/*     */   {
/* 181 */     return getServer(name).createMBean(className, name, loaderName);
/*     */   }
/*     */ 
/*     */   public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature)
/*     */     throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException
/*     */   {
/* 190 */     return getServer(name).createMBean(className, name, params, signature);
/*     */   }
/*     */ 
/*     */   public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature)
/*     */     throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException
/*     */   {
/* 200 */     return getServer(name).createMBean(className, name, loaderName, params, signature);
/*     */   }
/*     */ 
/*     */   public ObjectInstance registerMBean(Object object, ObjectName name)
/*     */     throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException
/*     */   {
/* 207 */     return theServer.registerMBean(object, name);
/*     */   }
/*     */ 
/*     */   public void unregisterMBean(ObjectName name)
/*     */     throws InstanceNotFoundException, MBeanRegistrationException
/*     */   {
/* 213 */     theServer.unregisterMBean(name);
/*     */   }
/*     */ 
/*     */   public ObjectInstance getObjectInstance(ObjectName name)
/*     */     throws InstanceNotFoundException
/*     */   {
/* 219 */     ObjectInstance oi = getServer(name).getObjectInstance(name);
/* 220 */     return oi;
/*     */   }
/*     */ 
/*     */   public Set queryMBeans(ObjectName name, QueryExp query)
/*     */   {
/* 226 */     Set beans = platformServer.queryMBeans(name, query);
/* 227 */     Set beans2 = theServer.queryMBeans(name, query);
/* 228 */     beans.addAll(beans2);
/* 229 */     return beans;
/*     */   }
/*     */ 
/*     */   public Set queryNames(ObjectName name, QueryExp query)
/*     */   {
/* 234 */     Set names = platformServer.queryNames(name, query);
/* 235 */     Set names2 = theServer.queryNames(name, query);
/* 236 */     names.addAll(names2);
/* 237 */     return names;
/*     */   }
/*     */ 
/*     */   public boolean isRegistered(ObjectName name)
/*     */   {
/* 242 */     return getServer(name).isRegistered(name);
/*     */   }
/*     */ 
/*     */   public Integer getMBeanCount()
/*     */   {
/* 247 */     return theServer.getMBeanCount();
/*     */   }
/*     */ 
/*     */   public Object getAttribute(ObjectName name, String attribute)
/*     */     throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException
/*     */   {
/* 254 */     return getServer(name).getAttribute(name, attribute);
/*     */   }
/*     */ 
/*     */   public AttributeList getAttributes(ObjectName name, String[] attributes)
/*     */     throws InstanceNotFoundException, ReflectionException
/*     */   {
/* 260 */     return getServer(name).getAttributes(name, attributes);
/*     */   }
/*     */ 
/*     */   public void setAttribute(ObjectName name, Attribute attribute)
/*     */     throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*     */   {
/* 268 */     getServer(name).setAttribute(name, attribute);
/*     */   }
/*     */ 
/*     */   public AttributeList setAttributes(ObjectName name, AttributeList attributes)
/*     */     throws InstanceNotFoundException, ReflectionException
/*     */   {
/* 275 */     return getServer(name).setAttributes(name, attributes);
/*     */   }
/*     */ 
/*     */   public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature)
/*     */     throws InstanceNotFoundException, MBeanException, ReflectionException
/*     */   {
/* 283 */     Object value = getServer(name).invoke(name, operationName, params, signature);
/* 284 */     return value;
/*     */   }
/*     */ 
/*     */   public String getDefaultDomain()
/*     */   {
/* 289 */     return theServer.getDefaultDomain();
/*     */   }
/*     */ 
/*     */   public String[] getDomains()
/*     */   {
/* 294 */     return theServer.getDomains();
/*     */   }
/*     */ 
/*     */   public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback)
/*     */     throws InstanceNotFoundException
/*     */   {
/* 303 */     getServer(name).addNotificationListener(name, listener, filter, handback);
/*     */   }
/*     */ 
/*     */   public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback)
/*     */     throws InstanceNotFoundException
/*     */   {
/* 312 */     getServer(name).addNotificationListener(name, listener, filter, handback);
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(ObjectName name, ObjectName listener)
/*     */     throws InstanceNotFoundException, ListenerNotFoundException
/*     */   {
/* 319 */     getServer(name).removeNotificationListener(name, listener);
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback)
/*     */     throws InstanceNotFoundException, ListenerNotFoundException
/*     */   {
/* 328 */     getServer(name).removeNotificationListener(name, listener, filter, handback);
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(ObjectName name, NotificationListener listener)
/*     */     throws InstanceNotFoundException, ListenerNotFoundException
/*     */   {
/* 335 */     getServer(name).removeNotificationListener(name, listener);
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback)
/*     */     throws InstanceNotFoundException, ListenerNotFoundException
/*     */   {
/* 344 */     getServer(name).removeNotificationListener(name, listener, filter, handback);
/*     */   }
/*     */ 
/*     */   public MBeanInfo getMBeanInfo(ObjectName name)
/*     */     throws InstanceNotFoundException, IntrospectionException, ReflectionException
/*     */   {
/* 361 */     MBeanInfo info = null;
/*     */     try
/*     */     {
/* 364 */       info = getServer(name).getMBeanInfo(name);
/*     */     }
/*     */     catch (InstanceNotFoundException e)
/*     */     {
/* 368 */       reloadDomains();
/* 369 */       info = getServer(name).getMBeanInfo(name);
/*     */     }
/* 371 */     return info;
/*     */   }
/*     */ 
/*     */   public boolean isInstanceOf(ObjectName name, String className)
/*     */     throws InstanceNotFoundException
/*     */   {
/* 377 */     boolean isInstanceOf = false;
/*     */     try
/*     */     {
/* 380 */       isInstanceOf = getServer(name).isInstanceOf(name, className);
/*     */     }
/*     */     catch (InstanceNotFoundException e)
/*     */     {
/* 384 */       reloadDomains();
/* 385 */       isInstanceOf = getServer(name).isInstanceOf(name, className);
/*     */     }
/* 387 */     return isInstanceOf;
/*     */   }
/*     */ 
/*     */   public Object instantiate(String className)
/*     */     throws ReflectionException, MBeanException
/*     */   {
/* 393 */     return theServer.instantiate(className);
/*     */   }
/*     */ 
/*     */   public Object instantiate(String className, ObjectName loaderName)
/*     */     throws ReflectionException, MBeanException, InstanceNotFoundException
/*     */   {
/* 400 */     return theServer.instantiate(className, loaderName);
/*     */   }
/*     */ 
/*     */   public Object instantiate(String className, Object[] params, String[] signature)
/*     */     throws ReflectionException, MBeanException
/*     */   {
/* 407 */     return theServer.instantiate(className, params, signature);
/*     */   }
/*     */ 
/*     */   public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature)
/*     */     throws ReflectionException, MBeanException, InstanceNotFoundException
/*     */   {
/* 415 */     return theServer.instantiate(className, loaderName, params, signature);
/*     */   }
/*     */ 
/*     */   public ObjectInputStream deserialize(ObjectName name, byte[] data)
/*     */     throws InstanceNotFoundException, OperationsException
/*     */   {
/* 421 */     return getServer(name).deserialize(name, data);
/*     */   }
/*     */ 
/*     */   public ObjectInputStream deserialize(String className, byte[] data)
/*     */     throws OperationsException, ReflectionException
/*     */   {
/* 427 */     return theServer.deserialize(className, data);
/*     */   }
/*     */ 
/*     */   public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data)
/*     */     throws InstanceNotFoundException, OperationsException, ReflectionException
/*     */   {
/* 436 */     return theServer.deserialize(className, loaderName, data);
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoaderFor(ObjectName mbeanName)
/*     */     throws InstanceNotFoundException
/*     */   {
/* 442 */     return getServer(mbeanName).getClassLoaderFor(mbeanName);
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader(ObjectName loaderName)
/*     */     throws InstanceNotFoundException
/*     */   {
/* 448 */     return getServer(loaderName).getClassLoader(loaderName);
/*     */   }
/*     */ 
/*     */   public ClassLoaderRepository getClassLoaderRepository()
/*     */   {
/* 453 */     return theServer.getClassLoaderRepository();
/*     */   }
/*     */ 
/*     */   private MBeanServer getServer(ObjectName name)
/*     */   {
/* 467 */     String domain = name != null ? name.getDomain() : "";
/* 468 */     if (serverDomains.contains(domain))
/* 469 */       return theServer;
/* 470 */     if (platformServerDomains.contains(domain))
/* 471 */       return platformServer;
/* 472 */     return theServer;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.jmx.LazyMBeanServer
 * JD-Core Version:    0.6.0
 */