/*     */ package org.jboss.system.server.jmx;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Date;
/*     */ import java.util.List;
/*     */ import java.util.Properties;
/*     */ import javax.management.ListenerNotFoundException;
/*     */ import javax.management.MBeanNotificationInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ import javax.management.NotificationEmitter;
/*     */ import javax.management.NotificationFilter;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectInstance;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.classloader.spi.ClassLoaderSystem;
/*     */ import org.jboss.classloading.spi.RealClassLoader;
/*     */ import org.jboss.deployers.structure.spi.classloading.ExportAll;
/*     */ import org.jboss.deployers.vfs.plugins.classloader.VFSClassLoaderPolicy;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.loading.RepositoryClassLoader;
/*     */ import org.jboss.mx.util.JMXExceptionDecoder;
/*     */ import org.jboss.mx.util.MBeanServerLocator;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ import org.jboss.system.ServiceController;
/*     */ import org.jboss.system.ServiceControllerMBean;
/*     */ import org.jboss.system.server.Server;
/*     */ import org.jboss.system.server.ServerConfig;
/*     */ import org.jboss.system.server.ServerConfigImpl;
/*     */ import org.jboss.system.server.ServerConfigImplMBean;
/*     */ import org.jboss.system.server.ServerImplMBean;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.file.FileSuffixFilter;
/*     */ import org.jboss.virtual.VFS;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class JMXKernel extends JBossObject
/*     */   implements JMXKernelMBean, NotificationEmitter
/*     */ {
/*  74 */   private static final ObjectName DEFAULT_LOADER_NAME = ObjectNameFactory.create("JMImplementation:service=LoaderRepository,name=Default");
/*     */   private MBeanServer mbeanServer;
/*     */   private Server serverImpl;
/*     */   private ServiceController controller;
/*     */   private ServerConfig serverConfig;
/*     */   private ServerConfigImplMBean serverConfigMBean;
/*     */   private Kernel kernel;
/*     */   private NotificationEmitter notificationEmitter;
/*     */   private ObjectName bootstrapUCLName;
/*     */   private boolean started;
/*     */   private boolean oldClassLoader;
/*     */ 
/*     */   public Server getServerImpl()
/*     */   {
/*  96 */     return this.serverImpl;
/*     */   }
/*     */ 
/*     */   public void setServerImpl(Server serverImpl) {
/* 100 */     this.serverImpl = serverImpl;
/* 101 */     this.notificationEmitter = ((NotificationEmitter)serverImpl);
/*     */   }
/*     */ 
/*     */   public ServiceControllerMBean getServiceController()
/*     */   {
/* 106 */     return this.controller;
/*     */   }
/*     */ 
/*     */   public MBeanServer getMbeanServer() {
/* 110 */     return this.mbeanServer;
/*     */   }
/*     */ 
/*     */   public void setKernel(Kernel kernel)
/*     */   {
/* 120 */     this.kernel = kernel;
/*     */   }
/*     */ 
/*     */   public boolean isOldClassLoader()
/*     */   {
/* 125 */     return this.oldClassLoader;
/*     */   }
/*     */ 
/*     */   public void setOldClassLoader(boolean oldClassLoader)
/*     */   {
/* 130 */     this.oldClassLoader = oldClassLoader;
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 135 */     ClassLoader tcl = Thread.currentThread().getContextClassLoader();
/*     */ 
/* 137 */     String builder = System.getProperty("javax.management.builder.initial", "org.jboss.mx.server.MBeanServerBuilderImpl");
/*     */ 
/* 139 */     System.setProperty("javax.management.builder.initial", builder);
/*     */ 
/* 141 */     this.serverConfig = this.serverImpl.getConfig();
/* 142 */     this.serverConfigMBean = new ServerConfigImpl(this.serverConfig);
/*     */ 
/* 144 */     if (this.serverConfig.getPlatformMBeanServer() == true)
/*     */     {
/* 147 */       ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 148 */       Class clazz = cl.loadClass("java.lang.management.ManagementFactory");
/* 149 */       Class[] sig = null;
/* 150 */       Method method = clazz.getMethod("getPlatformMBeanServer", sig);
/* 151 */       Object[] args = null;
/* 152 */       this.mbeanServer = ((MBeanServer)method.invoke(null, args));
/*     */ 
/* 154 */       MBeanServerLocator.setJBoss(this.mbeanServer);
/*     */ 
/* 158 */       this.mbeanServer = LazyMBeanServer.resetToJBossServer(this.mbeanServer);
/*     */     }
/*     */     else
/*     */     {
/* 163 */       this.mbeanServer = MBeanServerFactory.createMBeanServer("jboss");
/*     */     }
/* 165 */     this.log.debug("Created MBeanServer: " + this.mbeanServer);
/*     */ 
/* 168 */     this.mbeanServer.registerMBean(this, ServerImplMBean.OBJECT_NAME);
/* 169 */     this.mbeanServer.registerMBean(this.serverConfigMBean, ServerConfigImplMBean.OBJECT_NAME);
/*     */ 
/* 172 */     ClassLoader cl = null;
/* 173 */     if (this.oldClassLoader)
/* 174 */       cl = initBootLibrariesOld();
/*     */     else {
/* 176 */       cl = initBootLibraries();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 183 */       Thread.currentThread().setContextClassLoader(cl);
/*     */ 
/* 186 */       createMBean("org.jboss.system.server.ServerInfo", "jboss.system:type=ServerInfo");
/*     */ 
/* 190 */       this.controller = new ServiceController();
/* 191 */       this.controller.setKernel(this.kernel);
/* 192 */       this.controller.setMBeanServer(this.mbeanServer);
/* 193 */       this.mbeanServer.registerMBean(this.controller, new ObjectName("jboss.system:service=ServiceController"));
/*     */ 
/* 195 */       this.log.info("Legacy JMX core initialized");
/* 196 */       this.started = true;
/*     */     }
/*     */     finally
/*     */     {
/* 200 */       Thread.currentThread().setContextClassLoader(tcl);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws IllegalStateException
/*     */   {
/* 211 */     if (this.log.isTraceEnabled()) {
/* 212 */       this.log.trace("stop caller:", new Throwable("Here"));
/*     */     }
/* 214 */     if (!this.started) {
/* 215 */       throw new IllegalStateException("Server not started");
/*     */     }
/* 217 */     this.log.debug("Shutting down all services");
/* 218 */     shutdownServices();
/*     */ 
/* 221 */     removeMBeans();
/*     */   }
/*     */ 
/*     */   public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
/*     */   {
/* 230 */     this.notificationEmitter.addNotificationListener(listener, filter, handback);
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException
/*     */   {
/* 235 */     this.notificationEmitter.removeNotificationListener(listener);
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
/*     */     throws ListenerNotFoundException
/*     */   {
/* 241 */     this.notificationEmitter.removeNotificationListener(listener, filter, handback);
/*     */   }
/*     */ 
/*     */   public MBeanNotificationInfo[] getNotificationInfo()
/*     */   {
/* 246 */     return this.notificationEmitter.getNotificationInfo();
/*     */   }
/*     */ 
/*     */   public void init(Properties props)
/*     */     throws Exception
/*     */   {
/* 252 */     this.serverImpl.init(props);
/*     */   }
/*     */ 
/*     */   public void exit()
/*     */   {
/* 257 */     this.serverImpl.exit();
/*     */   }
/*     */ 
/*     */   public void exit(int exitcode)
/*     */   {
/* 262 */     this.serverImpl.exit(exitcode);
/*     */   }
/*     */ 
/*     */   public ServerConfig getConfig()
/*     */   {
/* 267 */     return this.serverConfig;
/*     */   }
/*     */ 
/*     */   public String getBuildDate() {
/* 271 */     return this.serverImpl.getBuildDate();
/*     */   }
/*     */ 
/*     */   public String getBuildID()
/*     */   {
/* 276 */     return this.serverImpl.getBuildID();
/*     */   }
/*     */ 
/*     */   public String getBuildJVM()
/*     */   {
/* 281 */     return this.serverImpl.getBuildJVM();
/*     */   }
/*     */ 
/*     */   public String getBuildNumber()
/*     */   {
/* 286 */     return this.serverImpl.getBuildNumber();
/*     */   }
/*     */ 
/*     */   public String getBuildOS()
/*     */   {
/* 291 */     return this.serverImpl.getBuildOS();
/*     */   }
/*     */ 
/*     */   public Date getStartDate()
/*     */   {
/* 296 */     return this.serverImpl.getStartDate();
/*     */   }
/*     */ 
/*     */   public String getVersion()
/*     */   {
/* 301 */     return this.serverImpl.getVersion();
/*     */   }
/*     */ 
/*     */   public String getVersionName()
/*     */   {
/* 306 */     return this.serverImpl.getVersionName();
/*     */   }
/*     */ 
/*     */   public String getVersionNumber()
/*     */   {
/* 311 */     return this.serverImpl.getVersionNumber();
/*     */   }
/*     */ 
/*     */   public void halt()
/*     */   {
/* 316 */     this.serverImpl.halt();
/*     */   }
/*     */ 
/*     */   public void halt(int exitcode)
/*     */   {
/* 321 */     this.serverImpl.halt(exitcode);
/*     */   }
/*     */ 
/*     */   public boolean isInShutdown()
/*     */   {
/* 326 */     return this.serverImpl.isInShutdown();
/*     */   }
/*     */ 
/*     */   public boolean isStarted()
/*     */   {
/* 331 */     return this.serverImpl.isStarted();
/*     */   }
/*     */ 
/*     */   public void runFinalization()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void runGarbageCollector()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void traceInstructions(Boolean flag)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void traceMethodCalls(Boolean flag)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/* 356 */     if (this.log.isTraceEnabled())
/* 357 */       this.log.trace("Shutdown caller:", new Throwable("Here"));
/* 358 */     this.serverImpl.shutdown();
/*     */   }
/*     */ 
/*     */   protected void shutdownServices()
/*     */   {
/*     */     try
/*     */     {
/* 370 */       this.controller.shutdown();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 374 */       Throwable t = JMXExceptionDecoder.decode(e);
/* 375 */       this.log.error("Failed to shutdown services", t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void removeMBeans()
/*     */   {
/*     */     try
/*     */     {
/* 387 */       this.mbeanServer.unregisterMBean(ServerConfigImplMBean.OBJECT_NAME);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 391 */       Throwable t = JMXExceptionDecoder.decode(e);
/* 392 */       this.log.error("Failed to unregister mbeans", t);
/*     */     }
/*     */     try
/*     */     {
/* 396 */       this.mbeanServer.unregisterMBean(ServerImplMBean.OBJECT_NAME);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 400 */       Throwable t = JMXExceptionDecoder.decode(e);
/* 401 */       this.log.error("Failed to unregister mbeans", t);
/*     */     }
/*     */     try
/*     */     {
/* 405 */       MBeanServer registeredServer = this.mbeanServer;
/* 406 */       if (this.serverConfig.getPlatformMBeanServer() == true)
/* 407 */         registeredServer = LazyMBeanServer.getRegisteredMBeanServer(this.mbeanServer);
/* 408 */       MBeanServerFactory.releaseMBeanServer(registeredServer);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 412 */       Throwable t = JMXExceptionDecoder.decode(e);
/* 413 */       this.log.error("Failed to release mbean mbeanServer", t);
/*     */     }
/*     */   }
/*     */ 
/*     */   private List<URL> getBootURLs()
/*     */     throws Exception
/*     */   {
/* 427 */     List list = new ArrayList();
/*     */ 
/* 431 */     URL patchURL = this.serverConfig.getPatchURL();
/* 432 */     if (patchURL != null)
/*     */     {
/* 434 */       if (patchURL.getProtocol().equals("file"))
/*     */       {
/* 436 */         File dir = new File(patchURL.getFile());
/* 437 */         if (dir.exists())
/*     */         {
/* 440 */           list.add(dir.toURL());
/*     */ 
/* 443 */           File[] jars = dir.listFiles(new FileSuffixFilter(new String[] { ".jar", ".zip" }, true));
/*     */ 
/* 445 */           for (int j = 0; (jars != null) && (j < jars.length); j++)
/*     */           {
/* 447 */             list.add(jars[j].getCanonicalFile().toURL());
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 453 */         list.add(patchURL);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 458 */     list.add(this.serverConfig.getServerConfigURL());
/* 459 */     this.log.debug("Boot url list: " + list);
/*     */ 
/* 461 */     return list;
/*     */   }
/*     */ 
/*     */   private ClassLoader initBootLibrariesOld()
/*     */     throws Exception
/*     */   {
/* 472 */     List list = getBootURLs();
/*     */ 
/* 475 */     RepositoryClassLoader loader = null;
/* 476 */     for (URL url : list)
/*     */     {
/* 478 */       this.log.debug("Creating loader for URL: " + url);
/*     */ 
/* 481 */       Object[] args = { url, Boolean.TRUE };
/* 482 */       String[] sig = { "java.net.URL", "boolean" };
/* 483 */       loader = (RepositoryClassLoader)this.mbeanServer.invoke(DEFAULT_LOADER_NAME, "newClassLoader", args, sig);
/*     */     }
/* 485 */     this.bootstrapUCLName = loader.getObjectName();
/* 486 */     this.mbeanServer.registerMBean(loader, this.bootstrapUCLName);
/* 487 */     return loader;
/*     */   }
/*     */ 
/*     */   private ClassLoader initBootLibraries()
/*     */     throws Exception
/*     */   {
/* 498 */     ClassLoaderSystem system = ClassLoaderSystem.getInstance();
/*     */ 
/* 500 */     List list = getBootURLs();
/*     */ 
/* 502 */     VirtualFile[] files = new VirtualFile[list.size()];
/* 503 */     for (int i = 0; i < list.size(); i++)
/*     */     {
/* 505 */       URL url = (URL)list.get(i);
/* 506 */       files[i] = VFS.getRoot(url);
/*     */     }
/*     */ 
/* 509 */     VFSClassLoaderPolicy policy = new VFSClassLoaderPolicy(files);
/* 510 */     policy.setExportAll(ExportAll.NON_EMPTY);
/* 511 */     policy.setImportAll(true);
/* 512 */     ClassLoader classLoader = system.registerClassLoaderPolicy(policy);
/* 513 */     if ((classLoader instanceof RealClassLoader))
/*     */     {
/* 515 */       this.bootstrapUCLName = ((RealClassLoader)classLoader).getObjectName();
/* 516 */       this.mbeanServer.registerMBean(classLoader, this.bootstrapUCLName);
/*     */     }
/* 518 */     return classLoader;
/*     */   }
/*     */ 
/*     */   private ObjectName createMBean(String classname, String name)
/*     */     throws Exception
/*     */   {
/* 532 */     ObjectName mbeanName = null;
/* 533 */     if (name != null) {
/* 534 */       mbeanName = new ObjectName(name);
/*     */     }
/*     */     try
/*     */     {
/* 538 */       URL xmbeanDD = new URL("resource:xmdesc/" + classname + "-xmbean.xml");
/* 539 */       Object resource = this.mbeanServer.instantiate(classname);
/*     */ 
/* 541 */       Object[] args = { resource, xmbeanDD };
/* 542 */       String[] sig = { Object.class.getName(), URL.class.getName() };
/* 543 */       ObjectInstance instance = this.mbeanServer.createMBean("org.jboss.mx.modelmbean.XMBean", mbeanName, this.bootstrapUCLName, args, sig);
/*     */ 
/* 548 */       mbeanName = instance.getObjectName();
/* 549 */       this.log.debug("Created system XMBean: " + mbeanName);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 553 */       this.log.debug("Failed to create xmbean for: " + classname);
/* 554 */       mbeanName = this.mbeanServer.createMBean(classname, mbeanName).getObjectName();
/* 555 */       this.log.debug("Created system MBean: " + mbeanName);
/*     */     }
/*     */ 
/* 558 */     return mbeanName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.jmx.JMXKernel
 * JD-Core Version:    0.6.0
 */