/*     */ package org.jboss.system.server;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.InetAddress;
/*     */ import java.net.UnknownHostException;
/*     */ import java.text.DecimalFormat;
/*     */ import java.text.SimpleDateFormat;
/*     */ import java.util.Date;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import java.util.TreeSet;
/*     */ import javax.management.MBeanRegistration;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.platform.Java;
/*     */ 
/*     */ public class ServerInfo
/*     */   implements ServerInfoMBean, MBeanRegistration
/*     */ {
/*  57 */   private static final Logger log = Logger.getLogger(ServerInfo.class);
/*     */ 
/*  60 */   private static final Integer ZERO = new Integer(0);
/*     */ 
/*  63 */   private static final Class[] NO_PARAMS_SIG = new Class[0];
/*     */ 
/*  66 */   private static final Object[] NO_PARAMS = new Object[0];
/*     */ 
/*  69 */   private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
/*     */   private String hostName;
/*     */   private String hostAddress;
/*     */   private Object threadMXBean;
/*     */   private Method getMemoryPoolMXBeans;
/*     */   private Method getName;
/*     */   private Method getType;
/*     */   private Method getUsage;
/*     */   private Method getPeakUsage;
/*     */   private Method getInit;
/*     */   private Method getUsed;
/*     */   private Method getCommitted;
/*     */   private Method getMax;
/*     */   private Method getThreadInfo;
/*     */   private Method getAllThreadIds;
/*     */   private Method getThreadCpuTime;
/*     */   private Method getThreadName;
/*     */   private Method getThreadState;
/*     */   private Method getLockName;
/*     */   private Method getStackTrace;
/*     */   private Method getThreadId;
/*     */ 
/*     */   public ObjectName preRegister(MBeanServer server, ObjectName name)
/*     */     throws Exception
/*     */   {
/* 119 */     log.info("Java version: " + System.getProperty("java.version") + "," + System.getProperty("java.vendor"));
/*     */ 
/* 123 */     log.info("Java VM: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + "," + System.getProperty("java.vm.vendor"));
/*     */ 
/* 128 */     log.info("OS-System: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "," + System.getProperty("os.arch"));
/*     */ 
/* 134 */     log.debug("Full System Properties Dump");
/* 135 */     Enumeration names = System.getProperties().propertyNames();
/* 136 */     while (names.hasMoreElements())
/*     */     {
/* 138 */       String pname = (String)names.nextElement();
/* 139 */       log.debug("    " + pname + ": " + System.getProperty(pname));
/*     */     }
/*     */ 
/* 144 */     if (Java.isCompatible(6))
/*     */     {
/*     */       try
/*     */       {
/* 148 */         ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 149 */         Class clazz = cl.loadClass("java.lang.management.ManagementFactory");
/*     */ 
/* 152 */         Method method = clazz.getMethod("getThreadMXBean", NO_PARAMS_SIG);
/* 153 */         this.threadMXBean = method.invoke(null, NO_PARAMS);
/*     */ 
/* 156 */         this.getMemoryPoolMXBeans = clazz.getMethod("getMemoryPoolMXBeans", NO_PARAMS_SIG);
/*     */ 
/* 159 */         clazz = cl.loadClass("java.lang.management.MemoryPoolMXBean");
/* 160 */         this.getName = clazz.getMethod("getName", NO_PARAMS_SIG);
/* 161 */         this.getType = clazz.getMethod("getType", NO_PARAMS_SIG);
/* 162 */         this.getUsage = clazz.getMethod("getUsage", NO_PARAMS_SIG);
/* 163 */         this.getPeakUsage = clazz.getMethod("getPeakUsage", NO_PARAMS_SIG);
/*     */ 
/* 166 */         clazz = cl.loadClass("java.lang.management.MemoryUsage");
/* 167 */         this.getInit = clazz.getMethod("getInit", NO_PARAMS_SIG);
/* 168 */         this.getUsed = clazz.getMethod("getUsed", NO_PARAMS_SIG);
/* 169 */         this.getCommitted = clazz.getMethod("getCommitted", NO_PARAMS_SIG);
/* 170 */         this.getMax = clazz.getMethod("getMax", NO_PARAMS_SIG);
/*     */ 
/* 173 */         clazz = cl.loadClass("java.lang.management.ThreadMXBean");
/* 174 */         this.getThreadInfo = clazz.getMethod("getThreadInfo", new Class[] { Long.TYPE, Integer.TYPE });
/* 175 */         this.getAllThreadIds = clazz.getMethod("getAllThreadIds", NO_PARAMS_SIG);
/* 176 */         this.getThreadCpuTime = clazz.getMethod("getThreadCpuTime", new Class[] { Long.TYPE });
/*     */ 
/* 179 */         clazz = cl.loadClass("java.lang.management.ThreadInfo");
/* 180 */         this.getThreadName = clazz.getMethod("getThreadName", NO_PARAMS_SIG);
/* 181 */         this.getThreadState = clazz.getMethod("getThreadState", NO_PARAMS_SIG);
/* 182 */         this.getLockName = clazz.getMethod("getLockName", NO_PARAMS_SIG);
/*     */ 
/* 185 */         this.getStackTrace = clazz.getMethod("getStackTrace", NO_PARAMS_SIG);
/*     */ 
/* 188 */         clazz = Thread.class;
/* 189 */         this.getThreadId = clazz.getMethod("getId", NO_PARAMS_SIG);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 193 */         log.debug("Cannot access platform ThreadMXBean", e);
/*     */       }
/*     */     }
/*     */ 
/* 197 */     return name == null ? new ObjectName("jboss.system:type=ServerInfo") : name;
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean registrationDone)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void preDeregister()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void postDeregister()
/*     */   {
/*     */   }
/*     */ 
/*     */   public String getJavaVersion()
/*     */   {
/* 222 */     return System.getProperty("java.version");
/*     */   }
/*     */ 
/*     */   public String getJavaVendor()
/*     */   {
/* 227 */     return System.getProperty("java.vendor");
/*     */   }
/*     */ 
/*     */   public String getJavaVMName()
/*     */   {
/* 232 */     return System.getProperty("java.vm.name");
/*     */   }
/*     */ 
/*     */   public String getJavaVMVersion()
/*     */   {
/* 237 */     return System.getProperty("java.vm.version");
/*     */   }
/*     */ 
/*     */   public String getJavaVMVendor()
/*     */   {
/* 242 */     return System.getProperty("java.vm.vendor");
/*     */   }
/*     */ 
/*     */   public String getOSName()
/*     */   {
/* 247 */     return System.getProperty("os.name");
/*     */   }
/*     */ 
/*     */   public String getOSVersion()
/*     */   {
/* 252 */     return System.getProperty("os.version");
/*     */   }
/*     */ 
/*     */   public String getOSArch()
/*     */   {
/* 257 */     return System.getProperty("os.arch");
/*     */   }
/*     */ 
/*     */   public Long getTotalMemory()
/*     */   {
/* 262 */     return new Long(Runtime.getRuntime().totalMemory());
/*     */   }
/*     */ 
/*     */   public Long getFreeMemory()
/*     */   {
/* 267 */     return new Long(Runtime.getRuntime().freeMemory());
/*     */   }
/*     */ 
/*     */   public Long getMaxMemory()
/*     */   {
/* 276 */     if (Java.isCompatible(5))
/*     */     {
/*     */       try
/*     */       {
/* 282 */         Runtime rt = Runtime.getRuntime();
/* 283 */         Method m = rt.getClass().getMethod("maxMemory", NO_PARAMS_SIG);
/* 284 */         return (Long)m.invoke(rt, NO_PARAMS);
/*     */       }
/*     */       catch (Exception e) {
/* 287 */         log.error("Operation failed", e);
/*     */       }
/*     */     }
/*     */ 
/* 291 */     return new Long(-1L);
/*     */   }
/*     */ 
/*     */   public Integer getAvailableProcessors()
/*     */   {
/* 300 */     if (Java.isCompatible(5))
/*     */     {
/*     */       try
/*     */       {
/* 306 */         Runtime rt = Runtime.getRuntime();
/* 307 */         Method m = rt.getClass().getMethod("availableProcessors", NO_PARAMS_SIG);
/* 308 */         return (Integer)m.invoke(rt, NO_PARAMS);
/*     */       }
/*     */       catch (Exception e) {
/* 311 */         log.error("Operation failed", e);
/*     */       }
/*     */     }
/*     */ 
/* 315 */     return new Integer(-1);
/*     */   }
/*     */ 
/*     */   public String getHostName()
/*     */   {
/* 323 */     if (this.hostName == null)
/*     */     {
/*     */       try
/*     */       {
/* 327 */         this.hostName = InetAddress.getLocalHost().getHostName();
/*     */       }
/*     */       catch (UnknownHostException e)
/*     */       {
/* 331 */         log.error("Error looking up local hostname", e);
/* 332 */         this.hostName = "<unknown>";
/*     */       }
/*     */     }
/*     */ 
/* 336 */     return this.hostName;
/*     */   }
/*     */ 
/*     */   public String getHostAddress()
/*     */   {
/* 344 */     if (this.hostAddress == null)
/*     */     {
/*     */       try
/*     */       {
/* 348 */         this.hostAddress = InetAddress.getLocalHost().getHostAddress();
/*     */       }
/*     */       catch (UnknownHostException e)
/*     */       {
/* 352 */         log.error("Error looking up local address", e);
/* 353 */         this.hostAddress = "<unknown>";
/*     */       }
/*     */     }
/*     */ 
/* 357 */     return this.hostAddress;
/*     */   }
/*     */ 
/*     */   public String listMemoryPools(boolean fancy)
/*     */   {
/* 367 */     if (this.getMemoryPoolMXBeans != null)
/*     */     {
/* 370 */       StringBuffer sbuf = new StringBuffer(4196);
/*     */       try
/*     */       {
/* 374 */         List poolList = (List)this.getMemoryPoolMXBeans.invoke(null, NO_PARAMS);
/* 375 */         sbuf.append("<b>Total Memory Pools:</b> ").append(poolList.size());
/* 376 */         sbuf.append("<blockquote>");
/* 377 */         for (Iterator i = poolList.iterator(); i.hasNext(); )
/*     */         {
/* 380 */           Object pool = i.next();
/* 381 */           String name = (String)this.getName.invoke(pool, NO_PARAMS);
/*     */ 
/* 383 */           Object type = this.getType.invoke(pool, NO_PARAMS);
/* 384 */           sbuf.append("<b>Pool: ").append(name);
/* 385 */           sbuf.append("</b> (").append(type).append(")");
/*     */ 
/* 388 */           Object peakUsage = this.getPeakUsage.invoke(pool, NO_PARAMS);
/* 389 */           Object usage = this.getUsage.invoke(pool, NO_PARAMS);
/*     */ 
/* 391 */           sbuf.append("<blockquote>");
/* 392 */           if ((usage != null) && (peakUsage != null))
/*     */           {
/* 394 */             Long init = (Long)this.getInit.invoke(peakUsage, NO_PARAMS);
/* 395 */             Long used = (Long)this.getUsed.invoke(peakUsage, NO_PARAMS);
/* 396 */             Long committed = (Long)this.getCommitted.invoke(peakUsage, NO_PARAMS);
/* 397 */             Long max = (Long)this.getMax.invoke(peakUsage, NO_PARAMS);
/*     */ 
/* 399 */             sbuf.append("Peak Usage    : ");
/* 400 */             sbuf.append("init:").append(init);
/* 401 */             sbuf.append(", used:").append(used);
/* 402 */             sbuf.append(", committed:").append(committed);
/* 403 */             sbuf.append(", max:").append(max);
/* 404 */             sbuf.append("<br>");
/*     */ 
/* 406 */             init = (Long)this.getInit.invoke(usage, NO_PARAMS);
/* 407 */             used = (Long)this.getUsed.invoke(usage, NO_PARAMS);
/* 408 */             committed = (Long)this.getCommitted.invoke(usage, NO_PARAMS);
/* 409 */             max = (Long)this.getMax.invoke(usage, NO_PARAMS);
/*     */ 
/* 411 */             sbuf.append("Current Usage : ");
/* 412 */             sbuf.append("init:").append(init);
/* 413 */             sbuf.append(", used:").append(used);
/* 414 */             sbuf.append(", committed:").append(committed);
/* 415 */             sbuf.append(", max:").append(max);
/*     */ 
/* 417 */             if (fancy)
/*     */             {
/* 419 */               TextGraphHelper.poolUsage(sbuf, used.longValue(), committed.longValue(), max.longValue());
/*     */             }
/*     */           }
/*     */           else
/*     */           {
/* 424 */             sbuf.append("Memory pool NOT valid!");
/*     */           }
/* 426 */           sbuf.append("</blockquote><br>");
/*     */         }
/* 428 */         sbuf.append("</blockquote>");
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */ 
/* 434 */       return sbuf.toString();
/*     */     }
/*     */ 
/* 438 */     return "<b>Memory pool information available only under a JDK5+ compatible JVM!</b>";
/*     */   }
/*     */ 
/*     */   public Integer getActiveThreadCount()
/*     */   {
/* 444 */     return new Integer(getRootThreadGroup().activeCount());
/*     */   }
/*     */ 
/*     */   public Integer getActiveThreadGroupCount()
/*     */   {
/* 449 */     return new Integer(getRootThreadGroup().activeGroupCount());
/*     */   }
/*     */ 
/*     */   public String listThreadDump()
/*     */   {
/* 457 */     ThreadGroup root = getRootThreadGroup();
/*     */ 
/* 462 */     ThreadGroupCount count = new ThreadGroupCount(null);
/*     */ 
/* 465 */     String threadGroupInfo = getThreadGroupInfo(root, count);
/*     */ 
/* 468 */     String threadDump = "<b>Total Threads:</b> " + count.threads + "<br>" + "<b>Total Thread Groups:</b> " + count.groups + "<br>" + "<b>Timestamp:</b> " + dateFormat.format(new Date()) + "<br>" + threadGroupInfo;
/*     */ 
/* 474 */     return threadDump;
/*     */   }
/*     */ 
/*     */   public String listThreadCpuUtilization()
/*     */   {
/* 482 */     Set threads = getThreadCpuUtilization();
/*     */ 
/* 484 */     if (threads == null)
/*     */     {
/* 486 */       return "Thread cpu utilization requires J2SE5+";
/*     */     }
/*     */ 
/* 490 */     long totalCPU = 0L;
/* 491 */     StringBuffer buffer = new StringBuffer();
/* 492 */     buffer.append("<table><tr><th>Thread Name</th><th>CPU (milliseconds)</th></tr>");
/* 493 */     for (Iterator i = threads.iterator(); i.hasNext(); )
/*     */     {
/* 495 */       ThreadCPU thread = (ThreadCPU)i.next();
/* 496 */       buffer.append("<tr><td>").append(thread.name).append("</td><td>");
/* 497 */       buffer.append(thread.cpuTime).append("</td></tr>");
/* 498 */       totalCPU += thread.cpuTime;
/*     */     }
/* 500 */     buffer.append("<tr><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td>Total</td><td>");
/* 501 */     buffer.append(totalCPU).append("</td></tr></table>");
/* 502 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   private Set<ThreadCPU> getThreadCpuUtilization()
/*     */   {
/* 517 */     if (this.threadMXBean == null) {
/* 518 */       return null;
/*     */     }
/*     */     try
/*     */     {
/* 522 */       TreeSet result = new TreeSet();
/* 523 */       long[] threads = (long[])(long[])this.getAllThreadIds.invoke(this.threadMXBean, NO_PARAMS);
/* 524 */       for (int i = 0; i < threads.length; i++)
/*     */       {
/* 526 */         Long id = new Long(threads[i]);
/* 527 */         Long cpuTime = (Long)this.getThreadCpuTime.invoke(this.threadMXBean, new Object[] { id });
/* 528 */         Object threadInfo = this.getThreadInfo.invoke(this.threadMXBean, new Object[] { id, ZERO });
/* 529 */         if (threadInfo == null)
/*     */           continue;
/* 531 */         String name = (String)this.getThreadName.invoke(threadInfo, NO_PARAMS);
/* 532 */         result.add(new ThreadCPU(name, cpuTime.longValue()));
/*     */       }
/*     */ 
/* 535 */       return result;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 539 */       log.warn("Error retrieving thread cpu utiliation", e);
/* 540 */     }return null;
/*     */   }
/*     */ 
/*     */   private ThreadGroup getRootThreadGroup()
/*     */   {
/* 549 */     ThreadGroup group = Thread.currentThread().getThreadGroup();
/* 550 */     while (group.getParent() != null)
/*     */     {
/* 552 */       group = group.getParent();
/*     */     }
/*     */ 
/* 555 */     return group;
/*     */   }
/*     */ 
/*     */   private String getThreadGroupInfo(ThreadGroup group, ThreadGroupCount count)
/*     */   {
/* 563 */     StringBuffer rc = new StringBuffer();
/*     */ 
/* 566 */     count.groups += 1;
/*     */ 
/* 568 */     rc.append("<br><b>");
/* 569 */     rc.append("Thread Group: " + group.getName());
/* 570 */     rc.append("</b> : ");
/* 571 */     rc.append("max priority:" + group.getMaxPriority() + ", demon:" + group.isDaemon());
/*     */ 
/* 574 */     rc.append("<blockquote>");
/* 575 */     Thread[] threads = new Thread[group.activeCount()];
/* 576 */     group.enumerate(threads, false);
/* 577 */     for (int i = 0; (i < threads.length) && (threads[i] != null); i++)
/*     */     {
/* 580 */       count.threads += 1;
/*     */ 
/* 582 */       rc.append("<b>");
/* 583 */       rc.append("Thread: " + threads[i].getName());
/* 584 */       rc.append("</b> : ");
/* 585 */       rc.append("priority:" + threads[i].getPriority() + ", demon:" + threads[i].isDaemon());
/*     */ 
/* 588 */       outputJdk5ThreadMXBeanInfo(rc, threads[i]);
/*     */     }
/*     */ 
/* 591 */     ThreadGroup[] groups = new ThreadGroup[group.activeGroupCount()];
/* 592 */     group.enumerate(groups, false);
/* 593 */     for (int i = 0; (i < groups.length) && (groups[i] != null); i++)
/*     */     {
/* 595 */       rc.append(getThreadGroupInfo(groups[i], count));
/*     */     }
/* 597 */     rc.append("</blockquote>");
/*     */ 
/* 599 */     return rc.toString();
/*     */   }
/*     */ 
/*     */   private void outputJdk5ThreadMXBeanInfo(StringBuffer sbuf, Thread thread)
/*     */   {
/* 609 */     if (this.threadMXBean != null)
/*     */     {
/*     */       try
/*     */       {
/* 615 */         Long threadId = (Long)this.getThreadId.invoke(thread, NO_PARAMS);
/* 616 */         sbuf.append(", threadId:").append(threadId);
/*     */ 
/* 619 */         Object threadInfo = this.getThreadInfo.invoke(this.threadMXBean, new Object[] { threadId, new Integer(2147483647) });
/*     */ 
/* 622 */         if (threadInfo != null)
/*     */         {
/* 625 */           Object threadState = this.getThreadState.invoke(threadInfo, NO_PARAMS);
/* 626 */           String lockName = (String)this.getLockName.invoke(threadInfo, NO_PARAMS);
/*     */ 
/* 629 */           Object[] stackTrace = (Object[])(Object[])this.getStackTrace.invoke(threadInfo, NO_PARAMS);
/*     */ 
/* 631 */           sbuf.append(", threadState:").append(threadState);
/* 632 */           sbuf.append(", lockName:").append(lockName);
/*     */ 
/* 635 */           sbuf.append("<br>");
/* 636 */           if (stackTrace.length > 0)
/*     */           {
/* 638 */             sbuf.append("<blockquote>");
/* 639 */             for (int i = 0; i < stackTrace.length; i++)
/*     */             {
/* 641 */               sbuf.append(stackTrace[i]).append("<br>");
/*     */             }
/* 643 */             sbuf.append("</blockquote>");
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 648 */           sbuf.append("<br>");
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Exception ignore)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 659 */       sbuf.append("<br>");
/*     */     }
/*     */   }
/*     */ 
/*     */   public String displayPackageInfo(String pkgName)
/*     */   {
/* 668 */     Package pkg = Package.getPackage(pkgName);
/* 669 */     if (pkg == null) {
/* 670 */       return "<h2>Package:" + pkgName + " Not Found!</h2>";
/*     */     }
/* 672 */     StringBuffer info = new StringBuffer("<h2>Package: " + pkgName + "</h2>");
/* 673 */     displayPackageInfo(pkg, info);
/* 674 */     return info.toString();
/*     */   }
/*     */ 
/*     */   private void displayPackageInfo(Package pkg, StringBuffer info)
/*     */   {
/* 679 */     info.append("<pre>\n");
/* 680 */     info.append("SpecificationTitle: " + pkg.getSpecificationTitle());
/* 681 */     info.append("\nSpecificationVersion: " + pkg.getSpecificationVersion());
/* 682 */     info.append("\nSpecificationVendor: " + pkg.getSpecificationVendor());
/* 683 */     info.append("\nImplementationTitle: " + pkg.getImplementationTitle());
/* 684 */     info.append("\nImplementationVersion: " + pkg.getImplementationVersion());
/* 685 */     info.append("\nImplementationVendor: " + pkg.getImplementationVendor());
/* 686 */     info.append("\nisSealed: " + pkg.isSealed());
/* 687 */     info.append("</pre>\n");
/*     */   }
/*     */ 
/*     */   private static class ThreadGroupCount
/*     */   {
/*     */     public int threads;
/*     */     public int groups;
/*     */   }
/*     */ 
/*     */   private static class ThreadCPU
/*     */     implements Comparable
/*     */   {
/*     */     public String name;
/*     */     public long cpuTime;
/*     */ 
/*     */     public ThreadCPU(String name, long cpuTime)
/*     */     {
/* 824 */       this.name = name;
/* 825 */       this.cpuTime = (cpuTime / 1000000L);
/*     */     }
/*     */ 
/*     */     public int compareTo(Object o)
/*     */     {
/* 830 */       ThreadCPU other = (ThreadCPU)o;
/* 831 */       long value = this.cpuTime - other.cpuTime;
/* 832 */       if (value > 0L)
/* 833 */         return -1;
/* 834 */       if (value < 0L) {
/* 835 */         return 1;
/*     */       }
/* 837 */       return this.name.compareTo(other.name);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class TextGraphHelper
/*     */   {
/* 702 */     static final DecimalFormat formatter = new DecimalFormat("#.##");
/*     */     static final long KILO = 1024L;
/*     */     static final long MEGA = 1048576L;
/*     */     static final long GIGA = 1073741824L;
/*     */     static final int factor = 70;
/*     */     static char[] fixedline;
/*     */     static char[] baseline;
/*     */     static char[] barline;
/*     */     static char[] spaces;
/*     */ 
/*     */     public static void poolUsage(StringBuffer sbuf, long used, long committed, long max)
/*     */     {
/* 762 */       long assumedMax = max == -1L ? committed : max;
/*     */ 
/* 764 */       int localUsed = (int)(70L * used / assumedMax);
/* 765 */       int localCommitted = (int)(70L * committed / assumedMax);
/* 766 */       int localMax = 70;
/*     */ 
/* 768 */       sbuf.append("<blockquote><br>");
/* 769 */       sbuf.append(baseline, 0, localCommitted).append("| committed:").append(outputNumber(committed)).append("<br>");
/* 770 */       sbuf.append(fixedline).append("<br>");
/*     */ 
/* 773 */       sbuf.append(barline, 0, localUsed);
/* 774 */       if (localUsed < localCommitted)
/*     */       {
/* 776 */         sbuf.append(localUsed > 0 ? '/' : '|');
/* 777 */         sbuf.append(spaces, 0, localCommitted - localUsed - 1);
/*     */       }
/* 779 */       sbuf.append('|');
/* 780 */       if (localCommitted < localMax)
/*     */       {
/* 782 */         sbuf.append(spaces, 0, localMax - localCommitted - 1);
/* 783 */         sbuf.append('|');
/*     */       }
/* 785 */       sbuf.append(" max:").append(outputNumber(max)).append("<br>");
/*     */ 
/* 787 */       sbuf.append(fixedline).append("<br>");
/* 788 */       sbuf.append(baseline, 0, localUsed).append("| used:").append(outputNumber(used));
/* 789 */       sbuf.append("</blockquote>");
/*     */     }
/*     */ 
/*     */     private static String outputNumber(long value)
/*     */     {
/* 794 */       if (value >= 1073741824L)
/*     */       {
/* 796 */         return formatter.format(value / 1073741824.0D) + "Gb";
/*     */       }
/* 798 */       if (value >= 1048576L)
/*     */       {
/* 800 */         return formatter.format(value / 1048576.0D) + "Mb";
/*     */       }
/* 802 */       if (value >= 1024L)
/*     */       {
/* 804 */         return formatter.format(value / 1024.0D) + "Kb";
/*     */       }
/* 806 */       if (value >= 0L)
/*     */       {
/* 808 */         return value + "b";
/*     */       }
/*     */ 
/* 812 */       return Long.toString(value);
/*     */     }
/*     */ 
/*     */     static
/*     */     {
/* 716 */       StringBuffer sbuf0 = new StringBuffer();
/* 717 */       StringBuffer sbuf1 = new StringBuffer();
/* 718 */       StringBuffer sbuf2 = new StringBuffer();
/* 719 */       StringBuffer sbuf3 = new StringBuffer();
/* 720 */       sbuf0.append('+');
/* 721 */       sbuf1.append('|');
/* 722 */       sbuf2.append('|');
/* 723 */       for (int i = 1; i < 70; i++)
/*     */       {
/* 725 */         sbuf0.append('-');
/* 726 */         sbuf1.append('-');
/* 727 */         sbuf2.append('/');
/* 728 */         sbuf3.append(' ');
/*     */       }
/* 730 */       sbuf0.append('+');
/* 731 */       fixedline = sbuf0.toString().toCharArray();
/* 732 */       baseline = sbuf1.toString().toCharArray();
/* 733 */       barline = sbuf2.toString().toCharArray();
/* 734 */       spaces = sbuf3.toString().toCharArray();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.ServerInfo
 * JD-Core Version:    0.6.0
 */