/*     */ package org.jboss.system.server;
/*     */ 
/*     */ import java.net.InetAddress;
/*     */ import java.net.UnknownHostException;
/*     */ 
/*     */ public class ServerConfigUtil
/*     */ {
/*     */   private static final String ANY = "0.0.0.0";
/*     */ 
/*     */   public static String getDefaultBindAddress()
/*     */   {
/*  44 */     return System.getProperty("jboss.bind.address");
/*     */   }
/*     */ 
/*     */   public static String getSpecificBindAddress()
/*     */   {
/*  54 */     String address = System.getProperty("jboss.bind.address");
/*  55 */     if ((address == null) || (address.equals("0.0.0.0")))
/*  56 */       return null;
/*  57 */     return address;
/*     */   }
/*     */ 
/*     */   public static InetAddress fixRemoteAddress(InetAddress address)
/*     */   {
/*     */     try
/*     */     {
/*  72 */       if ((address == null) || (InetAddress.getByName("0.0.0.0").equals(address)))
/*  73 */         return InetAddress.getLocalHost();
/*     */     }
/*     */     catch (UnknownHostException ignored)
/*     */     {
/*     */     }
/*  78 */     return address;
/*     */   }
/*     */ 
/*     */   public static String fixRemoteAddress(String address)
/*     */   {
/*     */     try
/*     */     {
/*  93 */       if ((address == null) || ("0.0.0.0".equals(address)))
/*  94 */         return InetAddress.getLocalHost().getHostName();
/*     */     }
/*     */     catch (UnknownHostException ignored)
/*     */     {
/*     */     }
/*  99 */     return address;
/*     */   }
/*     */ 
/*     */   public static String getDefaultPartitionName()
/*     */   {
/* 109 */     return System.getProperty("jboss.partition.name", "DefaultPartition");
/*     */   }
/*     */ 
/*     */   public static boolean isLoadNative()
/*     */   {
/* 119 */     return Boolean.getBoolean("jboss.native.load");
/*     */   }
/*     */ 
/*     */   public static String shortUrlFromServerHome(String longUrl)
/*     */   {
/* 130 */     String serverHomeUrl = System.getProperty("jboss.server.home.url");
/*     */ 
/* 132 */     if ((longUrl == null) || (serverHomeUrl == null)) {
/* 133 */       return longUrl;
/*     */     }
/* 135 */     if (longUrl.startsWith(serverHomeUrl)) {
/* 136 */       return ".../" + longUrl.substring(serverHomeUrl.length());
/*     */     }
/*     */ 
/* 139 */     String jarServerHomeUrl = "jar:" + serverHomeUrl;
/* 140 */     if (longUrl.startsWith(jarServerHomeUrl)) {
/* 141 */       return ".../" + longUrl.substring(jarServerHomeUrl.length());
/*     */     }
/* 143 */     return longUrl;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.ServerConfigUtil
 * JD-Core Version:    0.6.0
 */