/*     */ package org.jboss.system.pm;
/*     */ 
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.mx.persistence.AttributePersistenceManager;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class AttributePersistenceService extends ServiceMBeanSupport
/*     */   implements AttributePersistenceServiceMBean
/*     */ {
/*     */   public static final String DEFAULT_APM = "org.jboss.system.pm.XMLAttributePersistenceManager";
/*     */   public static final boolean DEFAULT_DESTROY_APM_ON_STOP = false;
/*  75 */   private AttributePersistenceManager apm = null;
/*     */ 
/*  78 */   private Element apmConfig = null;
/*     */ 
/*  81 */   private String apmClass = "org.jboss.system.pm.XMLAttributePersistenceManager";
/*     */ 
/*  84 */   private boolean apmDestroyOnStop = false;
/*     */ 
/*  87 */   private String versionTag = null;
/*     */ 
/*     */   public AttributePersistenceService()
/*     */   {
/*  97 */     super(AttributePersistenceService.class);
/*     */   }
/*     */ 
/*     */   public String getVersionTag()
/*     */   {
/* 108 */     return this.versionTag;
/*     */   }
/*     */ 
/*     */   public void setVersionTag(String versionTag)
/*     */   {
/* 117 */     checkNotStarted();
/* 118 */     this.versionTag = versionTag;
/*     */   }
/*     */ 
/*     */   public String getAttributePersistenceManagerClass()
/*     */   {
/* 127 */     return this.apmClass;
/*     */   }
/*     */ 
/*     */   public void setAttributePersistenceManagerClass(String apmClass)
/*     */   {
/* 136 */     checkNotStarted();
/* 137 */     this.apmClass = apmClass;
/*     */   }
/*     */ 
/*     */   public Element getAttributePersistenceManagerConfig()
/*     */   {
/* 146 */     return this.apmConfig;
/*     */   }
/*     */ 
/*     */   public void setAttributePersistenceManagerConfig(Element apmConfig)
/*     */   {
/* 155 */     checkNotStarted();
/* 156 */     this.apmConfig = apmConfig;
/*     */   }
/*     */ 
/*     */   public boolean getApmDestroyOnServiceStop()
/*     */   {
/* 165 */     return this.apmDestroyOnStop;
/*     */   }
/*     */ 
/*     */   public void setApmDestroyOnServiceStop(boolean apmDestroyOnStop)
/*     */   {
/* 173 */     checkNotStarted();
/* 174 */     this.apmDestroyOnStop = apmDestroyOnStop;
/*     */   }
/*     */ 
/*     */   public void startService()
/*     */     throws Exception
/*     */   {
/* 183 */     this.apm = ((AttributePersistenceManager)getServer().instantiate(this.apmClass));
/*     */ 
/* 186 */     this.apm.create(this.versionTag, this.apmConfig);
/*     */   }
/*     */ 
/*     */   public void stopService()
/*     */   {
/* 192 */     if (this.apmDestroyOnStop) {
/* 193 */       this.apm.destroy();
/*     */     }
/*     */ 
/* 197 */     this.apm = null;
/*     */   }
/*     */ 
/*     */   public AttributePersistenceManager apmCreate()
/*     */   {
/* 207 */     checkStarted();
/*     */ 
/* 209 */     return this.apm;
/*     */   }
/*     */ 
/*     */   public boolean apmExists(String id)
/*     */     throws Exception
/*     */   {
/* 218 */     checkStarted();
/*     */ 
/* 220 */     return this.apm.exists(id);
/*     */   }
/*     */ 
/*     */   public void apmRemove(String id)
/*     */     throws Exception
/*     */   {
/* 229 */     checkStarted();
/*     */ 
/* 231 */     this.apm.remove(id);
/*     */   }
/*     */ 
/*     */   public void apmRemoveAll()
/*     */     throws Exception
/*     */   {
/* 240 */     checkStarted();
/*     */ 
/* 242 */     this.apm.removeAll();
/*     */   }
/*     */ 
/*     */   public String[] apmListAll()
/*     */     throws Exception
/*     */   {
/* 251 */     checkStarted();
/*     */ 
/* 253 */     return this.apm.listAll();
/*     */   }
/*     */ 
/*     */   public String apmListAllAsString()
/*     */     throws Exception
/*     */   {
/* 262 */     checkStarted();
/*     */ 
/* 264 */     StringBuffer sbuf = new StringBuffer(1024);
/* 265 */     String[] list = this.apm.listAll();
/*     */ 
/* 267 */     for (int i = 0; i < list.length; i++) {
/* 268 */       sbuf.append(list[i]).append("\n");
/*     */     }
/* 270 */     return sbuf.toString();
/*     */   }
/*     */ 
/*     */   private void checkStarted()
/*     */   {
/* 277 */     int state = getState();
/*     */ 
/* 279 */     if (state != 3)
/* 280 */       throw new IllegalStateException("Cannot perform operations unless service is started");
/*     */   }
/*     */ 
/*     */   private void checkNotStarted()
/*     */   {
/* 286 */     int state = getState();
/*     */ 
/* 288 */     if ((state == 2) || (state == 3))
/* 289 */       throw new IllegalStateException("Cannot modify attributes while service is started");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.pm.AttributePersistenceService
 * JD-Core Version:    0.6.0
 */