/*     */ package org.jboss.system.microcontainer.jmx;
/*     */ 
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.StandardMBean;
/*     */ import org.jboss.aop.microcontainer.aspects.jmx.JMX;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ScopeInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.system.ServiceController;
/*     */ 
/*     */ public class ServiceControllerLifecycleCallback
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(ServiceControllerLifecycleCallback.class);
/*     */   private ServiceController serviceController;
/*     */ 
/*     */   public ServiceController getServiceController()
/*     */   {
/*  56 */     return this.serviceController;
/*     */   }
/*     */ 
/*     */   public void setServiceController(ServiceController serviceController)
/*     */   {
/*  66 */     this.serviceController = serviceController;
/*     */   }
/*     */ 
/*     */   public void create() throws Exception
/*     */   {
/*  71 */     if (this.serviceController == null)
/*  72 */       throw new IllegalStateException("No service controller configured");
/*     */   }
/*     */ 
/*     */   public void install(ControllerContext context) throws Exception
/*     */   {
/*  77 */     JMX jmx = readJmxAnnotation(context);
/*  78 */     ObjectName objectName = createObjectName(context, jmx);
/*     */ 
/*  80 */     Class intfClass = null;
/*  81 */     boolean registerDirectly = false;
/*  82 */     if (jmx != null)
/*     */     {
/*  84 */       intfClass = jmx.exposedInterface();
/*  85 */       registerDirectly = jmx.registerDirectly();
/*     */     }
/*  87 */     Object mbean = registerDirectly ? context.getTarget() : new StandardMBean(context.getTarget(), intfClass);
/*     */ 
/*  89 */     MBeanServer server = this.serviceController.getMBeanServer();
/*  90 */     server.registerMBean(mbean, objectName);
/*     */     try
/*     */     {
/*  93 */       this.serviceController.start(objectName);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       try
/*     */       {
/*  99 */         server.unregisterMBean(objectName);
/*     */       }
/*     */       catch (Exception t)
/*     */       {
/* 103 */         log.debug("Error unregistering mbean", t);
/*     */       }
/* 105 */       throw e;
/*     */     }
/* 107 */     log.debug("Registered MBean " + objectName);
/*     */   }
/*     */ 
/*     */   public void uninstall(ControllerContext context) throws Exception
/*     */   {
/* 112 */     JMX jmx = readJmxAnnotation(context);
/* 113 */     ObjectName objectName = createObjectName(context, jmx);
/*     */ 
/* 115 */     log.debug("Unregistering MBean " + objectName);
/* 116 */     this.serviceController.destroy(objectName);
/*     */   }
/*     */ 
/*     */   private JMX readJmxAnnotation(ControllerContext context) throws Exception
/*     */   {
/* 121 */     MetaData metaData = context.getScopeInfo().getMetaData();
/* 122 */     if (metaData != null)
/* 123 */       return (JMX)metaData.getAnnotation(JMX.class);
/* 124 */     return null;
/*     */   }
/*     */ 
/*     */   private ObjectName createObjectName(ControllerContext context, JMX jmx) throws Exception
/*     */   {
/* 129 */     ObjectName objectName = null;
/* 130 */     if (jmx != null)
/*     */     {
/* 132 */       String jmxName = jmx.name();
/* 133 */       if ((jmxName != null) && (jmxName.length() > 0)) {
/* 134 */         objectName = new ObjectName(jmxName);
/*     */       }
/*     */     }
/* 137 */     if (objectName == null)
/*     */     {
/* 140 */       String name = (String)context.getName();
/*     */ 
/* 142 */       if (name.contains(":"))
/*     */       {
/* 144 */         objectName = new ObjectName(name);
/*     */       }
/*     */       else
/*     */       {
/* 148 */         objectName = new ObjectName("test:name='" + name + "'");
/*     */       }
/*     */     }
/*     */ 
/* 152 */     return objectName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.microcontainer.jmx.ServiceControllerLifecycleCallback
 * JD-Core Version:    0.6.0
 */