/*     */ package org.jboss.system.microcontainer;
/*     */ 
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.HashMap;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.mx.util.JMXExceptionDecoder;
/*     */ import org.jboss.system.Service;
/*     */ import org.jboss.system.ServiceController;
/*     */ 
/*     */ public class ServiceProxy
/*     */   implements InvocationHandler
/*     */ {
/*  62 */   private static HashMap<String, Integer> serviceOpMap = new HashMap();
/*     */ 
/*  75 */   private boolean[] hasOp = { false, false, false, false };
/*     */   private ObjectName objectName;
/*     */   private MBeanServer server;
/*     */   private boolean hasJBossInternalLifecycle;
/*     */ 
/*     */   public static Service getServiceProxy(ObjectName objectName, MBeanServer server)
/*     */     throws Exception
/*     */   {
/*  92 */     Service service = null;
/*  93 */     MBeanInfo info = server.getMBeanInfo(objectName);
/*  94 */     MBeanOperationInfo[] opInfo = info.getOperations();
/*  95 */     Class[] interfaces = { Service.class };
/*  96 */     InvocationHandler handler = new ServiceProxy(objectName, server, opInfo);
/*  97 */     service = (Service)Proxy.newProxyInstance(Service.class.getClassLoader(), interfaces, handler);
/*     */ 
/*  99 */     return service;
/*     */   }
/*     */ 
/*     */   public ServiceProxy(ObjectName objectName, MBeanServer server, MBeanOperationInfo[] opInfo)
/*     */   {
/* 113 */     this.server = server;
/* 114 */     this.objectName = objectName;
/*     */ 
/* 116 */     for (int op = 0; op < opInfo.length; op++)
/*     */     {
/* 118 */       MBeanOperationInfo info = opInfo[op];
/* 119 */       String name = info.getName();
/*     */ 
/* 121 */       if (name.equals("jbossInternalLifecycle"))
/*     */       {
/* 123 */         this.hasJBossInternalLifecycle = true;
/*     */       }
/*     */       else
/*     */       {
/* 127 */         Integer opID = (Integer)serviceOpMap.get(name);
/* 128 */         if (opID == null)
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/* 134 */         if (!info.getReturnType().equals("void"))
/*     */         {
/*     */           continue;
/*     */         }
/* 138 */         if (info.getSignature().length != 0)
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/* 143 */         this.hasOp[opID.intValue()] = true;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 161 */     String name = method.getName();
/*     */ 
/* 163 */     if (this.hasJBossInternalLifecycle)
/*     */     {
/*     */       try
/*     */       {
/* 167 */         this.server.invoke(this.objectName, "jbossInternalLifecycle", new Object[] { name }, ServiceController.JBOSS_INTERNAL_LIFECYCLE_SIG);
/* 168 */         return null;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 172 */         throw JMXExceptionDecoder.decode(e);
/*     */       }
/*     */     }
/*     */ 
/* 176 */     Integer opID = (Integer)serviceOpMap.get(name);
/*     */ 
/* 178 */     if ((opID != null) && (this.hasOp[opID.intValue()] == 1))
/*     */     {
/*     */       try
/*     */       {
/* 183 */         String[] sig = new String[0];
/* 184 */         this.server.invoke(this.objectName, name, args, sig);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 188 */         throw JMXExceptionDecoder.decode(e);
/*     */       }
/*     */     }
/*     */ 
/* 192 */     return null;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  69 */     serviceOpMap.put("create", new Integer(0));
/*  70 */     serviceOpMap.put("start", new Integer(1));
/*  71 */     serviceOpMap.put("destroy", new Integer(2));
/*  72 */     serviceOpMap.put("stop", new Integer(3));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.microcontainer.ServiceProxy
 * JD-Core Version:    0.6.0
 */