/*    */ package org.jboss.system.microcontainer;
/*    */ 
/*    */ import javax.management.MBeanServer;
/*    */ import javax.management.ObjectName;
/*    */ import org.jboss.system.ServiceController;
/*    */ import org.jboss.system.ServiceCreator;
/*    */ import org.jboss.system.ServiceInstance;
/*    */ import org.jboss.system.metadata.ServiceMetaData;
/*    */ 
/*    */ public class InstantiateAction extends ServiceControllerContextAction
/*    */ {
/*    */   public void installAction(ServiceControllerContext context)
/*    */     throws Throwable
/*    */   {
/* 41 */     MBeanServer server = context.getServiceController().getMBeanServer();
/* 42 */     ObjectName objectName = context.getObjectName();
/* 43 */     ServiceMetaData metaData = context.getServiceMetaData();
/* 44 */     Object mbean = context.getTarget();
/* 45 */     ServiceInstance instance = ServiceCreator.install(server, objectName, metaData, mbean);
/* 46 */     context.setTarget(instance.getResource());
/*    */   }
/*    */ 
/*    */   public void uninstallAction(ServiceControllerContext context)
/*    */   {
/* 51 */     MBeanServer server = context.getServiceController().getMBeanServer();
/* 52 */     ObjectName objectName = context.getObjectName();
/* 53 */     ServiceCreator.uninstall(server, objectName);
/* 54 */     ServiceMetaData metaData = context.getServiceMetaData();
/* 55 */     if (metaData != null)
/* 56 */       context.setTarget(null);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.microcontainer.InstantiateAction
 * JD-Core Version:    0.6.0
 */