/*     */ package org.jboss.system.metadata;
/*     */ 
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.system.ServiceController;
/*     */ 
/*     */ public class ServiceValueContext
/*     */ {
/*     */   private MBeanServer server;
/*     */   private ServiceController controller;
/*     */   private MBeanAttributeInfo attributeInfo;
/*     */   private ClassLoader classloader;
/*     */   private boolean trim;
/*     */   private boolean replace;
/*     */ 
/*     */   public ServiceValueContext()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ServiceValueContext(MBeanServer server, ServiceController controller, ClassLoader classloader)
/*     */   {
/*  73 */     this.server = server;
/*  74 */     this.controller = controller;
/*  75 */     this.classloader = classloader;
/*     */   }
/*     */ 
/*     */   public ServiceValueContext(MBeanServer server, ServiceController controller, MBeanAttributeInfo attributeInfo, ClassLoader classloader)
/*     */   {
/*  88 */     this.server = server;
/*  89 */     this.controller = controller;
/*  90 */     this.attributeInfo = attributeInfo;
/*  91 */     this.classloader = classloader;
/*     */   }
/*     */ 
/*     */   public MBeanAttributeInfo getAttributeInfo()
/*     */   {
/* 101 */     return this.attributeInfo;
/*     */   }
/*     */ 
/*     */   public void setAttributeInfo(MBeanAttributeInfo attributeInfo)
/*     */   {
/* 111 */     this.attributeInfo = attributeInfo;
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassloader()
/*     */   {
/* 121 */     return this.classloader;
/*     */   }
/*     */ 
/*     */   public void setClassloader(ClassLoader classloader)
/*     */   {
/* 131 */     this.classloader = classloader;
/*     */   }
/*     */ 
/*     */   public boolean isReplace()
/*     */   {
/* 141 */     return this.replace;
/*     */   }
/*     */ 
/*     */   public void setReplace(boolean replace)
/*     */   {
/* 151 */     this.replace = replace;
/*     */   }
/*     */ 
/*     */   public MBeanServer getServer()
/*     */   {
/* 161 */     if (this.server == null)
/*     */     {
/* 163 */       if (this.controller == null) {
/* 164 */         throw new IllegalStateException("No MBeanServer");
/*     */       }
/* 166 */       return this.controller.getMBeanServer();
/*     */     }
/* 168 */     return this.server;
/*     */   }
/*     */ 
/*     */   public void setServer(MBeanServer server)
/*     */   {
/* 178 */     this.server = server;
/*     */   }
/*     */ 
/*     */   public ServiceController getServiceController()
/*     */   {
/* 188 */     if (this.controller == null)
/* 189 */       throw new IllegalStateException("No ServiceController");
/* 190 */     return this.controller;
/*     */   }
/*     */ 
/*     */   public void setServiceController(ServiceController controller)
/*     */   {
/* 200 */     this.controller = controller;
/*     */   }
/*     */ 
/*     */   public boolean isTrim()
/*     */   {
/* 210 */     return this.trim;
/*     */   }
/*     */ 
/*     */   public void setTrim(boolean trim)
/*     */   {
/* 220 */     this.trim = trim;
/*     */   }
/*     */ 
/*     */   public Kernel getKernel()
/*     */   {
/* 230 */     return getServiceController().getKernel();
/*     */   }
/*     */ 
/*     */   public KernelController getController()
/*     */   {
/* 240 */     return getKernel().getController();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.metadata.ServiceValueContext
 * JD-Core Version:    0.6.0
 */