/*     */ package org.jboss.system.metadata;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.dependency.spi.ControllerMode;
/*     */ import org.jboss.managed.api.annotation.ManagementObject;
/*     */ import org.jboss.managed.api.annotation.ManagementObjectID;
/*     */ import org.jboss.managed.api.annotation.ManagementProperty;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ @ManagementObject
/*     */ public class ServiceMetaData extends AbstractMetaDataVisitorNode
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   public static final String XMBEAN_CODE = "org.jboss.mx.modelmbean.XMBean";
/*     */   private ObjectName objectName;
/*     */   private String code;
/*     */   private ControllerMode mode;
/*     */   private String interfaceName;
/*     */   private ServiceConstructorMetaData constructor;
/*     */   private String xmbeanDD;
/*  70 */   private String xmbeanCode = "org.jboss.mx.modelmbean.XMBean";
/*     */   private Element xmbeanDescriptor;
/*  76 */   private List<ServiceAttributeMetaData> attributes = Collections.emptyList();
/*     */ 
/*  79 */   private List<ServiceDependencyMetaData> dependencies = Collections.emptyList();
/*     */ 
/*  81 */   private List<ServiceAnnotationMetaData> annotations = Collections.emptyList();
/*     */   private ObjectName classLoaderName;
/*     */   private List<String> aliases;
/*     */ 
/*     */   @ManagementProperty(description="The service JMX object name")
/*     */   @ManagementObjectID(type="ServiceMBean")
/*     */   public ObjectName getObjectName()
/*     */   {
/*  97 */     return this.objectName;
/*     */   }
/*     */ 
/*     */   public void setObjectName(ObjectName objectName)
/*     */   {
/* 107 */     if (objectName == null)
/* 108 */       throw new IllegalArgumentException("Null objectName");
/* 109 */     this.objectName = objectName;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(description="The service bean class")
/*     */   public String getCode()
/*     */   {
/* 120 */     return this.code;
/*     */   }
/*     */ 
/*     */   public void setCode(String code)
/*     */   {
/* 130 */     if (code == null)
/* 131 */       throw new IllegalArgumentException("Null code");
/* 132 */     this.code = code;
/*     */   }
/*     */ 
/*     */   public ControllerMode getMode()
/*     */   {
/* 142 */     return this.mode;
/*     */   }
/*     */ 
/*     */   public void setMode(ControllerMode mode)
/*     */   {
/* 152 */     this.mode = mode;
/*     */   }
/*     */ 
/*     */   public ServiceConstructorMetaData getConstructor()
/*     */   {
/* 162 */     return this.constructor;
/*     */   }
/*     */ 
/*     */   public void setConstructor(ServiceConstructorMetaData constructor)
/*     */   {
/* 172 */     this.constructor = constructor;
/*     */   }
/*     */ 
/*     */   public String getInterfaceName()
/*     */   {
/* 182 */     return this.interfaceName;
/*     */   }
/*     */ 
/*     */   public void setInterfaceName(String interfaceName)
/*     */   {
/* 192 */     this.interfaceName = interfaceName;
/*     */   }
/*     */ 
/*     */   public String getXMBeanCode()
/*     */   {
/* 202 */     return this.xmbeanCode;
/*     */   }
/*     */ 
/*     */   public void setXMBeanCode(String xmbeanCode)
/*     */   {
/* 212 */     if (xmbeanCode == null)
/* 213 */       throw new IllegalArgumentException("Null xmbeanCode");
/* 214 */     this.xmbeanCode = xmbeanCode;
/*     */   }
/*     */ 
/*     */   public String getXMBeanDD()
/*     */   {
/* 224 */     return this.xmbeanDD;
/*     */   }
/*     */ 
/*     */   public void setXMBeanDD(String xmbeanDD)
/*     */   {
/* 234 */     this.xmbeanDD = xmbeanDD;
/*     */   }
/*     */ 
/*     */   public Element getXMBeanDescriptor()
/*     */   {
/* 244 */     return this.xmbeanDescriptor;
/*     */   }
/*     */ 
/*     */   public void setXMBeanDescriptor(Element xmbeanDescriptor)
/*     */   {
/* 254 */     this.xmbeanDescriptor = xmbeanDescriptor;
/*     */   }
/*     */ 
/*     */   public List<ServiceAttributeMetaData> getAttributes()
/*     */   {
/* 264 */     return this.attributes;
/*     */   }
/*     */ 
/*     */   public void setAttributes(List<ServiceAttributeMetaData> attributes)
/*     */   {
/* 274 */     if (attributes == null)
/* 275 */       throw new IllegalArgumentException("Null attributes");
/* 276 */     this.attributes = attributes;
/*     */   }
/*     */ 
/*     */   public List<ServiceDependencyMetaData> getDependencies()
/*     */   {
/* 286 */     return this.dependencies;
/*     */   }
/*     */ 
/*     */   public void setDependencies(List<ServiceDependencyMetaData> dependencies)
/*     */   {
/* 296 */     if (dependencies == null)
/* 297 */       throw new IllegalArgumentException("Null dependencies");
/* 298 */     this.dependencies = dependencies;
/*     */   }
/*     */ 
/*     */   public List<ServiceAnnotationMetaData> getAnnotations()
/*     */   {
/* 307 */     return this.annotations;
/*     */   }
/*     */ 
/*     */   public void setAnnotations(List<ServiceAnnotationMetaData> annotations)
/*     */   {
/* 315 */     if (annotations == null)
/* 316 */       throw new IllegalArgumentException("Null annotations");
/* 317 */     this.annotations = annotations;
/*     */   }
/*     */ 
/*     */   public ObjectName getClassLoaderName()
/*     */   {
/* 327 */     return this.classLoaderName;
/*     */   }
/*     */ 
/*     */   public void setClassLoaderName(ObjectName classLoaderName)
/*     */   {
/* 337 */     this.classLoaderName = classLoaderName;
/*     */   }
/*     */ 
/*     */   public List<String> getAliases()
/*     */   {
/* 347 */     return this.aliases;
/*     */   }
/*     */ 
/*     */   public void setAliases(List<String> aliases)
/*     */   {
/* 357 */     this.aliases = aliases;
/*     */   }
/*     */ 
/*     */   protected void addChildren(Set<ServiceMetaDataVisitorNode> children)
/*     */   {
/* 362 */     children.addAll(this.attributes);
/* 363 */     children.addAll(this.dependencies);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.metadata.ServiceMetaData
 * JD-Core Version:    0.6.0
 */