/*     */ package org.jboss.system.metadata;
/*     */ 
/*     */ import java.util.Properties;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.util.propertyeditor.PropertyEditors;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class ServiceJavaBeanValueMetaData extends ServiceElementValueMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */ 
/*     */   public ServiceJavaBeanValueMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ServiceJavaBeanValueMetaData(Element element)
/*     */   {
/*  66 */     super(element);
/*     */   }
/*     */ 
/*     */   public Object getValue(ServiceValueContext valueContext) throws Exception
/*     */   {
/*  71 */     MBeanAttributeInfo attributeInfo = valueContext.getAttributeInfo();
/*  72 */     ClassLoader cl = valueContext.getClassloader();
/*  73 */     boolean trim = valueContext.isTrim();
/*  74 */     boolean replace = valueContext.isReplace();
/*     */ 
/*  77 */     Element element = getElement();
/*  78 */     String attributeClassName = element.getAttribute("attributeClass");
/*  79 */     if ((attributeClassName == null) || (attributeClassName.length() == 0))
/*  80 */       attributeClassName = attributeInfo.getType();
/*  81 */     if (attributeClassName == null)
/*  82 */       throw new DeploymentException("AttributeInfo for " + attributeInfo.getName() + " has no type");
/*  83 */     Class attributeClass = cl.loadClass(attributeClassName);
/*     */ 
/*  85 */     Object bean = attributeClass.newInstance();
/*     */ 
/*  87 */     NodeList properties = element.getElementsByTagName("property");
/*  88 */     Properties beanProps = new Properties();
/*  89 */     for (int n = 0; n < properties.getLength(); n++)
/*     */     {
/*  92 */       Node node = properties.item(n);
/*  93 */       if (node.getNodeType() != 1)
/*     */       {
/*     */         continue;
/*     */       }
/*  97 */       Element property = (Element)node;
/*  98 */       String name = property.getAttribute("name");
/*  99 */       String value = ServiceMetaDataParser.getElementTextContent(property, trim, replace);
/* 100 */       beanProps.setProperty(name, value);
/*     */     }
/*     */ 
/* 104 */     PropertyEditors.mapJavaBeanProperties(bean, beanProps);
/* 105 */     return bean;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.metadata.ServiceJavaBeanValueMetaData
 * JD-Core Version:    0.6.0
 */